/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigTable;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDevicePollConfigEntry
extends BComponent
implements ModbusMessageConst {
    public static final Property enabled = BDevicePollConfigEntry.newProperty((int)0, (boolean)true, null);
    public static final Property startAddress = BDevicePollConfigEntry.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property dataType = BDevicePollConfigEntry.newProperty((int)0, (BValue)BRegisterTypesEnum.holdingRegister, null);
    public static final Property consecutivePointsToPoll = BDevicePollConfigEntry.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)9999));
    public static final Property readGroupSize = BDevicePollConfigEntry.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)2));
    public static final Property readStatus = BDevicePollConfigEntry.newProperty((int)3, (BValue)new BCommStatus(-2), null);
    public static final Type TYPE;
    private byte[] byteArray;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BDevicePollConfigEntry;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BFlexAddress getStartAddress() {
        return (BFlexAddress)this.get(startAddress);
    }

    public void setStartAddress(BFlexAddress bFlexAddress) {
        this.set(startAddress, (BValue)bFlexAddress, null);
    }

    public BRegisterTypesEnum getDataType() {
        return (BRegisterTypesEnum)this.get(dataType);
    }

    public void setDataType(BRegisterTypesEnum bRegisterTypesEnum) {
        this.set(dataType, (BValue)bRegisterTypesEnum, null);
    }

    public int getConsecutivePointsToPoll() {
        return this.getInt(consecutivePointsToPoll);
    }

    public void setConsecutivePointsToPoll(int n) {
        this.setInt(consecutivePointsToPoll, n, null);
    }

    public int getReadGroupSize() {
        return this.getInt(readGroupSize);
    }

    public void setReadGroupSize(int n) {
        this.setInt(readGroupSize, n, null);
    }

    public BCommStatus getReadStatus() {
        return (BCommStatus)this.get(readStatus);
    }

    public void setReadStatus(BCommStatus bCommStatus) {
        this.set(readStatus, (BValue)bCommStatus, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BDevicePollConfigTable;
    }

    public String toString(Context context) {
        return this.getDataType().getTag() + ": " + this.getStartAddress().getDataAddressNoModbusAltering() + " - " + (this.getStartAddress().getDataAddressNoModbusAltering() + this.getConsecutivePointsToPoll() - 1) + ": " + (this.getEnabled() ? this.getLexicon().getText("devicePoll.strings.enabled") : this.getLexicon().getText("devicePoll.strings.disabled"));
    }

    public String toDebugString() {
        return this.getDataType().getTag() + ": " + this.getStartAddress().getDataAddressNoModbusAltering() + " - " + (this.getStartAddress().getDataAddressNoModbusAltering() + this.getConsecutivePointsToPoll() - 1) + ": " + (this.getEnabled() ? "enabled" : "disabled");
    }

    public BModbusClientDevice getDevice() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BModbusClientDevice) {
                return (BModbusClientDevice)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public void validateAddress() {
        BFlexAddress bFlexAddress = this.getStartAddress();
        if (bFlexAddress.isModbusFormat()) {
            if (bFlexAddress.isModbusHoldingAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.holdingRegister, null);
            } else if (bFlexAddress.isModbusInputAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.inputRegister, null);
            } else if (bFlexAddress.isModbusCoilAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.discreteCoil, null);
            } else if (bFlexAddress.isModbusStatusAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.discreteInput, null);
            }
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)dataType) || property.equals((Object)startAddress)) {
            if (context != null) {
                this.validateAddress();
                if (this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
                    ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
                }
            }
        } else if ((property.equals((Object)enabled) || property.equals((Object)consecutivePointsToPoll)) && this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
        }
    }

    public void setByteArray(byte[] byArray) {
        this.byteArray = byArray;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byteArray = null;
    }

    public BDevicePollConfigEntry() {
        this.this();
    }

    public BDevicePollConfigEntry(boolean bl, BRegisterTypesEnum bRegisterTypesEnum, BFlexAddress bFlexAddress, int n, int n2) {
        this.this();
        this.setEnabled(bl);
        this.setDataType(bRegisterTypesEnum);
        this.setStartAddress(bFlexAddress);
        this.setConsecutivePointsToPoll(n);
        this.setReadGroupSize(n2);
    }

    public BDevicePollConfigEntry(BDevicePollConfigEntry bDevicePollConfigEntry) {
        this.this();
        this.copyFrom((BComplex)bDevicePollConfigEntry);
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$datatypes$BDevicePollConfigEntry;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$datatypes$BDevicePollConfigEntry = BDevicePollConfigEntry.class("[Lcom.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

