/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import java.io.IOException;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.ext.BActivePeriod;
import javax.baja.history.ext.BBasicActivePeriod;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHistoryExt
extends BPointExtension
implements BIHistorySource {
    public static final Property status = BHistoryExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BHistoryExt.newProperty((int)3, (String)"", null);
    public static final Property enabled = BHistoryExt.newProperty((int)64, (boolean)false, null);
    public static final Property activePeriod = BHistoryExt.newProperty((int)0, (BValue)new BBasicActivePeriod(), null);
    public static final Property active = BHistoryExt.newProperty((int)3, (boolean)false, null);
    public static final Property historyName = BHistoryExt.newProperty((int)0, (BValue)BFormat.make((String)"%parent.name%"), null);
    public static final Property historyNameFormat = BHistoryExt.newProperty((int)6, (BValue)BFormat.make((String)"%parent.name%"), null);
    public static final Property historyConfig = BHistoryExt.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    public static final Property lastRecord = BHistoryExt.newProperty((int)3, (BValue)new BStringTrendRecord(), null);
    public static final Action updateHistoryId = BHistoryExt.newAction((int)16, null);
    public static final Action syncConfig = BHistoryExt.newAction((int)20, null);
    public static final Action activate = BHistoryExt.newAction((int)20, null);
    public static final Action deactivate = BHistoryExt.newAction((int)20, null);
    public static final Type TYPE;
    public static final Log log;
    private boolean start;
    private BIHistory history;
    private Clock.Ticket ticket;
    private boolean initHistorySuccessful;
    private BFacets localFacets;
    private boolean inInit;
    private BAbsTime nextValidThreshold;
    static /* synthetic */ Class class$javax$baja$history$ext$BHistoryExt;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BActivePeriod getActivePeriod() {
        return (BActivePeriod)this.get(activePeriod);
    }

    public void setActivePeriod(BActivePeriod bActivePeriod) {
        this.set(activePeriod, (BValue)bActivePeriod, null);
    }

    public boolean getActive() {
        return this.getBoolean(active);
    }

    public void setActive(boolean bl) {
        this.setBoolean(active, bl, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat bFormat) {
        this.set(historyName, (BValue)bFormat, null);
    }

    public BFormat getHistoryNameFormat() {
        return (BFormat)this.get(historyNameFormat);
    }

    public void setHistoryNameFormat(BFormat bFormat) {
        this.set(historyNameFormat, (BValue)bFormat, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig bHistoryConfig) {
        this.set(historyConfig, (BValue)bHistoryConfig, null);
    }

    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    public void setLastRecord(BHistoryRecord bHistoryRecord) {
        this.set(lastRecord, (BValue)bHistoryRecord, null);
    }

    public void updateHistoryId() {
        this.invoke(updateHistoryId, null, null);
    }

    public void syncConfig() {
        this.invoke(syncConfig, null, null);
    }

    public void activate() {
        this.invoke(activate, null, null);
    }

    public void deactivate() {
        this.invoke(deactivate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
    }

    protected boolean isSiblingLegal(BComponent bComponent) {
        return true;
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        this.setActive(this.getActivePeriod().isActive(BAbsTime.make()));
        Type type = this.getRecordType();
        if (!type.is(BTrendRecord.TYPE)) {
            throw new HistoryException("Record type must be a trend record. (actual type = " + type.getTypeSpec() + ')');
        }
        BHistoryConfig bHistoryConfig = this.getHistoryConfig();
        if (!bHistoryConfig.getRecordType().equals((Object)type.getTypeSpec())) {
            bHistoryConfig.setRecordType(type.getTypeSpec());
        }
        this.syncFacets();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        this.init();
    }

    private final void init() {
        this.syncFacets();
        if (this.getEnabled()) {
            try {
                this.initHistory();
                this.checkPointSubscription();
            }
            catch (Exception exception) {
                this.setFault(exception);
                return;
            }
        }
        this.updateStatus();
        try {
            this.scheduleActivation();
        }
        catch (HistoryException historyException) {
            throw historyException;
        }
        catch (Exception exception) {
            throw new HistoryException(exception);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.history = null;
    }

    public void changed(Property property, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BHistoryService bHistoryService = null;
        try {
            bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return;
        }
        if (property.equals((Object)enabled)) {
            if (this.getEnabled()) {
                this.init();
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                    this.ticket = null;
                }
                this.history = null;
                this.checkPointSubscription();
                this.updateStatus();
            }
        } else if (property.equals((Object)historyName)) {
            if (this.inInit) {
                return;
            }
            this.initHistory();
        } else if (property.equals((Object)activePeriod)) {
            boolean bl = this.getActive();
            boolean bl2 = this.getActivePeriod().isActive(BAbsTime.make());
            try {
                if (bl != bl2) {
                    if (this.ticket != null) {
                        this.ticket.cancel();
                        this.ticket = null;
                    }
                    if (bl2) {
                        this.activate();
                    }
                    this.deactivate();
                }
                this.scheduleActivation();
            }
            catch (HistoryException historyException) {
                throw historyException;
            }
            catch (Exception exception) {
                throw new HistoryException(exception);
            }
        } else if (!property.equals((Object)status) && !property.equals((Object)faultCause)) {
            this.updateStatus();
        }
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
        this.syncFacets();
        if (!this.getEnabled() || !Sys.atSteadyState()) {
            return;
        }
        if (this.isRunning()) {
            BAbsTime bAbsTime = BAbsTime.make();
            if (this.getActive()) {
                try {
                    this.pointChanged(bAbsTime, bStatusValue);
                }
                catch (HistoryException historyException) {
                    throw historyException;
                }
                catch (Exception exception) {
                    throw new HistoryException(exception);
                }
            }
        }
    }

    public abstract void pointChanged(BAbsTime var1, BStatusValue var2) throws Exception;

    public boolean requiresPointSubscription() {
        return this.getEnabled();
    }

    public void checkPointSubscription() {
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint != null) {
            bControlPoint.checkExtensionsRequireSubscription();
        }
    }

    public void updateStatus() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("");
        } else {
            boolean bl = this.getHistoryConfig().getId().isValid();
            if (!bl) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid history name.");
            } else if (this.initHistorySuccessful) {
                if (this.nextValidThreshold != null) {
                    this.setStatus(BStatus.fault);
                    this.setFaultCause("Cannot append out-of-order or duplicate record. This could occur on a backwards system clock change. Next append can occur after " + this.nextValidThreshold);
                } else {
                    this.setStatus(BStatus.ok);
                    this.setFaultCause("");
                }
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            }
        }
    }

    private final void scheduleActivation() throws IOException {
        BActivePeriod bActivePeriod;
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if ((bActivePeriod = this.getActivePeriod()).isNeverActive()) {
            return;
        }
        BAbsTime bAbsTime = BAbsTime.make();
        if (bActivePeriod.isActive(bAbsTime)) {
            this.activate();
        } else {
            BAbsTime bAbsTime2 = bActivePeriod.getNextActive(bAbsTime);
            if (bAbsTime2 != null) {
                if (log.isTraceOn()) {
                    log.trace(this.getSlotPath() + ": next active " + bAbsTime2.toString((Context)BHistoryRecord.TIMESTAMP_FACETS));
                }
                this.ticket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime2, (Action)activate, null);
            }
        }
    }

    public void doActivate() {
        this.start = true;
        try {
            BAbsTime bAbsTime = BAbsTime.make();
            this.setActive(true);
            if (this.getActivePeriod().isAlwaysActive()) {
                this.activated(bAbsTime.timeOfDay(0, 0, 0, 0), bAbsTime, this.getParentPoint().getStatusValue());
            } else {
                BAbsTime bAbsTime2 = this.getActivePeriod().getActiveStart(bAbsTime);
                this.activated(bAbsTime2, bAbsTime, this.getParentPoint().getStatusValue());
            }
            this.scheduleDeactivation();
        }
        catch (HistoryException historyException) {
            throw historyException;
        }
        catch (Exception exception) {
            throw new HistoryException(exception);
        }
    }

    protected abstract void activated(BAbsTime var1, BAbsTime var2, BStatusValue var3) throws IOException;

    private final void scheduleDeactivation() throws IOException {
        BActivePeriod bActivePeriod;
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if ((bActivePeriod = this.getActivePeriod()).isNeverActive()) {
            return;
        }
        BAbsTime bAbsTime = BAbsTime.make();
        if (bActivePeriod.isActive(bAbsTime)) {
            BAbsTime bAbsTime2 = bActivePeriod.getNextInactive(bAbsTime);
            if (bAbsTime2 != null) {
                if (log.isTraceOn()) {
                    log.trace(this.getSlotPath() + ": next inactive " + bAbsTime2.toString((Context)BHistoryRecord.TIMESTAMP_FACETS));
                }
                this.ticket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime2, (Action)deactivate, null);
            }
        } else {
            this.deactivate();
        }
    }

    public void doDeactivate() {
        try {
            this.setActive(false);
            this.deactivated(BAbsTime.make(), this.getParentPoint().getStatusValue());
            this.scheduleActivation();
        }
        catch (HistoryException historyException) {
            throw historyException;
        }
        catch (Exception exception) {
            throw new HistoryException(exception);
        }
    }

    protected abstract void deactivated(BAbsTime var1, BStatusValue var2) throws IOException;

    public BIHistory getHistory() {
        return this.history;
    }

    public String resolveHistoryName() {
        BFormat bFormat = this.getHistoryName();
        return SlotPath.escape((String)SlotPath.unescape((String)bFormat.format((Object)this)));
    }

    private final synchronized void initHistory() throws ServiceNotFoundException {
        this.initHistorySuccessful = false;
        if (!this.getEnabled()) {
            return;
        }
        try {
            Object object;
            Object object2;
            this.inInit = true;
            BFormat bFormat = this.getHistoryNameFormat();
            String string = this.getHistoryConfig().getHistoryName();
            if (string.length() != 0) {
                this.getHistoryConfig().setHistoryName("");
                this.setHistoryNameFormat(BFormat.DEFAULT);
                object2 = bFormat.format((Object)this);
                if (!string.equals(object2)) {
                    this.setHistoryName(BFormat.make((String)string));
                } else {
                    this.setHistoryName(bFormat);
                }
            }
            this.inInit = false;
            object2 = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = object2.getDatabase();
            BHistoryConfig bHistoryConfig = this.getHistoryConfig();
            BOrdList bOrdList = BOrdList.make((BOrd)this.getSourceOrd());
            BOrd bOrd = this.getHandleOrd();
            if (!bHistoryConfig.getSource().equals((Object)bOrdList)) {
                bHistoryConfig.setSource(bOrdList);
            }
            if (!bHistoryConfig.getSourceHandle().equals((Object)bOrd)) {
                bHistoryConfig.setSourceHandle(bOrd);
            }
            if (!bHistoryConfig.getTimeZone().equals((Object)BTimeZone.getLocal())) {
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
            }
            String string2 = this.resolveHistoryName();
            BHistoryId.validateName(string2);
            BHistoryId bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), string2);
            BHistoryId bHistoryId2 = bHistoryConfig.getId();
            if (!bHistoryId2.getHistoryName().equals(bHistoryId.getHistoryName()) && !bHistoryId2.isNull()) {
                this.renameAttachedHistory(bHistoryDatabase, bHistoryId2, bHistoryId);
            }
            if (!bHistoryId2.equals((Object)bHistoryId)) {
                bHistoryConfig.setId(bHistoryId);
                bHistoryId2 = bHistoryId;
            }
            BControlPoint bControlPoint = this.getParentPoint();
            BFacets bFacets = bControlPoint.getFacets();
            BTrendRecord bTrendRecord = (BTrendRecord)bHistoryConfig.makeRecord();
            Property property = bTrendRecord.getValueProperty();
            String string3 = property.getName() + "Facets";
            Property property2 = bHistoryConfig.loadSlots().getProperty(string3);
            if (property2 == null) {
                bHistoryConfig.add(string3, (BValue)bFacets);
            } else {
                object = (BFacets)bHistoryConfig.get(property2);
                if (!object.equals((Object)bFacets)) {
                    bHistoryConfig.set(property2, (BValue)bFacets);
                }
            }
            this.initConfig(bHistoryConfig);
            if (!bHistoryDatabase.exists(bHistoryId2) && this.getEnabled()) {
                bHistoryDatabase.createHistory(bHistoryConfig);
            } else if (bHistoryDatabase.exists(bHistoryId2)) {
                object = bHistoryDatabase.getHistory(bHistoryId2);
                BHistoryConfig bHistoryConfig2 = object.getConfig();
                BOrdList bOrdList2 = bHistoryConfig2.getSource();
                if (bOrdList2.size() != 1) {
                    throw new HistoryException("Duplicate history id: " + (Object)((Object)bHistoryConfig.getId()) + ". Source mismatch.");
                }
                Object object3 = bOrdList2.get(0);
                BObject bObject = null;
                try {
                    bObject = object3.resolve((BObject)this).get();
                }
                catch (Exception exception) {}
                if (bObject != null && bObject != this) {
                    throw new HistoryException("Duplicate history id: " + (Object)((Object)bHistoryConfig.getId()));
                }
                bHistoryDatabase.reconfigureHistory(bHistoryConfig);
                try {
                    object = bHistoryDatabase.getHistory(bHistoryId2);
                    object3 = object.getLastRecord();
                    if (object3 != null) {
                        this.setLastRecord((BHistoryRecord)object3);
                    }
                }
                catch (Exception exception) {
                    log.error("Could not initialize 'Last Record' property for history ext " + this.toPathString(), (Throwable)exception);
                }
            }
            if (this.getEnabled()) {
                this.history = bHistoryDatabase.getHistory(bHistoryId2);
                if (this.history == null) {
                    throw new HistoryException("Cannot open history: " + (Object)((Object)bHistoryId2));
                }
            }
        }
        catch (Exception exception) {
            this.setFault(exception);
            return;
        }
        this.setFault(false, "");
        if (this.getEnabled()) {
            this.initHistorySuccessful = true;
        }
    }

    protected void initConfig(BHistoryConfig bHistoryConfig) {
    }

    public void historyConfigChanged(BHistoryConfig bHistoryConfig, Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (bHistoryConfig != this.getHistoryConfig()) {
            return;
        }
        this.updateStatus();
        this.syncConfig();
    }

    private final void renameAttachedHistory(BHistoryDatabase bHistoryDatabase, BHistoryId bHistoryId, BHistoryId bHistoryId2) {
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId2);
        if (bIHistory != null) {
            BHistoryConfig bHistoryConfig = bIHistory.getConfig();
            BOrdList bOrdList = bHistoryConfig.getSource();
            BOrd bOrd = bHistoryConfig.getSourceHandle();
            if (bOrdList.size() != 1 || !bOrd.isNull() && !bOrd.equals((Object)this.getHandleOrd())) {
                throw new HistoryException("Cannot rename attached history.  The target id is already in use.");
            }
            log.warning("Rename failed for " + (Object)((Object)bHistoryId) + ".  New data will be written to " + (Object)((Object)bHistoryId2));
            return;
        }
        BIHistory bIHistory2 = bHistoryDatabase.getHistory(bHistoryId);
        if (bIHistory2 == null) {
            return;
        }
        BHistoryConfig bHistoryConfig = bIHistory2.getConfig();
        BOrdList bOrdList = bHistoryConfig.getSource();
        BOrd bOrd = bHistoryConfig.getSourceHandle();
        if (bOrdList.size() != 1) {
            return;
        }
        if (!bOrd.isNull() && !bOrd.equals((Object)this.getHandleOrd())) {
            return;
        }
        bHistoryDatabase.renameHistory(bHistoryId, bHistoryId2.getHistoryName());
    }

    public void doUpdateHistoryId() {
        BHistoryId bHistoryId;
        String string = this.resolveHistoryName();
        BHistoryId bHistoryId2 = this.getHistoryConfig().getId();
        if (!bHistoryId2.equals((Object)(bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), string)))) {
            this.initHistory();
        }
    }

    public synchronized void doSyncConfig() {
        if (this.initHistorySuccessful) {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
            bHistoryDatabase.reconfigureHistory(this.getHistoryConfig());
        }
    }

    public abstract Type getRecordType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void append(BTrendRecord bTrendRecord) throws IOException, HistoryException {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.isRunning()) return;
        if (!Sys.atSteadyState()) return;
        if (this.start) {
            bTrendRecord.setTrendFlags(bTrendRecord.getTrendFlags().set(1, true));
        }
        int n = 0;
        while (n < 2) {
            try {
                block13: {
                    BHistoryExt bHistoryExt = this;
                    synchronized (bHistoryExt) {
                        BRelTime bRelTime;
                        if (this.history == null) {
                            this.initHistory();
                        }
                        if (this.history != null) {
                            BCollectionInterval bCollectionInterval = this.getHistoryConfig().getInterval();
                            bRelTime = null;
                            bRelTime = bCollectionInterval.isIrregular() ? BRelTime.make((long)0L) : BRelTime.make((long)(bCollectionInterval.getInterval().getMillis() / (long)2));
                        }
                        break block13;
                        BAbsTime bAbsTime = bTrendRecord.getTimestamp();
                        BAbsTime bAbsTime2 = this.history.getLastTimestamp();
                        this.nextValidThreshold = bAbsTime2 != null && !bAbsTime2.isNull() && !bAbsTime.isAfter(bAbsTime2.add(bRelTime)) ? bAbsTime2 : null;
                        if (this.nextValidThreshold == null) {
                            this.history.append(bTrendRecord);
                            this.start = false;
                            this.setLastRecord((BHistoryRecord)bTrendRecord.newCopy());
                        }
                    }
                }
                if (this.history == null) return;
                this.updateStatus();
                return;
            }
            catch (HistoryNotFoundException historyNotFoundException) {
                if (n != 0) {
                    boolean bl = this.getStatus().isFault();
                    this.setFault((Throwable)((Object)historyNotFoundException));
                    if (bl) return;
                    throw historyNotFoundException;
                }
                this.initHistory();
            }
            catch (Exception exception) {
                boolean bl = this.getStatus().isFault();
                this.setFault(exception);
                if (bl) return;
                if (!(exception instanceof HistoryException)) throw new HistoryException(exception);
                throw (HistoryException)((Object)exception);
            }
            ++n;
        }
    }

    private final void syncFacets() {
        BControlPoint bControlPoint = this.getParentPoint();
        BFacets bFacets = bControlPoint.getFacets();
        if (this.localFacets != null && bFacets == this.localFacets) {
            return;
        }
        this.localFacets = bFacets;
        BHistoryConfig bHistoryConfig = this.getHistoryConfig();
        if (bHistoryConfig.getRecordType().isNull()) {
            return;
        }
        BTrendRecord bTrendRecord = (BTrendRecord)bHistoryConfig.makeRecord();
        Property property = bTrendRecord.getValueProperty();
        String string = property.getName() + "Facets";
        Property property2 = bHistoryConfig.loadSlots().getProperty(string);
        if (property2 == null) {
            bHistoryConfig.add(string, (BValue)bFacets);
        } else {
            BFacets bFacets2 = (BFacets)bHistoryConfig.get(property2);
            if (!bFacets2.equals((Object)bFacets)) {
                bHistoryConfig.set(property2, (BValue)bFacets);
            }
        }
    }

    private final void setFault(boolean bl, String string) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)bl));
        this.setFaultCause(string);
    }

    private final void setFault(Throwable throwable) {
        String string;
        if (!(throwable instanceof HistoryException)) {
            log.error(this.getHistoryConfig().getId().toString(), throwable);
        }
        if ((string = throwable.getMessage()) == null || string.length() == 0) {
            string = throwable.getClass().getName();
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(string);
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("workbench:PropertySheet");
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.start = true;
        this.initHistorySuccessful = false;
        this.inInit = false;
        this.nextValidThreshold = null;
    }

    public BHistoryExt() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$history$ext$BHistoryExt;
        if (clazz == null) {
            clazz = class$javax$baja$history$ext$BHistoryExt = BHistoryExt.class("[Ljavax.baja.history.ext.BHistoryExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"history.ext");
    }
}

