/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.bql.util.BDynamicTimeRange;
import java.util.HashMap;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SyntaxException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HistoryQuery
extends BasicQuery {
    private static final String[] NO_NAMES = new String[0];
    FilePath filePath;
    private HashMap params;
    private String paramString;
    private BDynamicTimeRange timeRange;
    private boolean delta;
    FilePath folderFilePath;
    boolean historyFolderAbs;
    boolean defaultFolder;

    public String getQueryString() {
        return this.paramString;
    }

    private final void parse(String string) throws SyntaxException {
        int n;
        String string2;
        int n2 = string.indexOf(63);
        if (n2 == -1) {
            this.paramString = "";
            string2 = string;
        } else {
            this.paramString = string.substring(n2 + 1);
            string2 = string.substring(0, n2);
        }
        boolean bl = string2.startsWith("//");
        if (bl) {
            if (string2.startsWith("///")) {
                string2 = string2.substring(2);
                this.historyFolderAbs = true;
                this.defaultFolder = true;
            } else {
                string2 = string2.substring(1);
                n = string2.lastIndexOf("//");
                boolean bl2 = false;
                if (n >= 0) {
                    bl2 = this.historyFolderAbs = true;
                }
                if (this.historyFolderAbs) {
                    this.folderFilePath = new FilePath(this.scheme, string2.substring(0, n));
                    if ((string2 = string2.substring(n + 1)).lastIndexOf("/") == 0) {
                        string2 = string2.substring(1);
                    }
                } else {
                    this.folderFilePath = new FilePath(this.scheme, string2);
                }
            }
        }
        this.filePath = new FilePath(this.scheme, string2);
        if ((!bl || this.historyFolderAbs) && this.filePath.depth() > 2) {
            throw new SyntaxException("Path depth must be <= 2.");
        }
        if (this.filePath.getBackupDepth() != 0) {
            throw new SyntaxException("Backup \"..\" is not allowed.");
        }
        int n3 = 0;
        if (this.filePath.isRelative() || this.filePath.isLocalAbsolute() || this.filePath.isStationHomeAbsolute() && this.filePath.depth() <= 1 || this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            n3 = 1;
        }
        if ((n = n3) == 0) {
            throw new SyntaxException("Invalid history ord: " + string);
        }
        if (this.paramString.length() != 0) {
            this.params = this.parseParams(this.paramString);
        }
        this.timeRange = this.parseTimeRange(this.params);
        this.delta = this.parseDelta(this.params);
        if (this.paramString.length() == 0) {
            this.paramString = null;
        }
    }

    private final HashMap parseParams(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (string.length() != 0) {
            String string2 = null;
            int n = string.indexOf(59);
            if (n == -1) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = n != string.length() - 1 ? string.substring(n + 1) : "";
            }
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            String string3 = string2.substring(0, n2);
            String string4 = n2 == string2.length() - 1 ? "" : string2.substring(n2 + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private final BDynamicTimeRange parseTimeRange(HashMap hashMap) throws SyntaxException {
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        String string = (String)hashMap.get("period");
        if (string != null && !string.equalsIgnoreCase("timeRange")) {
            return BDynamicTimeRange.make((String)string);
        }
        BAbsTime bAbsTime = null;
        String string2 = (String)hashMap.get("start");
        bAbsTime = string2 != null ? this.parseTime(string2, true) : BAbsTime.NULL;
        BAbsTime bAbsTime2 = null;
        String string3 = (String)hashMap.get("end");
        bAbsTime2 = string3 != null ? this.parseTime(string3, false) : BAbsTime.NULL;
        return BDynamicTimeRange.make((BAbsTime)bAbsTime, (BAbsTime)bAbsTime2);
    }

    private final BAbsTime parseTime(String string, boolean bl) throws SyntaxException {
        try {
            return (BAbsTime)BAbsTime.DEFAULT.decodeFromString(string);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Exception exception) {
            throw new SyntaxException((Throwable)exception);
        }
    }

    private final boolean parseDelta(HashMap hashMap) throws SyntaxException {
        if (hashMap == null || hashMap.size() == 0) {
            return false;
        }
        boolean bl = false;
        String string = (String)hashMap.get("delta");
        if (string != null) {
            try {
                bl = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                throw new SyntaxException((Throwable)exception);
            }
        }
        return bl;
    }

    public boolean isSpaceQuery() {
        if (this.filePath.depth() == 0 && this.filePath.isRelative()) {
            return true;
        }
        return this.getBody().equals("/") || this.getBody().equals("//");
    }

    public boolean isDeviceQuery() {
        boolean bl = false;
        if (!this.isHistoryFolderQuery() && (this.filePath.isStationHomeAbsolute() && this.filePath.depth() == 0 || this.filePath.isLocalAbsolute() && this.filePath.depth() == 1)) {
            bl = true;
        }
        return bl;
    }

    public boolean isHistoryQuery() {
        boolean bl = false;
        if (!this.isHistoryFolderQuery() && (this.filePath.isStationHomeAbsolute() && this.filePath.depth() == 1 || this.filePath.isLocalAbsolute() && this.filePath.depth() == 2 || this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@"))) {
            bl = true;
        }
        return bl;
    }

    public boolean isHistoryFolderQuery() {
        boolean bl = false;
        if (this.folderFilePath != null && !this.historyFolderAbs || this.getBody().equals("///")) {
            bl = true;
        }
        return bl;
    }

    public String getDeviceName() {
        if (this.isHistoryFolderQuery()) {
            return null;
        }
        if (this.filePath.isStationHomeAbsolute()) {
            return "^";
        }
        if (this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            return "@";
        }
        return this.filePath.nameAt(0);
    }

    public String getHistoryName() {
        if (this.isHistoryFolderQuery()) {
            return null;
        }
        if (this.filePath.isStationHomeAbsolute()) {
            return this.filePath.nameAt(0);
        }
        if (this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            return this.filePath.nameAt(0).substring(1);
        }
        return this.filePath.nameAt(1);
    }

    public String[] getHistoryFolderPath() {
        if (this.defaultFolder) {
            return new String[]{"/"};
        }
        if (this.folderFilePath != null) {
            return this.folderFilePath.getNames();
        }
        return null;
    }

    public BHistoryId getHistoryId() {
        if (this.isHistoryFolderQuery()) {
            return null;
        }
        if (this.filePath.isStationHomeAbsolute()) {
            return BHistoryId.make("^", this.filePath.nameAt(0));
        }
        if (this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            return BHistoryId.make("@", this.filePath.nameAt(0).substring(1));
        }
        if (this.filePath.depth() == 2) {
            return BHistoryId.make(this.filePath.nameAt(0), this.filePath.nameAt(1));
        }
        throw new BajaRuntimeException("Cannot get history id from an unnormalized relative history ord.");
    }

    public boolean hasTimeRange() {
        boolean bl = false;
        if (this.timeRange != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isDelta() {
        return this.delta;
    }

    public BAbsTime getStartTime(BAbsTime bAbsTime) {
        return this.timeRange.getStartTime(bAbsTime);
    }

    public BAbsTime getEndTime(BAbsTime bAbsTime) {
        return this.timeRange.getEndTime(bAbsTime);
    }

    public String[] getParameterNames() {
        if (this.params.size() == 0) {
            return NO_NAMES;
        }
        return this.params.keySet().toArray(new String[this.params.size()]);
    }

    public String getParameter(String string) {
        return (String)this.params.get(string);
    }

    public String getParameter(String string, String string2) {
        String string3 = (String)this.params.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList ordQueryList, int n) {
        HistoryQuery historyQuery;
        if (ordQueryList.isSameScheme(n, n + 1) && !(historyQuery = (HistoryQuery)ordQueryList.get(n + 1)).isSpaceQuery()) {
            if (this.folderFilePath != null || historyQuery.folderFilePath != null || this.defaultFolder || historyQuery.defaultFolder) {
                ordQueryList.merge(n, (OrdQuery)historyQuery);
            } else {
                String string;
                String string2 = this.paramString;
                String string3 = historyQuery.getQueryString();
                if (string3 != null) {
                    string2 = string3;
                }
                FilePath filePath = historyQuery.filePath;
                String string4 = null;
                FilePath filePath2 = this.filePath;
                if (filePath2.getBody().equals("") && (string = filePath.getBody()) != null && string.length() > 0) {
                    switch (string.charAt(0)) {
                        case '/': 
                        case '@': 
                        case '^': {
                            break;
                        }
                        default: {
                            filePath2 = this.filePath.merge(new FilePath(this.getScheme(), "/"));
                        }
                    }
                }
                string4 = string2 == null ? filePath2.merge(filePath).getBody() : filePath2.merge(filePath).getBody() + '?' + string2;
                ordQueryList.merge(n, (OrdQuery)new HistoryQuery(this.getScheme(), string4));
            }
        }
        ordQueryList.shiftToSession(n);
    }

    private final /* synthetic */ void this() {
        this.delta = false;
        this.folderFilePath = null;
        this.historyFolderAbs = false;
        this.defaultFolder = false;
    }

    public HistoryQuery(String string, String string2) throws SyntaxException {
        super(string, string2);
        this.this();
        this.parse(string2);
    }

    public HistoryQuery(String string) {
        this("history", string);
    }
}

