/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryException;
import javax.baja.io.ByteBuffer;
import javax.baja.nre.util.Base64;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BTypeSpec;

public abstract class HistoryCursor
implements Cursor {
    private static final String HISTORY_REC_TYPE = "historyRecordTypeSpec";
    private static final String PRE_HISTORY_REC = "historyCursorPreRec";
    private static final String POST_HISTORY_REC = "historyCursorPostRec";
    private BHistoryConfig config;
    private BHistoryRecord iteratorRec;
    private Context context;

    public BHistoryConfig getConfig() {
        return this.config;
    }

    public Context getContext() {
        return this.context;
    }

    public final boolean next() {
        return this.doNext(this.iteratorRec);
    }

    protected abstract boolean doNext(BHistoryRecord var1);

    public boolean nextComponent() {
        while (this.next()) {
        }
        return false;
    }

    public boolean next(Class clazz) {
        if (clazz.isAssignableFrom(this.iteratorRec.getClass())) {
            return this.next();
        }
        while (this.next()) {
        }
        return false;
    }

    public BObject get() {
        return this.iteratorRec;
    }

    public static BFacets makeBoundaryRecordFacets(BHistoryRecord bHistoryRecord, BHistoryRecord bHistoryRecord2) throws IOException {
        if (bHistoryRecord != null && bHistoryRecord2 != null) {
            ByteBuffer byteBuffer = new ByteBuffer();
            bHistoryRecord.write((DataOutput)byteBuffer);
            byte[] byArray = byteBuffer.toByteArray();
            byteBuffer.reset();
            bHistoryRecord2.write((DataOutput)byteBuffer);
            byte[] byArray2 = byteBuffer.toByteArray();
            return BFacets.make((String)HISTORY_REC_TYPE, (BIDataValue)BString.make((String)bHistoryRecord.getType().getTypeSpec().encodeToString()), (String)PRE_HISTORY_REC, (BIDataValue)BString.make((String)Base64.encode((byte[])byArray)), (String)POST_HISTORY_REC, (BIDataValue)BString.make((String)Base64.encode((byte[])byArray2)));
        }
        if (bHistoryRecord != null) {
            ByteBuffer byteBuffer = new ByteBuffer();
            bHistoryRecord.write((DataOutput)byteBuffer);
            return BFacets.make((String)HISTORY_REC_TYPE, (BIDataValue)BString.make((String)bHistoryRecord.getType().getTypeSpec().encodeToString()), (String)PRE_HISTORY_REC, (BIDataValue)BString.make((String)Base64.encode((byte[])byteBuffer.toByteArray())));
        }
        if (bHistoryRecord2 != null) {
            ByteBuffer byteBuffer = new ByteBuffer();
            bHistoryRecord2.write((DataOutput)byteBuffer);
            return BFacets.make((String)HISTORY_REC_TYPE, (BIDataValue)BString.make((String)bHistoryRecord2.getType().getTypeSpec().encodeToString()), (String)POST_HISTORY_REC, (BIDataValue)BString.make((String)Base64.encode((byte[])byteBuffer.toByteArray())));
        }
        return BFacets.NULL;
    }

    public static BHistoryRecord extractPreRecord(BFacets bFacets) throws IOException {
        String string = bFacets.gets(HISTORY_REC_TYPE, null);
        if (string == null) {
            return null;
        }
        String string2 = bFacets.gets(PRE_HISTORY_REC, null);
        if (string2 == null) {
            return null;
        }
        BHistoryRecord bHistoryRecord = (BHistoryRecord)((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(string)).getInstance();
        ByteBuffer byteBuffer = new ByteBuffer(Base64.decode((String)string2));
        return bHistoryRecord.read((DataInput)byteBuffer);
    }

    public static BHistoryRecord extractPostRecord(BFacets bFacets) throws IOException {
        String string = bFacets.gets(HISTORY_REC_TYPE, null);
        if (string == null) {
            return null;
        }
        String string2 = bFacets.gets(POST_HISTORY_REC, null);
        if (string2 == null) {
            return null;
        }
        BHistoryRecord bHistoryRecord = (BHistoryRecord)((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(string)).getInstance();
        ByteBuffer byteBuffer = new ByteBuffer(Base64.decode((String)string2));
        return bHistoryRecord.read((DataInput)byteBuffer);
    }

    public HistoryCursor(BHistoryConfig bHistoryConfig, BHistoryRecord bHistoryRecord, Context context) throws HistoryException {
        this.config = bHistoryConfig;
        this.iteratorRec = bHistoryRecord;
        this.context = context;
    }
}

