/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSampleRate
extends BSimple {
    public static final BSampleRate DEFAULT = BSampleRate.makeAuto();
    public static final BRelTime DEFAULT_VALUE = BRelTime.make((long)5000L);
    public static final Type TYPE;
    private static Lexicon lex;
    private boolean auto;
    private boolean cov;
    private BRelTime value;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$history$BSampleRate;

    public static final BSampleRate makeAuto() {
        return BSampleRate.make(true, false, DEFAULT_VALUE);
    }

    public static final BSampleRate makeCov() {
        return BSampleRate.make(false, true, DEFAULT_VALUE);
    }

    public static final BSampleRate make(BRelTime bRelTime) {
        return BSampleRate.make(false, false, bRelTime);
    }

    public static final BSampleRate make(boolean bl, boolean bl2, BRelTime bRelTime) {
        if (bRelTime == null) {
            bRelTime = DEFAULT_VALUE;
        }
        BSampleRate bSampleRate = new BSampleRate();
        bSampleRate.auto = bl;
        bSampleRate.cov = bl2;
        bSampleRate.value = bRelTime;
        return bSampleRate;
    }

    public final boolean isAuto() {
        return this.auto;
    }

    public final boolean isCov() {
        return this.cov;
    }

    public final BRelTime getValue() {
        if (this.auto || this.cov) {
            return DEFAULT_VALUE;
        }
        if (this.value == null) {
            return DEFAULT_VALUE;
        }
        return this.value;
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode((Object)this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BSampleRate) {
            BSampleRate bSampleRate = (BSampleRate)((Object)object);
            if (this.auto) {
                return bSampleRate.auto;
            }
            if (this.cov) {
                return bSampleRate.cov;
            }
            return this.value.equals((Object)bSampleRate.value);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.auto);
        if (!this.auto && !this.cov) {
            this.value.getType().getTypeSpec().encode(dataOutput);
            this.value.encode(dataOutput);
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        boolean bl = dataInput.readBoolean();
        if (bl) {
            return BSampleRate.makeAuto();
        }
        BTypeSpec bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decode(dataInput);
        BRelTime bRelTime = (BRelTime)((BRelTime)bTypeSpec.getInstance()).decode(dataInput);
        return BSampleRate.make(bRelTime);
    }

    public final String encodeToString() throws IOException {
        if (this.auto) {
            return "auto";
        }
        if (this.cov) {
            return "cov";
        }
        return "fixed," + this.value.getType().getTypeSpec().encodeToString() + ',' + this.value.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        boolean bl = string.equals("auto");
        boolean bl2 = string.equals("cov");
        if (bl) {
            return BSampleRate.makeAuto();
        }
        if (bl2) {
            return BSampleRate.makeCov();
        }
        int n = string.indexOf(44);
        string = string.substring(n + 1);
        n = string.indexOf(44);
        BTypeSpec bTypeSpec = BTypeSpec.make((String)string.substring(0, n));
        BRelTime bRelTime = (BRelTime)((BRelTime)bTypeSpec.getInstance()).decodeFromString(string.substring(n + 1));
        return BSampleRate.make(bRelTime);
    }

    public final String toString(Context context) {
        if (this.auto) {
            return lex.getText("auto");
        }
        if (this.cov) {
            return lex.getText("cov");
        }
        return this.value.toString(context);
    }

    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("auto = " + this.auto + ", ");
        stringBuffer.append("cov = " + this.cov + ", ");
        stringBuffer.append("value = " + this.value);
        return stringBuffer.toString();
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.auto = true;
        this.cov = false;
        this.value = DEFAULT_VALUE;
        this.hashCode = -1;
    }

    private BSampleRate() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$history$BSampleRate;
        if (clazz == null) {
            clazz = class$javax$baja$history$BSampleRate = BSampleRate.class("[Ljavax.baja.history.BSampleRate;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"history");
    }
}

