/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.history.BHistoryRecordGroup;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.log.BLogRecord;
import com.tridium.util.ValueByteBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.io.BIEncodable;
import javax.baja.io.ByteBuffer;
import javax.baja.nre.util.Base64;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BHistoryEvent
extends BStruct
implements BIEncodable {
    public static final int CREATED = 0;
    public static final int DELETED = 1;
    public static final int APPENDED = 2;
    public static final int UPDATED = 3;
    public static final int CLEARED_ALL_RECORDS = 4;
    public static final int CLEARED_OLD_RECORDS = 5;
    public static final int RENAMED = 6;
    public static final int RESIZED = 7;
    public static final int DB_OPENED = 8;
    public static final int DB_CLOSED = 9;
    public static final int DB_FLUSHED = 10;
    public static final int DB_SAVED = 11;
    public static final int CONFIG_CHANGED = 12;
    private static String[] ID_STRINGS = new String[]{"created", "deleted", "appended", "updated", "clearedAllRecords", "clearedOldRecords", "renamed", "resized", "dbOpened", "dbClosed", "dbFlushed", "dbSaved", "configChanged"};
    private static Object seqLock = new Object();
    private static int seqNum = 0;
    public static final Type TYPE;
    private static Hashtable typeToByte;
    private static Type[] byteToType;
    static BHistoryEvent dbOpenedEvent;
    static BHistoryEvent dbClosedEvent;
    static BHistoryEvent dbFlushedEvent;
    static BHistoryEvent dbSavedEvent;
    private int eventId;
    private BHistoryId historyId;
    private BIHistoryRecordSet records;
    private BAbsTime clearOldTime;
    private String newHistoryName;
    private BCapacity capacity;
    private BFullPolicy fullPolicy;
    private BHistoryConfig config;
    private boolean useShorthand;
    static /* synthetic */ Class class$javax$baja$history$BHistoryEvent;

    public static final BHistoryEvent makeCreated(BHistoryId bHistoryId) {
        return new BHistoryEvent(0, bHistoryId);
    }

    public static final BHistoryEvent makeCreated(BHistoryId bHistoryId, BHistoryConfig bHistoryConfig) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(0, bHistoryId);
        bHistoryEvent.config = bHistoryConfig;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeDeleted(BHistoryId bHistoryId) {
        return new BHistoryEvent(1, bHistoryId);
    }

    public static final BHistoryEvent makeAppended(BHistoryId bHistoryId, BIHistoryRecordSet bIHistoryRecordSet) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(2, bHistoryId);
        bHistoryEvent.records = bIHistoryRecordSet;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeUpdated(BHistoryId bHistoryId, BIHistoryRecordSet bIHistoryRecordSet) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(3, bHistoryId);
        bHistoryEvent.records = bIHistoryRecordSet;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeClearedAll(BHistoryId bHistoryId) {
        return new BHistoryEvent(4, bHistoryId);
    }

    public static final BHistoryEvent makeClearedOld(BHistoryId bHistoryId, BAbsTime bAbsTime) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(5, bHistoryId);
        bHistoryEvent.clearOldTime = bAbsTime;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeRenamed(BHistoryId bHistoryId, String string) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(6, bHistoryId);
        bHistoryEvent.newHistoryName = string;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeResized(BHistoryId bHistoryId, BCapacity bCapacity, BFullPolicy bFullPolicy) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(7, bHistoryId);
        bHistoryEvent.capacity = bCapacity;
        bHistoryEvent.fullPolicy = bFullPolicy;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeDbOpened() {
        return dbOpenedEvent;
    }

    public static final BHistoryEvent makeDbClosed() {
        return dbClosedEvent;
    }

    public static final BHistoryEvent makeDbFlushed() {
        return dbFlushedEvent;
    }

    public static final BHistoryEvent makeDbSaved() {
        return dbSavedEvent;
    }

    public static final BHistoryEvent makeConfigChanged(BHistoryId bHistoryId, BHistoryConfig bHistoryConfig) {
        BHistoryEvent bHistoryEvent = new BHistoryEvent(12, bHistoryId);
        bHistoryEvent.config = bHistoryConfig;
        return bHistoryEvent;
    }

    public static final BHistoryEvent makeShorthand(BHistoryEvent bHistoryEvent, boolean bl) {
        BHistoryEvent bHistoryEvent2 = new BHistoryEvent();
        bHistoryEvent2.eventId = bHistoryEvent.eventId;
        bHistoryEvent2.historyId = bHistoryEvent.historyId;
        bHistoryEvent2.records = bHistoryEvent.records;
        bHistoryEvent2.clearOldTime = bHistoryEvent.clearOldTime;
        bHistoryEvent2.newHistoryName = bHistoryEvent.newHistoryName;
        bHistoryEvent2.capacity = bHistoryEvent.capacity;
        bHistoryEvent2.fullPolicy = bHistoryEvent.fullPolicy;
        bHistoryEvent2.config = bHistoryEvent.config;
        bHistoryEvent2.useShorthand = bl;
        return bHistoryEvent2;
    }

    public final int getId() {
        return this.eventId;
    }

    public final BHistoryId getHistoryId() {
        return this.historyId;
    }

    public final BIHistoryRecordSet getRecordSet() {
        return this.records;
    }

    public final BAbsTime getClearOldTime() {
        return this.clearOldTime;
    }

    public final String getNewHistoryName() {
        return this.newHistoryName;
    }

    public final BCapacity getCapacity() {
        return this.capacity;
    }

    public final BFullPolicy getFullPolicy() {
        return this.fullPolicy;
    }

    public final BHistoryConfig getConfig() {
        return this.config;
    }

    public final boolean getUseShorthandEncoding() {
        return this.useShorthand;
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ID_STRINGS[this.eventId]).append(" ");
        if (this.historyId != null) {
            stringBuffer.append(this.historyId.toString());
        }
        if (this.records != null) {
            stringBuffer.append(": ").append(this.records.toString());
        }
        if (this.clearOldTime != null) {
            stringBuffer.append(": ").append(this.clearOldTime.toString());
        }
        if (this.newHistoryName != null) {
            stringBuffer.append(": ").append(this.newHistoryName.toString());
        }
        if (this.capacity != null) {
            stringBuffer.append(": ").append(this.capacity.toString());
        }
        if (this.fullPolicy != null) {
            stringBuffer.append(": ").append(this.fullPolicy.toString());
        }
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.eventId);
        switch (this.eventId) {
            case 2: 
            case 3: {
                this.idToShorthand().encode(dataOutput);
                int n = this.records.getRecordCount();
                if (n <= 127) {
                    dataOutput.writeBoolean(true);
                    dataOutput.writeByte(n);
                } else {
                    dataOutput.writeBoolean(false);
                    dataOutput.writeInt(n);
                }
                if (n > 0) {
                    BHistoryRecord bHistoryRecord = this.records.getRecord(0);
                    Type type = bHistoryRecord.getType();
                    Integer n2 = (Integer)typeToByte.get(type);
                    boolean bl = false;
                    if (n2 != null) {
                        bl = true;
                    }
                    boolean bl2 = bl;
                    dataOutput.writeBoolean(bl2);
                    if (bl2) {
                        dataOutput.writeByte(n2);
                    } else {
                        type.getTypeSpec().encode(dataOutput);
                    }
                }
                int n3 = 0;
                while (n3 < n) {
                    this.records.getRecord(n3).write(dataOutput);
                    ++n3;
                }
                break;
            }
            case 0: 
            case 12: {
                boolean bl;
                this.idToShorthand().encode(dataOutput);
                boolean bl3 = false;
                if (this.config != null) {
                    bl3 = true;
                }
                if (bl = bl3) {
                    byte[] byArray = ValueByteBuffer.marshal((BObject)this.config);
                    int n = byArray.length;
                    dataOutput.writeInt(n);
                    if (n > 0) {
                        dataOutput.write(byArray);
                    }
                } else {
                    dataOutput.writeInt(0);
                }
                dataOutput.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 1: 
            case 4: {
                this.idToShorthand().encode(dataOutput);
                dataOutput.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 5: {
                this.idToShorthand().encode(dataOutput);
                this.clearOldTime.encode(dataOutput);
                dataOutput.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 6: {
                this.idToShorthand().encode(dataOutput);
                dataOutput.writeUTF(this.newHistoryName);
                dataOutput.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 7: {
                this.idToShorthand().encode(dataOutput);
                this.capacity.encode(dataOutput);
                this.fullPolicy.encode(dataOutput);
                dataOutput.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            default: {
                dataOutput.writeInt(BHistoryEvent.nextSeqNum());
            }
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        switch (by) {
            case 8: {
                dataInput.readInt();
                return dbOpenedEvent;
            }
            case 9: {
                dataInput.readInt();
                return dbClosedEvent;
            }
            case 10: {
                dataInput.readInt();
                return dbFlushedEvent;
            }
            case 11: {
                dataInput.readInt();
                return dbSavedEvent;
            }
        }
        BHistoryEvent bHistoryEvent = new BHistoryEvent(by);
        switch (by) {
            case 2: 
            case 3: {
                bHistoryEvent.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(dataInput));
                int n = 0;
                n = dataInput.readBoolean() ? dataInput.readByte() : dataInput.readInt();
                BHistoryRecord[] bHistoryRecordArray = n > 1 ? new BHistoryRecord[n] : null;
                Type type = null;
                if (n > 0) {
                    type = dataInput.readBoolean() ? byteToType[dataInput.readByte()] : ((BTypeSpec)BTypeSpec.DEFAULT.decode(dataInput)).getResolvedType();
                }
                BHistoryRecord bHistoryRecord = null;
                int n2 = 0;
                while (n2 < n) {
                    bHistoryRecord = (BHistoryRecord)type.getInstance();
                    bHistoryRecord = bHistoryRecord.read(dataInput);
                    if (bHistoryRecordArray != null) {
                        bHistoryRecordArray[n2] = bHistoryRecord;
                    }
                    ++n2;
                }
                if (bHistoryRecordArray == null) {
                    bHistoryEvent.records = bHistoryRecord;
                    break;
                }
                bHistoryEvent.records = new BHistoryRecordGroup(bHistoryRecordArray);
                break;
            }
            case 0: 
            case 12: {
                bHistoryEvent.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(dataInput));
                int n = dataInput.readInt();
                if (n > 0) {
                    byte[] byArray = new byte[n];
                    dataInput.readFully(byArray);
                    try {
                        bHistoryEvent.config = (BHistoryConfig)ValueByteBuffer.unmarshal((byte[])byArray);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dataInput.readInt();
                break;
            }
            case 1: 
            case 4: {
                bHistoryEvent.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(dataInput));
                dataInput.readInt();
                break;
            }
            case 5: {
                bHistoryEvent.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(dataInput));
                bHistoryEvent.clearOldTime = (BAbsTime)BAbsTime.DEFAULT.decode(dataInput);
                dataInput.readInt();
                break;
            }
            case 6: {
                bHistoryEvent.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(dataInput));
                bHistoryEvent.newHistoryName = dataInput.readUTF();
                dataInput.readInt();
                break;
            }
            case 7: {
                bHistoryEvent.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(dataInput));
                bHistoryEvent.capacity = (BCapacity)BCapacity.DEFAULT.decode(dataInput);
                bHistoryEvent.fullPolicy = (BFullPolicy)BFullPolicy.roll.decode(dataInput);
                dataInput.readInt();
                break;
            }
        }
        return bHistoryEvent;
    }

    public final String encodeToString() throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer();
        this.encode((DataOutput)byteBuffer);
        return Base64.encode((byte[])byteBuffer.toByteArray());
    }

    public final BObject decodeFromString(String string) throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer(Base64.decode((String)string));
        return this.decode((DataInput)byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int nextSeqNum() {
        Object object = seqLock;
        synchronized (object) {
            return seqNum++;
        }
    }

    private final BHistoryId idToShorthand() {
        BHistoryId bHistoryId = this.historyId;
        try {
            bHistoryId = this.getUseShorthandEncoding() ? bHistoryId.toShorthand(Sys.getStation().getStationName()) : bHistoryId.fromShorthand(Sys.getStation().getStationName());
        }
        catch (Throwable throwable) {}
        return bHistoryId;
    }

    private static final BHistoryId idFromShorthand(BHistoryId bHistoryId) {
        try {
            bHistoryId = bHistoryId.fromShorthand(Sys.getStation().getStationName());
        }
        catch (Throwable throwable) {}
        return bHistoryId;
    }

    public final Object clone() {
        BHistoryEvent bHistoryEvent = new BHistoryEvent();
        bHistoryEvent.eventId = this.eventId;
        bHistoryEvent.historyId = this.historyId;
        bHistoryEvent.records = this.records;
        bHistoryEvent.clearOldTime = this.clearOldTime;
        bHistoryEvent.newHistoryName = this.newHistoryName;
        bHistoryEvent.capacity = this.capacity;
        bHistoryEvent.fullPolicy = this.fullPolicy;
        bHistoryEvent.config = this.config;
        return bHistoryEvent;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.historyId = null;
        this.records = null;
        this.clearOldTime = null;
        this.newHistoryName = null;
        this.capacity = null;
        this.fullPolicy = null;
        this.config = null;
        this.useShorthand = false;
    }

    public BHistoryEvent(int n) {
        this.this();
        this.eventId = n;
    }

    public BHistoryEvent(int n, BHistoryId bHistoryId) {
        this.this();
        this.eventId = n;
        this.historyId = bHistoryId;
    }

    public BHistoryEvent() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$history$BHistoryEvent;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryEvent = BHistoryEvent.class("[Ljavax.baja.history.BHistoryEvent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        typeToByte = new Hashtable(6);
        typeToByte.put(BBooleanTrendRecord.TYPE, new Integer(0));
        typeToByte.put(BEnumTrendRecord.TYPE, new Integer(1));
        typeToByte.put(BNumericTrendRecord.TYPE, new Integer(2));
        typeToByte.put(BStringTrendRecord.TYPE, new Integer(3));
        typeToByte.put(BAuditRecord.TYPE, new Integer(4));
        typeToByte.put(BLogRecord.TYPE, new Integer(5));
        byteToType = new Type[]{BBooleanTrendRecord.TYPE, BEnumTrendRecord.TYPE, BNumericTrendRecord.TYPE, BStringTrendRecord.TYPE, BAuditRecord.TYPE, BLogRecord.TYPE};
        dbOpenedEvent = new BHistoryEvent(8);
        dbClosedEvent = new BHistoryEvent(9);
        dbFlushedEvent = new BHistoryEvent(10);
        dbSavedEvent = new BHistoryEvent(11);
    }
}

