/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.bql.collection.BObjectList;
import com.tridium.bql.collection.BObjectTable;
import com.tridium.history.IdCursor;
import com.tridium.history.db.BLocalHistoryDatabase;
import java.util.Comparator;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIRelational;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.collection.BICollection;
import javax.baja.collection.BIList;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFilter;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryDevice
extends BObject
implements BISpaceNode,
BIRelational,
BICategorizable,
BIProtected {
    private static final BIcon icon = BIcon.std((String)"device.png");
    public static final Type TYPE;
    private static Comparator histNameComparator;
    private BHistorySpace space;
    private BOrd ordInSpace;
    private String deviceName;
    static /* synthetic */ Class class$javax$baja$history$BHistoryDevice;

    public BSpace getSpace() {
        return this.space;
    }

    public BHost getHost() {
        return this.space == null ? null : this.space.getHost();
    }

    public BISession getSession() {
        return this.space == null ? null : this.space.getSession();
    }

    public boolean isMounted() {
        boolean bl = false;
        if (this.getHost() != null) {
            bl = true;
        }
        return bl;
    }

    public BOrd getAbsoluteOrd() {
        if (this.space == null) {
            return null;
        }
        return BOrd.make((BOrd)this.space.getAbsoluteOrd(), (BOrd)this.ordInSpace);
    }

    public BOrd getOrdInHost() {
        if (this.space == null) {
            return null;
        }
        BOrd bOrd = this.space.getOrdInHost();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.ordInSpace);
    }

    public BOrd getOrdInSession() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSpace() {
        if (this.space == null) {
            return null;
        }
        return this.ordInSpace;
    }

    public boolean isPendingMove() {
        return false;
    }

    public void setPendingMove(boolean bl) {
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)(this.space.getNavOrd() + '/' + this.deviceName));
    }

    public String getNavName() {
        return this.deviceName;
    }

    public String getNavDisplayName(Context context) {
        return this.deviceName;
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public String getNavDescription(Context context) {
        return null;
    }

    public BINavNode getNavParent() {
        BHistorySpace bHistorySpace = this.space;
        String[] stringArray = BHistoryService.getHistoryGroupNames(this);
        if (stringArray != null && stringArray.length > 0) {
            bHistorySpace = this.space.getNavChild("history:///");
        }
        return bHistorySpace;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        BHistoryId bHistoryId = BHistoryId.make(this.deviceName, string);
        boolean bl = this.space.exists(bHistoryId);
        if (bl) {
            return this.space.getHistory(bHistoryId);
        }
        return null;
    }

    public BINavNode resolveNavChild(String string) {
        BINavNode bINavNode = this.getNavChild(string);
        if (bINavNode == null) {
            throw new UnresolvedException("/" + this.deviceName + '/' + string);
        }
        return bINavNode;
    }

    public BINavNode[] getNavChildren() {
        Object[] objectArray = this.space.listHistories(this);
        SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)histNameComparator);
        return objectArray;
    }

    public int getNavHashCode() {
        return this.deviceName.hashCode();
    }

    public void addNavChild(BINavNode bINavNode) {
        throw new UnsupportedOperationException();
    }

    public void removeNavChild(BINavNode bINavNode) {
        throw new UnsupportedOperationException();
    }

    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(this.getOrdInSession());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryService.getService().getAppliedCategoryMask(this.getOrdInSession());
    }

    public BPermissions getPermissions(Context context) {
        if (context != null && context.getUser() != null) {
            return context.getUser().getPermissionsFor((BIProtected)this);
        }
        return BPermissions.all;
    }

    public boolean canRead(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().hasOperatorRead();
    }

    public boolean canWrite(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().hasAdminWrite();
    }

    public boolean canInvoke(OrdTarget ordTarget) {
        return false;
    }

    public BITable getRelation(String string) {
        BOrd bOrd = BOrd.make((BOrd)this.getOrdInSpace(), (OrdQuery)new HistoryQuery(string));
        try {
            return (BITable)bOrd.get((BObject)BLocalHost.INSTANCE, BLocalHistoryDatabase.getRelationContext());
        }
        catch (UnresolvedException unresolvedException) {
            return null;
        }
    }

    public Cursor cursor() {
        BIHistory[] bIHistoryArray = this.space.listHistories(this);
        return new IdCursor(bIHistoryArray, null);
    }

    public BICollection filter(IFilter iFilter) {
        return this;
    }

    public BIList toList() {
        return new BObjectList(this.cursor());
    }

    public BITable toTable() {
        return new BObjectTable((BICollection)this);
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.add("workbench:NavContainerView");
        agentList.remove("workbench:CollectionTable");
        return agentList;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BHistoryDevice(BHistorySpace bHistorySpace, String string) {
        this.space = bHistorySpace;
        this.deviceName = string;
        this.ordInSpace = BOrd.make((String)("history:/" + string));
    }

    static {
        Class clazz = class$javax$baja$history$BHistoryDevice;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryDevice = BHistoryDevice.class("[Ljavax.baja.history.BHistoryDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        histNameComparator = new HistoryNameComparator();
    }

    private static class HistoryNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((BIHistory)object).getNavDisplayName(null).compareTo(((BIHistory)object2).getNavDisplayName(null));
        }

        public boolean equals(Object object) {
            return object instanceof HistoryNameComparator;
        }

        private HistoryNameComparator() {
        }
    }
}

