/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BCapacity
extends BSimple {
    private static final int RESTRICT_NONE = 0;
    private static final int RESTRICT_RECORD_COUNT = 1;
    private static final int RESTRICT_STORAGE_SIZE = 2;
    public static final BCapacity UNLIMITED;
    public static final BCapacity DEFAULT;
    public static final Type TYPE;
    private static final LexiconText unlimitedTxt;
    private static final LexiconText recordsTxt;
    public static final BFacets recordCountFacets;
    private int restrictBy;
    private long max;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$history$BCapacity;

    public static final BCapacity makeByRecordCount(int n) {
        return (BCapacity)new BCapacity(1, n).intern();
    }

    public static final BCapacity makeByStorageSize(long l) {
        return (BCapacity)new BCapacity(2, l).intern();
    }

    public static final BCapacity makeUnlimited() {
        return UNLIMITED;
    }

    public final boolean isUnlimited() {
        boolean bl = false;
        if (this.restrictBy == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isByRecordCount() {
        boolean bl = false;
        if (this.restrictBy == 1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isByStorageSize() {
        boolean bl = false;
        if (this.restrictBy == 2) {
            bl = true;
        }
        return bl;
    }

    public final int getMaxRecords() {
        if (this.restrictBy == 0) {
            return -1;
        }
        if (this.restrictBy == 2) {
            throw new IllegalStateException("Capacity is not restricted by record count.");
        }
        if (this.max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.max;
    }

    public final long getMaxStorage() {
        if (this.restrictBy == 0) {
            return -1;
        }
        if (this.restrictBy == 1) {
            throw new IllegalStateException("Capacity is not restricted by storage size.");
        }
        return this.max;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            long l = 23L + (long)this.restrictBy;
            l = l * 37L + this.max;
            this.hashCode = (int)(l >>> 32) ^ (int)l;
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BCapacity)) {
            return false;
        }
        BCapacity bCapacity = (BCapacity)((Object)object);
        boolean bl = false;
        if (this.restrictBy == bCapacity.restrictBy && this.max == bCapacity.max) {
            bl = true;
        }
        return bl;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.restrictBy);
        dataOutput.writeLong(this.max);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        long l = dataInput.readLong();
        return (BCapacity)new BCapacity(n, l).intern();
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.restrictBy);
        stringBuffer.append(':');
        stringBuffer.append(this.max);
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        int n = string.indexOf(58);
        int n2 = Integer.parseInt(string.substring(0, n));
        long l = Long.parseLong(string.substring(n + 1));
        return (BCapacity)new BCapacity(n2, l).intern();
    }

    public final String toString(Context context) {
        if (this.restrictBy == 0) {
            return unlimitedTxt.getText(context);
        }
        if (this.restrictBy == 1) {
            return Long.toString(this.max) + ' ' + recordsTxt.getText(context);
        }
        if (this.restrictBy == 2) {
            return Long.toString(this.max / 1024L) + " KB";
        }
        return Long.toString(this.max);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BCapacity(int n, long l) {
        this.this();
        this.restrictBy = n;
        this.max = l;
    }

    static {
        DEFAULT = UNLIMITED = new BCapacity(0, 0L);
        Class clazz = class$javax$baja$history$BCapacity;
        if (clazz == null) {
            clazz = class$javax$baja$history$BCapacity = BCapacity.class("[Ljavax.baja.history.BCapacity;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        unlimitedTxt = LexiconText.make((String)"history", (String)"unlimited");
        recordsTxt = LexiconText.make((String)"history", (String)"records");
        recordCountFacets = BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BIDataValue[]{BDouble.make((double)0.0), BDouble.POSITIVE_INFINITY});
    }
}

