/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.BLiveHistoryChartEditor;
import javax.baja.chart.BChartPane;
import javax.baja.chart.Series;
import javax.baja.chart.TableSeries;
import javax.baja.chart.TrendFlags;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.gx.BBrush;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class LiveChartSeries
extends Series {
    private static final int TIMESTAMP_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private BLiveHistoryChartEditor historyChart;
    private SeriesColumn[] seriesCol;
    private SeriesData seriesData;
    private String seriesName;
    private int maxSize;
    private boolean showDelta;
    private boolean deltaEnabled;
    private BBrush brush;
    private BChartPane pane;
    private BAxisBound minAxisBound;
    private BAxisBound maxAxisBound;

    public void initializeSeries(TableSeries tableSeries) {
        this.seriesData = new SeriesData();
        int n = 0;
        while (n < tableSeries.getRowCount()) {
            this.seriesData.addData(tableSeries.getValue(n, 0), tableSeries.getValue(n, 1), tableSeries.getTrendFlags(n));
            ++n;
        }
        this.computeMinMaxValue();
    }

    public void addData(Object object, Object object2, int n, boolean bl) {
        int n2 = 0;
        if (!BStatus.make((int)n).isValid()) {
            n2 = 4;
        }
        this.seriesData.addData(object, object2, n2);
        if (!TrendFlags.isHidden((int)n2)) {
            Object object3;
            int n3;
            if (SortUtil.compare((Object)object, (Object)this.seriesCol[0].getMin()) < 0) {
                this.seriesCol[0].setMin(object);
            }
            if (SortUtil.compare((Object)object, (Object)this.seriesCol[0].getMax()) > 0) {
                this.seriesCol[0].setMax(object);
            }
            if ((n3 = this.seriesData.getSize() - 1) < 0) {
                n3 = 0;
            }
            if (SortUtil.compare((Object)(object3 = this.seriesData.getValue(n3, true)), (Object)this.seriesCol[1].getMin()) < 0) {
                this.seriesCol[1].setMin(object3);
            }
            if (SortUtil.compare((Object)object3, (Object)this.seriesCol[1].getMax()) > 0) {
                this.seriesCol[1].setMax(object3);
            }
            if (!bl) {
                this.modified();
            }
        }
    }

    public String getName() {
        return this.seriesName;
    }

    public void setName(String string) {
        this.seriesName = string;
    }

    public String getColumnName(int n) {
        if (n == 0 || n == 1) {
            return this.seriesCol[n].getName();
        }
        return "Error-" + n;
    }

    public String getColumnDisplayName(int n) {
        if (n == 0 || n == 1) {
            return this.seriesCol[n].getDisplayName();
        }
        return this.getColumnName(n);
    }

    public Type getColumnType(int n) {
        if (n == 0 || n == 1) {
            return this.seriesCol[n].getType();
        }
        throw new IllegalArgumentException();
    }

    public BFacets getColumnFacets(int n) {
        if (n == 0 || n == 1) {
            return this.seriesCol[n].getFacets();
        }
        throw new IllegalArgumentException();
    }

    public int getRowCount() {
        return this.seriesData.getSize();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getTrendFlags(int n) {
        return this.seriesData.getTrendFlags(n);
    }

    public Object getValue(int n, int n2) {
        if (n2 == 0) {
            return this.seriesData.getTime(n);
        }
        if (n2 == 1) {
            return this.seriesData.getValue(n, true);
        }
        throw new IllegalArgumentException();
    }

    public Object getLastValue() {
        return this.seriesData.getLastValue();
    }

    public Object getMin(int n) {
        if (n == 0) {
            return this.historyChart.getMinTime();
        }
        if (n == 1) {
            if (!this.deltaEnabled || this.showDelta || this.minAxisBound.isAuto()) {
                return this.seriesCol[n].getMin();
            }
            return this.minAxisBound.getValue().asObject();
        }
        throw new IllegalArgumentException();
    }

    public Object getMax(int n) {
        if (n == 0) {
            return BAbsTime.make((long)(((BAbsTime)this.historyChart.getMinTime()).getMillis() + this.historyChart.getTimeWindow().getMillis()), (BTimeZone)this.historyChart.getTimeZone());
        }
        if (n == 1) {
            if (!this.deltaEnabled || this.showDelta || this.maxAxisBound.isAuto()) {
                return this.seriesCol[n].getMax();
            }
            return this.maxAxisBound.getValue().asObject();
        }
        throw new IllegalArgumentException();
    }

    public Object getMinTime() {
        return this.seriesData.getTime(0);
    }

    public Object getMaxTime() {
        return this.seriesCol[0].getMax();
    }

    public void computeMinMaxValue() {
        this.seriesCol[1].computeMinMaxValue(this.seriesData);
    }

    public void refresh() {
        this.computeMinMaxValue();
        if (this.getPane().getCanvas().isZoomed()) {
            this.getPane().refresh();
        } else {
            this.modified();
        }
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush bBrush) {
        this.brush = bBrush;
    }

    public void setMinAxisBound(BAxisBound bAxisBound) {
        this.minAxisBound = bAxisBound;
    }

    public void setMaxAxisBound(BAxisBound bAxisBound) {
        this.maxAxisBound = bAxisBound;
    }

    public BChartPane getPane() {
        return this.pane;
    }

    public void setPane(BChartPane bChartPane) {
        this.pane = bChartPane;
    }

    public void setShowDelta(boolean bl) {
        this.showDelta = bl;
    }

    public boolean getShowDelta() {
        return this.showDelta;
    }

    public boolean getDeltaEnabled() {
        return this.deltaEnabled;
    }

    public void setDeltaEnabled(boolean bl) {
        this.deltaEnabled = bl;
    }

    public LiveChartSeries(BLiveHistoryChartEditor bLiveHistoryChartEditor, BChartPane bChartPane, TableSeries tableSeries, String string, int n, boolean bl, boolean bl2) {
        this.historyChart = bLiveHistoryChartEditor;
        this.setName(string);
        this.setPane(bChartPane);
        this.setMaxSize(n);
        this.setDeltaEnabled(bl);
        this.setShowDelta(bl2);
        this.seriesCol = new SeriesColumn[2];
        this.seriesCol[0] = new SeriesColumn();
        this.seriesCol[1] = new SeriesColumn();
        this.seriesCol[0].setName(tableSeries.getColumnName(0));
        this.seriesCol[0].setDisplayName(tableSeries.getColumnDisplayName(0));
        this.seriesCol[0].setType(tableSeries.getColumnType(0));
        this.seriesCol[0].setFacets(tableSeries.getColumnFacets(0));
        this.seriesCol[0].setMin(tableSeries.getMin(0));
        this.seriesCol[0].setMax(tableSeries.getMax(0));
        this.seriesCol[1].setName(tableSeries.getColumnName(1));
        this.seriesCol[1].setDisplayName(tableSeries.getColumnDisplayName(1));
        this.seriesCol[1].setType(tableSeries.getColumnType(1));
        this.seriesCol[1].setFacets(tableSeries.getColumnFacets(1));
        this.initializeSeries(tableSeries);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SeriesData {
        Object[] time;
        Object[] value;
        Object lastValue;
        Object firstDeltaValue;
        int[] trendFlags;
        int head = 0;
        int tail = 0;
        boolean bufferWrapped = false;

        public int getSize() {
            if (!this.bufferWrapped) {
                return this.getTail() - this.getHead();
            }
            return LiveChartSeries.this.getMaxSize();
        }

        public Object getTime(int n) {
            if (this.time != null) {
                return this.time[this.getAdjustedPosition(n)];
            }
            return null;
        }

        public Object getValue(int n, boolean bl) {
            if (this.value != null) {
                if (bl && LiveChartSeries.this.getShowDelta() && LiveChartSeries.this.getDeltaEnabled()) {
                    BNumber bNumber = (BNumber)this.value[this.getAdjustedPosition(n)];
                    BNumber bNumber2 = (BNumber)this.getPreviousValue(n);
                    if (bNumber2 == null) {
                        return null;
                    }
                    return BDouble.make((double)(bNumber.getNumeric() - bNumber2.getNumeric()));
                }
                return this.value[this.getAdjustedPosition(n)];
            }
            return null;
        }

        public Object getLastValue() {
            return this.lastValue;
        }

        public int getTrendFlags(int n) {
            if (this.trendFlags != null) {
                return this.trendFlags[this.getAdjustedPosition(n)];
            }
            return 0;
        }

        public void addData(Object object, Object object2, int n) {
            try {
                if (this.getSize() == 0) {
                    this.time = new Object[LiveChartSeries.this.getMaxSize()];
                    this.value = new Object[LiveChartSeries.this.getMaxSize()];
                    this.trendFlags = new int[LiveChartSeries.this.getMaxSize()];
                    this.firstDeltaValue = object2;
                } else {
                    this.firstDeltaValue = this.value[this.getAdjustedPosition(0)];
                }
                this.time[this.getTail()] = object;
                this.value[this.getTail()] = object2;
                this.trendFlags[this.getTail()] = n;
                this.lastValue = object2;
                this.incrementHeadAndTail();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private final Object getPreviousValue(int n) {
            if (this.value != null) {
                if (n == 0) {
                    return this.firstDeltaValue;
                }
                int n2 = n - 1;
                if (TrendFlags.isStart((int)this.getTrendFlags(n)) || TrendFlags.isHidden((int)this.getTrendFlags(n2))) {
                    return this.value[this.getAdjustedPosition(n)];
                }
                return this.value[this.getAdjustedPosition(n2)];
            }
            return null;
        }

        private final int getHead() {
            return this.head;
        }

        private final int getTail() {
            return this.tail;
        }

        private final int getAdjustedPosition(int n) {
            int n2 = 0;
            n2 = this.getHead() + n;
            if (n2 >= LiveChartSeries.this.getMaxSize()) {
                n2 -= LiveChartSeries.this.getMaxSize();
            }
            return n2;
        }

        private final void incrementHeadAndTail() {
            if (this.bufferWrapped) {
                this.head = this.getHead() + 1;
                if (this.head >= LiveChartSeries.this.getMaxSize()) {
                    this.head = 0;
                }
            }
            this.tail = this.getTail() + 1;
            if (this.tail >= LiveChartSeries.this.getMaxSize()) {
                this.bufferWrapped = true;
                this.tail = 0;
            }
        }

        private SeriesData() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SeriesColumn {
        String displayName;
        String name;
        Type type;
        BFacets facets;
        Object min;
        Object max;

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Type getType() {
            return this.type;
        }

        public BFacets getFacets() {
            return this.facets;
        }

        public Object getMin() {
            return this.min;
        }

        public Object getMax() {
            return this.max;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFacets(BFacets bFacets) {
            this.facets = bFacets;
        }

        public void setMin(Object object) {
            this.min = object;
        }

        public void setMax(Object object) {
            this.max = object;
        }

        public void computeMinMaxValue(SeriesData seriesData) {
            boolean bl = true;
            int n = 0;
            while (n < seriesData.getSize()) {
                if (!TrendFlags.isHidden((int)seriesData.getTrendFlags(n))) {
                    Object object = seriesData.getValue(n, true);
                    if (bl) {
                        this.setMin(object);
                        this.setMax(object);
                        bl = false;
                    } else {
                        if (SortUtil.compare((Object)object, (Object)this.getMin()) < 0) {
                            this.setMin(object);
                        }
                        if (SortUtil.compare((Object)object, (Object)this.getMax()) > 0) {
                            this.setMax(object);
                        }
                    }
                }
                ++n;
            }
        }

        private SeriesColumn() {
        }
    }
}

