/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.BHistoryList;
import com.tridium.history.ui.chart.HistoryItem;
import java.util.ArrayList;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.history.BIHistory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HistoryListModel {
    protected BHistoryList owner;
    protected ArrayList list;

    public int size() {
        return this.list.size();
    }

    public HistoryItem get(int n) {
        return (HistoryItem)this.list.get(n);
    }

    public void add(BIHistory bIHistory) {
        this.doAdd(new HistoryItem(bIHistory));
        this.changed();
    }

    public void add(HistoryItem historyItem) {
        this.doAdd(historyItem);
        this.changed();
    }

    public void add(BIHistory[] bIHistoryArray) {
        int n = 0;
        while (n < bIHistoryArray.length) {
            this.doAdd(new HistoryItem(bIHistoryArray[n]));
            ++n;
        }
        this.changed();
    }

    public void add(HistoryItem[] historyItemArray) {
        int n = 0;
        while (n < historyItemArray.length) {
            this.doAdd(historyItemArray[n]);
            ++n;
        }
        this.changed();
    }

    protected void doAdd(HistoryItem historyItem) {
        this.assignColor(historyItem);
        this.list.add(historyItem);
    }

    public void moveUp(HistoryItem historyItem) {
        int n = this.list.indexOf(historyItem);
        if (n == 0) {
            return;
        }
        Object e = this.list.get(n - 1);
        this.list.set(n - 1, this.list.get(n));
        this.list.set(n, e);
        this.changed();
    }

    public void moveDown(HistoryItem historyItem) {
        int n = this.list.indexOf(historyItem);
        if (n == this.list.size() - 1) {
            return;
        }
        Object e = this.list.get(n + 1);
        this.list.set(n + 1, this.list.get(n));
        this.list.set(n, e);
        this.changed();
    }

    public void remove(HistoryItem historyItem) {
        this.list.remove(historyItem);
        this.changed();
    }

    public void clear() {
        this.list.clear();
        this.changed();
    }

    public HistoryListModel copy() {
        HistoryListModel historyListModel = new HistoryListModel();
        int n = 0;
        while (n < this.size()) {
            historyListModel.list.add(this.get(n).copy());
            ++n;
        }
        return historyListModel;
    }

    public void changed() {
        if (this.owner != null) {
            this.owner.modelChanged();
        }
    }

    private final void assignColor(HistoryItem historyItem) {
        BBrush bBrush = historyItem.getBrush();
        BColor[] bColorArray = BChartPane.DEFAULT_COLORS;
        int n = 0;
        while (n < bColorArray.length) {
            bBrush = bColorArray[n].toBrush();
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.size()) {
                BBrush bBrush2;
                HistoryItem historyItem2 = this.get(n2);
                if (historyItem != historyItem2 && bBrush.equals((Object)(bBrush2 = historyItem2.getBrush()))) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) break;
            ++n;
        }
        historyItem.setBrush(bBrush);
    }

    void setOwner(BHistoryList bHistoryList) {
        this.owner = bHistoryList;
    }

    private final /* synthetic */ void this() {
        this.list = new ArrayList();
    }

    public HistoryListModel() {
        this.this();
    }
}

