/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.collection.BRecordTable;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.history.ui.HistorySourceSubscriber;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.BFilterSetDialog;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryTable
extends BWbView {
    public static final Property showTimeRangeEditor = BHistoryTable.newProperty((int)0, (boolean)true, null);
    public static final Property defaultTimeRange = BHistoryTable.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Property showDeltaEditor = BHistoryTable.newProperty((int)0, (boolean)true, null);
    public static final Property defaultDelta = BHistoryTable.newProperty((int)0, (boolean)false, null);
    public static final Property showLiveUpdates = BHistoryTable.newProperty((int)0, (boolean)true, null);
    public static final Property defaultLiveUpdates = BHistoryTable.newProperty((int)0, (boolean)false, null);
    public static final Action query = BHistoryTable.newAction((int)16, null);
    public static final Type TYPE;
    private static Lexicon lex;
    private static Map states;
    private static final String lexRecords;
    private BToolBar toolbar;
    private BTitlePane tablePane;
    private boolean useBql;
    private BDynamicTimeRangeFE timeRangeEd;
    private BToggleButton deltaEd;
    private BTable table;
    private int lastRowCount;
    private boolean sizedToFit;
    private boolean deltaEnabled;
    private Command filterCmd;
    private ToggleCommand deltaCmd;
    private BFilterSet filterSet;
    private Context tzContext;
    private BLabel liveUpdatesStatus;
    private BAbstractButton toolBarLiveUpdatesButton;
    private BToggleButton liveUpdatesToggle;
    private ToggleCommand liveUpdatesCmd;
    private HistoryTableSubscriber mySubscriber;
    private BHistory currentHistory;
    private BIHistory cachedHistory;
    private BObject cachedValue;
    public Object syncObj;
    public BAbsTime lastTimestamp;
    private BITable lastQueryResult;
    private boolean lastUpdateState;
    private boolean tableReady;
    static /* synthetic */ Class class$com$tridium$history$ui$BHistoryTable;

    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    public void setShowTimeRangeEditor(boolean bl) {
        this.setBoolean(showTimeRangeEditor, bl, null);
    }

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange bDynamicTimeRange) {
        this.set(defaultTimeRange, (BValue)bDynamicTimeRange, null);
    }

    public boolean getShowDeltaEditor() {
        return this.getBoolean(showDeltaEditor);
    }

    public void setShowDeltaEditor(boolean bl) {
        this.setBoolean(showDeltaEditor, bl, null);
    }

    public boolean getDefaultDelta() {
        return this.getBoolean(defaultDelta);
    }

    public void setDefaultDelta(boolean bl) {
        this.setBoolean(defaultDelta, bl, null);
    }

    public boolean getShowLiveUpdates() {
        return this.getBoolean(showLiveUpdates);
    }

    public void setShowLiveUpdates(boolean bl) {
        this.setBoolean(showLiveUpdates, bl, null);
    }

    public boolean getDefaultLiveUpdates() {
        return this.getBoolean(defaultLiveUpdates);
    }

    public void setDefaultLiveUpdates(boolean bl) {
        this.setBoolean(defaultLiveUpdates, bl, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("filter", this.filterCmd);
        this.toolBarLiveUpdatesButton = bToolBar.add("liveUpdates", (Command)this.liveUpdatesCmd);
        bToolBar.add("delta", (Command)this.deltaCmd);
        return bToolBar;
    }

    public BTable getExportTable() {
        return this.table;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.liveUpdatesStatus;
    }

    private final void initCommands() {
        this.filterCmd = new Command((BWidget)this, BHistoryTable.lex.module, "command.filter"){

            public final CommandArtifact doInvoke() {
                BHistoryTable.this.configFilters();
                return null;
            }
        };
        this.deltaCmd = new ToggleCommand((BWidget)this, BHistoryTable.lex.module, "command.delta"){

            public final CommandArtifact doInvoke() {
                BHistoryTable.this.query();
                return null;
            }
        };
        this.liveUpdatesCmd = new ToggleCommand((BWidget)this, BHistoryTable.lex.module, "command.liveUpdates"){

            public final CommandArtifact doInvoke() {
                if (!this.isEnabled()) {
                    return null;
                }
                boolean bl = this.isSelected();
                if (bl == BHistoryTable.this.lastUpdateState) {
                    return null;
                }
                BHistoryTable.this.lastUpdateState = bl;
                if (BHistoryTable.this.currentHistory != null) {
                    if (bl) {
                        BHistoryTable.this.liveUpdatesStatus.setVisible(true);
                        BHistoryTable.this.liveUpdatesStatus.relayoutSync();
                        BHistoryTable.this.currentHistory.subscribe(BHistoryTable.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(BHistoryTable.this.getCurrentContext()));
                    } else {
                        BHistoryTable.this.currentHistory.unsubscribe(BHistoryTable.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(BHistoryTable.this.getCurrentContext()));
                    }
                }
                if (bl) {
                    this.icon = BHistoryChart.PAUSE_ICON;
                    if (BHistoryTable.this.toolBarLiveUpdatesButton != null) {
                        BHistoryTable.this.toolBarLiveUpdatesButton.setImage(BHistoryChart.PAUSE_ICON);
                    }
                    BHistoryTable.this.liveUpdatesToggle.setImage(BHistoryChart.PAUSE_ICON);
                } else {
                    BHistoryTable.this.liveUpdatesStatus.setVisible(false);
                    BHistoryTable.this.liveUpdatesStatus.relayoutSync();
                    this.icon = BHistoryChart.PLAY_ICON;
                    if (BHistoryTable.this.toolBarLiveUpdatesButton != null) {
                        BHistoryTable.this.toolBarLiveUpdatesButton.setImage(BHistoryChart.PLAY_ICON);
                    }
                    BHistoryTable.this.liveUpdatesToggle.setImage(BHistoryChart.PLAY_ICON);
                }
                return null;
            }
        };
    }

    public void doLoadValue(BObject bObject, Context context) {
        BAbsTime bAbsTime;
        int n;
        BIHistory bIHistory = this.getHistory(bObject);
        if (bIHistory instanceof BHistory) {
            if (bIHistory instanceof BFoxHistory) {
                if (bIHistory != this.currentHistory) {
                    try {
                        this.currentHistory.unsubscribe(this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                    }
                    catch (Exception exception) {}
                    this.currentHistory = (BHistory)bIHistory;
                }
            } else if (this.currentHistory != null) {
                if (this.currentHistory.getId().equals((Object)bIHistory.getId())) {
                    bIHistory = this.currentHistory;
                } else {
                    try {
                        this.currentHistory.unsubscribe(this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                    }
                    catch (Exception exception) {}
                    this.currentHistory = (BHistory)bIHistory;
                }
            } else {
                this.currentHistory = (BHistory)bIHistory;
            }
        } else {
            if (this.currentHistory != null) {
                try {
                    this.currentHistory.unsubscribe(this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                }
                catch (Exception exception) {}
            }
            this.currentHistory = null;
        }
        this.tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)bIHistory.getConfig().getTimeZone()));
        this.tablePane.setTitle(bIHistory.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        BTypeSpec bTypeSpec = bIHistory.getRecordType();
        Type type = bTypeSpec.getResolvedType();
        this.deltaEnabled = type.is(BNumericTrendRecord.TYPE);
        this.deltaCmd.setEnabled(this.deltaEnabled);
        boolean bl = false;
        if (this.currentHistory != null && this.currentHistory.canSubscribe(context)) {
            bl = true;
        }
        boolean bl2 = bl;
        this.liveUpdatesCmd.setEnabled(bl2);
        this.rebuildToolbar();
        BHistorySpace bHistorySpace = (BHistorySpace)bIHistory.getSpace();
        this.useBql = true;
        try {
            BOrd.make((BOrd)bHistorySpace.getAbsoluteOrd(), (String)"bql:").resolve();
        }
        catch (Exception exception) {
            this.useBql = false;
        }
        BDynamicTimeRange bDynamicTimeRange = this.getDefaultTimeRange();
        if (bDynamicTimeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.make((BAbsTime)bIHistory.getFirstTimestamp(), (BAbsTime)BAbsTime.NULL), this.tzContext);
            n = bIHistory.getRecordCount();
            bAbsTime = bIHistory.getLastTimestamp();
            if (n > 500) {
                BAbsTime bAbsTime2 = Clock.time();
                if (bAbsTime2.dateEquals(bAbsTime)) {
                    this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY, this.tzContext);
                } else {
                    BDynamicTimeRange bDynamicTimeRange2 = BDynamicTimeRange.make((BAbsTime)bAbsTime.timeOfDay(0, 0, 0, 0), (BAbsTime)BAbsTime.NULL);
                    this.timeRangeEd.loadValue((BObject)bDynamicTimeRange2, this.tzContext);
                }
            }
        } else {
            this.timeRangeEd.loadValue((BObject)bDynamicTimeRange, this.tzContext);
        }
        boolean bl3 = false;
        if (this.deltaEnabled && this.getDefaultDelta()) {
            bl3 = true;
        }
        this.deltaEd.setSelected(bl3);
        boolean bl4 = false;
        if (bl2 && this.getDefaultLiveUpdates()) {
            bl4 = true;
        }
        this.liveUpdatesToggle.setSelected(bl4);
        this.restoreState(this.toKey());
        n = bIHistory instanceof BFoxHistory ^ 1;
        if (context != null && (bAbsTime = context.getFacet("syncHistoryLoad")) instanceof BBoolean) {
            n = ((BBoolean)bAbsTime).getBoolean() ? 1 : 0;
        }
        if (n != 0) {
            this.doQuery();
        } else {
            this.query();
        }
    }

    public void changed(Property property, Context context) {
        if (property == showTimeRangeEditor || property == showDeltaEditor || property == showLiveUpdates) {
            this.rebuildToolbar();
        }
    }

    private final void rebuildToolbar() {
        boolean bl = false;
        if (this.currentHistory != null && this.getShowLiveUpdates()) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (this.deltaEnabled && this.getShowDeltaEditor()) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = this.getShowTimeRangeEditor();
        this.toolbar.removeAll();
        if (bl2) {
            this.toolbar.add(null, (BValue)this.liveUpdatesToggle);
        }
        if (bl2 && (bl4 || bl5)) {
            this.toolbar.add(null, (BValue)new BSeparator());
        }
        if (bl4) {
            this.toolbar.add(null, (BValue)this.deltaEd);
        }
        if (bl4 && bl5) {
            this.toolbar.add(null, (BValue)new BSeparator());
        }
        if (bl5) {
            this.toolbar.add(null, (BValue)this.timeRangeEd);
        }
        if (this.getContent() instanceof BEdgePane) {
            BWidget bWidget = ((BEdgePane)this.getContent()).getTop();
            boolean bl6 = false;
            if (this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor()) {
                bl6 = true;
            }
            bWidget.setVisible(bl6);
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe(this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
            }
            catch (Exception exception) {}
            this.currentHistory = null;
        }
        return bObject;
    }

    public void doQuery() {
        this.doQuery(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doQuery(boolean var1_1) {
        var2_2 = this.syncObj;
        synchronized (var2_2) {
            block42: {
                block40: {
                    var4_3 = this.getShell();
                    if (var4_3 != null && !var1_1) {
                        var4_3.enterBusy();
                    }
                    try {
                        block43: {
                            var7_4 = this.getHistory(this.getCurrentValue());
                            var8_5 /* !! */  = null;
                            var9_6 = null;
                            var10_7 = false;
                            var9_6 = (BDynamicTimeRange)this.timeRangeEd.saveValue();
                            if (!var1_1 || BAbsTime.NULL.equals((Object)this.lastTimestamp)) ** GOTO lbl38
                            var11_8 = this.lastTimestamp.add(BRelTime.make((long)1L));
                            var12_10 /* !! */  = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)var7_4.getConfig().getTimeZone());
                            var13_11 = var9_6.getStartTime(var12_10 /* !! */ );
                            if (!BAbsTime.NULL.equals(var13_11) && !var11_8.isAfter((BAbsTime)var13_11)) ** GOTO lbl38
                            var14_12 = var9_6.getEndTime(var12_10 /* !! */ );
                            if (!BAbsTime.NULL.equals((Object)var14_12) && !var11_8.isBefore((BAbsTime)var14_12)) break block43;
                            var9_6 = BDynamicTimeRange.make((BAbsTime)var11_8, (BAbsTime)var14_12);
                            var10_7 = true;
                            ** GOTO lbl38
                        }
                        var6_13 = null;
                        this.tableReady = true;
                        if (var4_3 != null && !var1_1) {
                            break block40;
                        }
                        ** GOTO lbl36
                        {
                            block44: {
                                block41: {
                                    catch (Exception var11_9) {
                                        if (!var1_1) {
                                            BDialog.error((BWidget)this, (String)BHistoryTable.lex.getText("timerange.error"), (Object)BHistoryTable.lex.getText("timerange.checkRange"), (Throwable)var11_9);
                                        }
                                        throw new BajaRuntimeException((Throwable)var11_9);
                                    }
lbl36:
                                    // 2 sources

                                    return;
lbl38:
                                    // 3 sources

                                    ** try [egrp 4[TRYBLOCK] [6 : 193->962)] { 
lbl39:
                                    // 1 sources

                                    var11_8 = var7_4.getOrdInSession();
                                    var12_10 /* !! */  = "?" + var9_6.toOrdParams() + ";delta=" + String.valueOf(this.deltaCmd.isSelected());
                                    var13_11 = var11_8.toString();
                                    var14_12 = "";
                                    var15_18 = var13_11.indexOf("history:");
                                    var16_19 = var13_11.indexOf("|", var15_18);
                                    if (var16_19 > 0) {
                                        var14_12 = var13_11.substring(var16_19);
                                        var13_11 = var13_11.substring(0, var16_19);
                                    }
                                    var17_20 = BOrd.make((String)((String)var13_11 + (String)var12_10 /* !! */  + var14_12));
                                    if (this.useBql) {
                                        var18_21 = new StringBuffer(64);
                                        var18_21.append(var17_20.toString()).append('|');
                                        var18_21.append("bql:select *");
                                        var19_23 = new StringBuffer(64);
                                        if (this.filterSet != null && (var20_25 = this.filterSet.getPredicate()) != null && var20_25.length() > 0) {
                                            if (var19_23.length() != 0) {
                                                var19_23.append(" and ");
                                            }
                                            var19_23.append((String)var20_25);
                                        }
                                        if (var19_23.length() != 0) {
                                            var18_21.append(" where ").append(var19_23.toString());
                                        }
                                        var20_25 = BOrd.make((BOrd)var7_4.getAbsoluteOrd(), (BOrd)BOrd.make((String)var18_21.toString())).normalize();
                                        var8_5 /* !! */  = ((BICollection)var20_25.resolve().get()).toTable();
                                    } else {
                                        var18_21 = BOrd.make((BOrd)var7_4.getAbsoluteOrd(), (BOrd)var17_20).normalize();
                                        var8_5 /* !! */  = ((BICollection)var18_21.resolve().get()).toTable();
                                    }
                                    if (!var10_7) ** GOTO lbl96
                                    if (var8_5 /* !! */  == null || var8_5 /* !! */ .size() <= 0) ** GOTO lbl95
                                    if (this.lastQueryResult instanceof BRecordTable && var8_5 /* !! */  instanceof BRecordTable) {
                                        var18_21 = (BRecordTable)this.lastQueryResult;
                                        var19_23 = (BRecordTable)var8_5 /* !! */ ;
                                        var20_26 = var8_5 /* !! */ .size();
                                        var21_30 = 0;
                                        while (true) {
                                            if (var21_30 >= var20_26) {
                                                var8_5 /* !! */  = var18_21;
                                                break block41;
                                            }
                                            var18_21.add(var19_23.remove(0));
                                            ++var21_30;
                                        }
                                    }
                                    if (this.lastQueryResult instanceof BHistoryTimeQuery && var8_5 /* !! */  instanceof BHistoryTimeQuery) {
                                        var8_5 /* !! */  = ((BHistoryTimeQuery)this.lastQueryResult).combine((BHistoryTimeQuery)var8_5 /* !! */ );
                                    } else {
                                        if (!(this.lastQueryResult instanceof BHistoryDeltaQuery) || !(var8_5 /* !! */  instanceof BHistoryDeltaQuery)) {
                                            this.doQuery(false);
                                            break block42;
                                        }
                                        var8_5 /* !! */  = ((BHistoryDeltaQuery)this.lastQueryResult).combine((BHistoryDeltaQuery)var8_5 /* !! */ );
                                    }
                                }
                                break block44;
lbl95:
                                // 1 sources

                                var8_5 /* !! */  = this.lastQueryResult;
                            }
                            var18_22 = this.table.getSortColumn();
                            var19_24 = true;
                            if (var1_1) {
                                var20_25 = this.table.getModel();
                                var21_31 = null;
                                if (var20_25 instanceof DynamicTableModel) {
                                    var21_31 = ((DynamicTableModel)var20_25).getRootModel();
                                }
                                if (var21_31 instanceof CollectionTableModel) {
                                    ((CollectionTableModel)var21_31).setCollection((BICollection)var8_5 /* !! */ );
                                    var19_24 = false;
                                }
                                if (var18_22 != -1) {
                                    var20_25.sortByColumn(var18_22, this.table.isSortAscending());
                                }
                            }
                            try {
                                this.loadData(var8_5 /* !! */ , var19_24, var7_4);
                            }
                            catch (Exception var20_27) {
                                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)BHistoryTable.lex.getText("historyChart.noChartableValue"), (Throwable)var20_27);
                                var6_15 = null;
                                this.tableReady = true;
                                if (var4_3 != null && !var1_1) {
                                    var4_3.exitBusy();
                                }
                                return;
                            }
                            try {
                                var20_28 = var8_5 /* !! */ .size();
                                if (var20_28 > 0) {
                                    this.lastTimestamp = ((BHistoryRecord)var8_5 /* !! */ .get(var20_28 - 1)).getTimestamp();
                                    this.lastQueryResult = var8_5 /* !! */ ;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Exception var20_29) {
                                var20_29.printStackTrace();
                            }
                            ** GOTO lbl-1000
                        }
                    }
lbl131:
                    // 3 sources

                    catch (Throwable var5_32) {
                        var6_16 = null;
                        this.tableReady = true;
                        if (var4_3 != null && !var1_1) {
                            var4_3.exitBusy();
                        }
                        throw var5_32;
                    }
                }
                var4_3.exitBusy();
                ** continue;
            }
            var6_14 = null;
            this.tableReady = true;
            if (var4_3 != null && !var1_1) {
                var4_3.exitBusy();
            }
            return;
lbl-1000:
            // 3 sources

            {
                var6_17 = null;
                this.tableReady = true;
                if (var4_3 != null && !var1_1) {
                    var4_3.exitBusy();
                }
            }
            return;
        }
    }

    public void loadData(BITable bITable, boolean bl, BIHistory bIHistory) {
        int n = this.table.getSortColumn();
        if (bl) {
            DynamicTableModel dynamicTableModel;
            CollectionTableModel collectionTableModel = new CollectionTableModel(bITable, this.getCurrentContext());
            int[] nArray = null;
            if (this.table.getModel() instanceof DynamicTableModel) {
                dynamicTableModel = (DynamicTableModel)this.table.getModel();
                nArray = new int[dynamicTableModel.getColumnCount()];
                int n2 = 0;
                while (n2 < dynamicTableModel.getColumnCount()) {
                    nArray[n2] = dynamicTableModel.toRootColumnIndex(n2);
                    ++n2;
                }
            }
            dynamicTableModel = null;
            dynamicTableModel = nArray != null ? new DynamicTableModel((TableModel)collectionTableModel, nArray) : new DynamicTableModel((TableModel)collectionTableModel);
            if (n != -1) {
                dynamicTableModel.sortByColumn(n, this.table.isSortAscending());
            }
            this.table.setModel((TableModel)dynamicTableModel);
            this.table.relayout();
            if (!this.sizedToFit && this.lastRowCount == 0 && bITable.size() != 0) {
                this.sizedToFit = true;
                this.table.sizeColumnsToFit();
            }
            this.updateTitle();
        }
        this.tablePane.tableModified();
    }

    public boolean isReady() {
        return this.tableReady;
    }

    private final void updateTitle() {
        BIHistory bIHistory = this.getHistory(this.getCurrentValue());
        if (bIHistory == null) {
            this.tablePane.setTitle("");
            return;
        }
        String string = bIHistory.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX);
        if (this.filterSet != null && this.filterSet.anyActive()) {
            string = string + '*';
        }
        this.tablePane.setTitle(string);
    }

    public void stopped() throws Exception {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe(this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {}
            this.currentHistory = null;
        }
        super.stopped();
    }

    public void configFilters() {
        BFilterSetDialog bFilterSetDialog;
        if (this.table == null) {
            return;
        }
        if (this.filterSet == null) {
            bFilterSetDialog = ((CollectionTableModel)((DynamicTableModel)this.table.getModel()).getRootModel()).getBITable();
            this.filterSet = this.buildFilterSet((BITable)bFilterSetDialog);
        }
        bFilterSetDialog = new BFilterSetDialog((BWidget)this, this.filterSet);
        bFilterSetDialog.setBoundsCenteredOnOwner();
        bFilterSetDialog.open();
        if (bFilterSetDialog.isCancelled()) {
            return;
        }
        if (!bFilterSetDialog.isModified()) {
            return;
        }
        this.filterSet = bFilterSetDialog.getResult();
        this.query();
    }

    private final BFilterSet buildFilterSet(BITable bITable) {
        ColumnList columnList = bITable.getColumns();
        int n = columnList.size();
        BFilterSet bFilterSet = new BFilterSet();
        int n2 = 0;
        while (n2 < n) {
            Type type = null;
            BFacets bFacets = null;
            try {
                AgentList agentList;
                String string;
                Column column = columnList.get(n2);
                bFacets = column.getFacets();
                if (bFacets != null && (string = bFacets.gets("origType", null)) != null) {
                    type = BTypeSpec.make((String)string).getResolvedType();
                }
                if (type == null) {
                    type = column.getType();
                }
                if ((string = type.getInstance()) instanceof BEnum && bFacets != null && bFacets.getFacet("range") != null) {
                    string = BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)bFacets.getFacet("range")));
                }
                if ((agentList = string.getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() != 0) {
                    BIBqlFilter bIBqlFilter = (BIBqlFilter)agentList.getDefault().getInstance();
                    bIBqlFilter.init((BObject)string);
                    BFilterEntry bFilterEntry = new BFilterEntry(false, column.getDisplayName(this.getCurrentContext()), bIBqlFilter);
                    bFilterSet.add(column.getName(), (BValue)bFilterEntry, 0, bFacets, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        try {
            bFilterSet.remove("timestamp");
        }
        catch (Exception exception) {}
        return bFilterSet;
    }

    protected BIHistory getHistory(BObject bObject) {
        if (bObject != this.cachedValue || this.cachedHistory == null) {
            this.cachedValue = bObject;
            if (bObject instanceof BIHistory) {
                this.cachedHistory = (BIHistory)bObject;
            } else if (bObject instanceof BHistoryExt) {
                BHistoryExt bHistoryExt = (BHistoryExt)bObject;
                bHistoryExt.lease(1);
                BHistoryConfig bHistoryConfig = bHistoryExt.getHistoryConfig();
                BHistoryId bHistoryId = bHistoryConfig.getId();
                BOrd bOrd = bHistoryExt.getAbsoluteOrd();
                BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("history: " + (Object)((Object)bHistoryId)));
                this.cachedHistory = (BIHistory)bOrd2.resolve().get();
            } else {
                this.cachedHistory = null;
            }
        }
        return this.cachedHistory;
    }

    private final String toKey() {
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell == null) {
            return null;
        }
        OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
        if (ordTarget == null) {
            return null;
        }
        return "" + ordTarget.getOrdWithoutViewQuery();
    }

    public void activated() {
        this.restoreState(this.toKey());
    }

    public void deactivated() {
        this.saveState(this.toKey());
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe(this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {}
            this.currentHistory = null;
        }
    }

    private final void saveState(String string) {
        try {
            State state = new State();
            state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            state.filterSet = this.filterSet == null ? null : (BFilterSet)this.filterSet.newCopy(true);
            state.deltaState = this.deltaCmd.isSelected();
            state.liveUpdatesState = this.liveUpdatesCmd.isSelected();
            states.put(string, state);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void restoreState(String string) {
        if (string == null) {
            return;
        }
        State state = (State)states.get(string);
        if (state == null) {
            return;
        }
        this.timeRangeEd.loadValue((BObject)state.timeRange, this.tzContext);
        this.filterSet = state.filterSet;
        this.deltaCmd.setSelected(state.deltaState);
        this.liveUpdatesCmd.setSelected(state.liveUpdatesState);
    }

    public BIHistory getHistory() {
        return this.getHistory(this.getCurrentValue());
    }

    public BDynamicTimeRange getRange() throws Exception {
        return (BDynamicTimeRange)this.timeRangeEd.saveValue();
    }

    public boolean isDelta() {
        return this.deltaCmd.isSelected();
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    static /* synthetic */ BIHistory access$9(BHistoryTable bHistoryTable) {
        return bHistoryTable.cachedHistory;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.useBql = true;
        this.lastRowCount = 0;
        this.sizedToFit = false;
        this.mySubscriber = new HistoryTableSubscriber(this);
        this.currentHistory = null;
        this.cachedHistory = null;
        this.cachedValue = null;
        this.syncObj = new Object();
        this.lastTimestamp = BAbsTime.NULL;
        this.lastQueryResult = null;
        this.lastUpdateState = false;
        this.tableReady = false;
    }

    public BHistoryTable() {
        this.this();
        this.initCommands();
        BEdgePane bEdgePane = new BEdgePane();
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        this.deltaEd = new BToggleButton(this.deltaCmd, false, true);
        this.deltaEd.setSelected(false);
        this.deltaEd.setVisible(this.getShowDeltaEditor());
        this.liveUpdatesToggle = new BToggleButton(this.liveUpdatesCmd, false, true);
        this.liveUpdatesToggle.setSelected(false);
        this.liveUpdatesToggle.setVisible(this.getShowLiveUpdates());
        this.liveUpdatesStatus = new BLabel(lex.getText("history.liveUpdates.inProgress"), BHalign.right);
        this.liveUpdatesStatus.setVisible(false);
        this.toolbar = new BToolBar();
        this.rebuildToolbar();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)this.toolbar, 0.0, 0.0, (double)5, 0.0));
        BWidget bWidget = bEdgePane.getTop();
        boolean bl = false;
        if (this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor()) {
            bl = true;
        }
        bWidget.setVisible(bl);
        this.table = new BTable();
        this.table.setController((TableController)new HistoryTableController());
        this.tablePane = BTitlePane.makePane((String)"", (BTable)this.table, (String)lexRecords);
        bEdgePane.setCenter((BWidget)this.tablePane);
        this.setContent((BWidget)bEdgePane);
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
    }

    static {
        Class clazz = class$com$tridium$history$ui$BHistoryTable;
        if (clazz == null) {
            clazz = class$com$tridium$history$ui$BHistoryTable = BHistoryTable.class("[Lcom.tridium.history.ui.BHistoryTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"history");
        states = new Hashtable();
        lexRecords = lex.getText("records");
    }

    private static class State {
        BDynamicTimeRange timeRange;
        BFilterSet filterSet;
        boolean deltaState;
        boolean liveUpdatesState;

        private State() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class HistoryTableSubscriber
    extends HistorySourceSubscriber {
        BHistoryTable table;

        protected boolean allowCoalescedEvents() {
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void historySourceEvent(BComponentEvent bComponentEvent) {
            try {
                this.table.doQuery(true);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                BasicContext basicContext = new BasicContext(this.table.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
                this.table.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", (Object[])new String[]{BAbsTime.now().toString((Context)basicContext)}));
                this.table.liveUpdatesStatus.relayoutSync();
                throw throwable;
            }
            {
                Object var3_4 = null;
            }
            BasicContext basicContext = new BasicContext(this.table.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
            this.table.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", (Object[])new String[]{BAbsTime.now().toString((Context)basicContext)}));
            this.table.liveUpdatesStatus.relayoutSync();
        }

        protected void unsubscribed(BComponent bComponent, Context context) {
            try {
                BOrd bOrd;
                BOrd bOrd2;
                BHistorySpace bHistorySpace;
                BIHistory bIHistory;
                BIHistory bIHistory2 = this.table.getHistory(this.table.getCurrentValue());
                if (this.table.getShell() instanceof BWbShell && (bIHistory = (bHistorySpace = (BHistorySpace)(bOrd2 = BOrd.make((BOrd)(bOrd = ((BWbShell)this.table.getShell()).getActiveOrd()), (String)"history:")).get()).getHistory(bIHistory2.getId())) != bIHistory2) {
                    this.table.cachedHistory = bIHistory;
                    if (bIHistory instanceof BHistory) {
                        this.table.currentHistory = (BHistory)bIHistory;
                    } else {
                        this.table.currentHistory = null;
                    }
                    if (this.table.liveUpdatesCmd.isSelected()) {
                        this.table.liveUpdatesCmd.setSelected(false);
                        if (this.table.currentHistory != null) {
                            this.table.liveUpdatesCmd.setSelected(true);
                        }
                    }
                    if (this.table.currentHistory == null) {
                        this.table.liveUpdatesCmd.setEnabled(false);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private final /* synthetic */ void this() {
            this.table = null;
        }

        public HistoryTableSubscriber(BHistoryTable bHistoryTable) {
            this.this();
            this.table = bHistoryTable;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HistoryTableController
    extends TableController {
        protected BMenu makeOptionsMenu() {
            BTable bTable = this.getTable();
            BMenu bMenu = super.makeOptionsMenu();
            BMenuItem bMenuItem = (BMenuItem)bMenu.get("export");
            if (bMenuItem != null) {
                bMenuItem.setCommand((Command)new ExportCommand(bTable.getParentWidget()));
            } else {
                bMenu.add("export", (Command)new ExportCommand(bTable.getParentWidget()));
            }
            return bMenu;
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            BIHistory bIHistory = BHistoryTable.this.getHistory(BHistoryTable.this.getCurrentValue());
            if (bMouseEvent.getClickCount() == 2) {
                BRecordTable bRecordTable = (BRecordTable)((CollectionTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel()).getBITable();
                BHistoryRecord bHistoryRecord = (BHistoryRecord)bRecordTable.get(n);
                Property[] propertyArray = bHistoryRecord.loadSlots().getPropertiesArray();
                int n3 = propertyArray.length;
                int n4 = 2;
                BGridPane bGridPane = new BGridPane(n4);
                bGridPane.setColorRows(true);
                bGridPane.setColumnGap(9.0);
                int n5 = 0;
                while (n5 < n3) {
                    Object object;
                    Object object2;
                    BFacets bFacets;
                    BLabel bLabel = new BLabel(bHistoryRecord.getDisplayName((Slot)propertyArray[n5], null), BHalign.left);
                    bLabel.setFont(Theme.label().getBoldText());
                    bGridPane.add(null, (BValue)bLabel, null);
                    if (propertyArray[n5].getType() == BFacets.TYPE) {
                        bFacets = (BFacets)bHistoryRecord.get(propertyArray[n5]);
                        object2 = new BGridPane(2);
                        object = bFacets.list();
                        int n6 = 0;
                        while (n6 < ((String[])object).length) {
                            BLabel bLabel2 = new BLabel(object[n6], BHalign.left);
                            bLabel2.setFont(Theme.label().getBoldText());
                            object2.add(null, (BValue)bLabel2, null);
                            object2.add(null, (BValue)new BLabel(bFacets.getFacet((String)object[n6]).toString(), BHalign.left), null);
                            ++n6;
                        }
                        bGridPane.add(null, (BValue)object2, null);
                    } else if (propertyArray[n5].getType() == BOrdList.TYPE) {
                        try {
                            String string;
                            bFacets = (BOrdList)bHistoryRecord.get(propertyArray[n5]);
                            object2 = new StringTokenizer(bFacets.encodeToString(), "|");
                            object = new StringBuffer();
                            BGridPane bGridPane2 = new BGridPane(1);
                            int n7 = bFacets.size() - 1;
                            while (n7 >= 0) {
                                ((StringBuffer)object).insert(0, SlotPath.unescape((String)bFacets.get(n7).encodeToString()).toString());
                                if (((StringTokenizer)object2).hasMoreTokens()) {
                                    ((StringBuffer)object).insert(0, "\n");
                                }
                                --n7;
                            }
                            object2 = new StringTokenizer(((StringBuffer)object).toString());
                            n7 = 1;
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                string = "";
                                string = n7 != 0 ? ((StringTokenizer)object2).nextToken() : "-> " + ((StringTokenizer)object2).nextToken();
                                n7 = 0;
                                bGridPane2.add(null, (BValue)new BLabel(string));
                            }
                            string = new BLabel("source", BHalign.left);
                            string.setFont(Theme.label().getBoldText());
                            bGridPane.add(null, (BValue)bGridPane2, null);
                        }
                        catch (Exception exception) {
                            bGridPane.add(null, (BValue)new BLabel("unknown"), null);
                        }
                    } else {
                        bFacets = null;
                        try {
                            bFacets = (BFacets)bIHistory.getConfig().get(propertyArray[n5].getName() + "Facets");
                        }
                        catch (Exception exception) {}
                        bGridPane.add(null, (BValue)new BLabel(SlotPath.unescape((String)bHistoryRecord.get(propertyArray[n5]).toString((Context)bFacets)), BHalign.left), null);
                    }
                    ++n5;
                }
                BDialog.open((BWidget)BHistoryTable.this, (String)"History Record", (Object)bGridPane, (int)1);
            }
        }

        HistoryTableController() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class ExportCommand
        extends Command {
            public CommandArtifact doInvoke() {
                try {
                    BExportDialog.invoke((BWbShell)BHistoryTable.this.getWbShell(), (boolean)false);
                }
                catch (Exception exception) {}
                return null;
            }

            public ExportCommand(BWidget bWidget) {
                super(bWidget, (Lexicon)UiLexicon.bajaui, "commands.export");
            }
        }
    }
}

