/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.ui.BOutlierParams;
import com.tridium.history.ui.BOutlierParamsFE;
import com.tridium.history.ui.BTrendRecordEditor;
import com.tridium.history.ui.HistoryEditorCellRenderer;
import com.tridium.history.ui.HistoryEditorTableModel;
import com.tridium.workbench.bql.filter.BFilterSetDialog;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryEditor
extends BWbView {
    public static final Property showTimeRangeEditor = BHistoryEditor.newProperty((int)0, (boolean)true, null);
    public static final Property defaultTimeRange = BHistoryEditor.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Action query = BHistoryEditor.newAction((int)16, null);
    public static final Action updateCommandStates = BHistoryEditor.newAction((int)0, null);
    public static final Type TYPE;
    private static BOutlierParams options;
    private static Lexicon lex;
    private static HashMap states;
    private final String lexRecords;
    private BIHistory history;
    private Context tzContext;
    private boolean useBql;
    private BDynamicTimeRangeFE timeRangeEd;
    private BTitlePane tablePane;
    private BTable table;
    private int lastRowCount;
    private boolean sizedToFit;
    private Command filterCmd;
    private BFilterSet filterSet;
    private Command outliersCmd;
    private BOutlierParams outlierParams;
    private Command editCmd;
    private Command selectOutliersCmd;
    private Command hideCmd;
    private Command unhideCmd;
    static /* synthetic */ Class class$com$tridium$history$ui$BHistoryEditor;

    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    public void setShowTimeRangeEditor(boolean bl) {
        this.setBoolean(showTimeRangeEditor, bl, null);
    }

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange bDynamicTimeRange) {
        this.set(defaultTimeRange, (BValue)bDynamicTimeRange, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public void updateCommandStates() {
        this.invoke(updateCommandStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("hide", this.hideCmd);
        bToolBar.add("unhide", this.unhideCmd);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add("filter", this.filterCmd);
        bToolBar.add("outliers", this.outliersCmd);
        return bToolBar;
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = new BMenu(lex.getText("historyEditor"));
        bMenu.add("hide", this.hideCmd);
        bMenu.add("unhide", this.unhideCmd);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add("filter", this.filterCmd);
        bMenu.add("outliers", this.outliersCmd);
        bMenu.add("selectOutliers", this.selectOutliersCmd);
        return new BMenu[]{bMenu};
    }

    private final void initCommands() {
        this.filterCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "command.filter"){

            public final CommandArtifact doInvoke() {
                BHistoryEditor.this.configFilters();
                return null;
            }
        };
        this.outliersCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.configOutliers"){

            public final CommandArtifact doInvoke() {
                BHistoryEditor.this.configOutliers();
                return null;
            }
        };
        this.editCmd = new EditCommand();
        this.selectOutliersCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.selectOutliers"){

            public final CommandArtifact doInvoke() {
                BHistoryEditor.this.selectOutliers();
                return null;
            }
        };
        this.hideCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.hide"){

            public final CommandArtifact doInvoke() {
                BHistoryEditor.this.setRecordsHidden(true);
                return null;
            }
        };
        this.unhideCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.unhide"){

            public final CommandArtifact doInvoke() {
                BHistoryEditor.this.setRecordsHidden(false);
                return null;
            }
        };
        this.editCmd.setEnabled(false);
        this.hideCmd.setEnabled(false);
        this.unhideCmd.setEnabled(false);
    }

    public void doLoadValue(BObject bObject, Context context) throws Exception {
        this.history = this.getHistory(bObject);
        this.tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)this.history.getConfig().getTimeZone()));
        this.tablePane.setTitle(this.history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        BFacets bFacets = BFacets.NULL;
        try {
            bFacets = (BFacets)this.history.getConfig().get("valueFacets");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BHistorySpace bHistorySpace = (BHistorySpace)this.history.getSpace();
        this.useBql = true;
        try {
            BOrd.make((BOrd)bHistorySpace.getAbsoluteOrd(), (String)"bql:").resolve();
        }
        catch (Exception exception) {
            this.useBql = false;
        }
        BDynamicTimeRange bDynamicTimeRange = this.getDefaultTimeRange();
        if (bDynamicTimeRange == BDynamicTimeRange.DEFAULT) {
            this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.make((BAbsTime)this.history.getFirstTimestamp(), (BAbsTime)BAbsTime.NULL), this.tzContext);
            int n = this.history.getRecordCount();
            BAbsTime bAbsTime = this.history.getFirstTimestamp();
            BAbsTime bAbsTime2 = this.history.getLastTimestamp();
            if (n > 500) {
                BAbsTime bAbsTime3 = Clock.time();
                if (bAbsTime3.dateEquals(bAbsTime2)) {
                    this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY, this.tzContext);
                } else {
                    BDynamicTimeRange bDynamicTimeRange2 = BDynamicTimeRange.make((BAbsTime)bAbsTime2.timeOfDay(0, 0, 0, 0), (BAbsTime)BAbsTime.NULL);
                    this.timeRangeEd.loadValue((BObject)bDynamicTimeRange2, this.tzContext);
                }
            }
        } else {
            this.timeRangeEd.loadValue((BObject)bDynamicTimeRange, this.tzContext);
        }
        BTrendRecord bTrendRecord = (BTrendRecord)this.history.getConfig().makeRecord();
        this.outliersCmd.setEnabled(bTrendRecord.getValueProperty().getType().is(BINumeric.TYPE));
        this.restoreState(this.toKey());
        this.query();
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BIHistory bIHistory = (BIHistory)bObject;
        HistoryEditorTableModel historyEditorTableModel = (HistoryEditorTableModel)this.table.getModel();
        int n = historyEditorTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            if (historyEditorTableModel.isModified(n2)) {
                bIHistory.update(historyEditorTableModel.getRecord(n2), context);
            }
            ++n2;
        }
        historyEditorTableModel.clearModified();
        return bObject;
    }

    public void changed(Property property, Context context) {
        if (property == showTimeRangeEditor) {
            this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        }
    }

    private final void editRecords() {
        int[] nArray = this.table.getSelection().getRows();
        if (nArray.length == 0) {
            return;
        }
        BTrendRecord bTrendRecord = null;
        boolean bl = false;
        BSimple bSimple = null;
        String string = null;
        BITable bITable = ((CollectionTableModel)this.table.getModel()).getBITable();
        BFacets bFacets = bITable.getColumns().get("value").getFacets();
        if (nArray.length == 1) {
            bTrendRecord = ((HistoryEditorTableModel)this.table.getModel()).getRecord(nArray[0]);
            string = lex.getText("historyEditor.editRecord");
        } else {
            bTrendRecord = (BTrendRecord)this.history.getConfig().makeRecord();
            string = lex.getText("historyEditor.editRecords");
        }
        bl = bTrendRecord.getTrendFlags().getBit(4);
        bSimple = (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty());
        BTrendRecordEditor bTrendRecordEditor = new BTrendRecordEditor(bl, bSimple, bFacets);
        int n = BDialog.open((BWidget)this, (String)string, (Object)new BBorderPane((BWidget)bTrendRecordEditor), (int)3);
        if (n == 2) {
            return;
        }
        boolean bl2 = false;
        try {
            HistoryEditorTableModel historyEditorTableModel = (HistoryEditorTableModel)this.table.getModel();
            bl2 = historyEditorTableModel.modifyRecords(nArray, bTrendRecordEditor.getHidden(), bTrendRecordEditor.getValue());
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)lex.getText("historyEditor.editError.title"), (Object)lex.getText("historyEditor.editError.msg"), (Throwable)exception);
            return;
        }
        if (bl2) {
            this.setModified();
        }
    }

    private final void setRecordsHidden(boolean bl) {
        int[] nArray = this.table.getSelection().getRows();
        if (nArray.length == 0) {
            return;
        }
        HistoryEditorTableModel historyEditorTableModel = (HistoryEditorTableModel)this.table.getModel();
        if (historyEditorTableModel.modifyRecords(nArray, BBoolean.make((boolean)bl), null)) {
            this.setModified();
        }
    }

    private final void updateTitle() {
        BIHistory bIHistory = this.getHistory(this.getCurrentValue());
        if (bIHistory == null) {
            this.tablePane.setTitle("");
            return;
        }
        String string = bIHistory.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX);
        if (this.filterSet != null && this.filterSet.anyActive()) {
            string = string + '*';
        }
        if (this.outlierParams.getEnabled()) {
            string = string + ' ' + lex.getText("historyEditor.withOutliers");
        }
        this.tablePane.setTitle(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doQuery() {
        block21: {
            Object object;
            Object object2;
            if (this.isModified()) {
                int n;
                object2 = lex.getText("confirmSubmit.title");
                int n2 = BDialog.confirm((BWidget)this, (String)object2, (Object)(object = lex.getText("confirmSubmit")), (int)(n = 14));
                if (n2 == 4) {
                    try {
                        this.saveValue(null);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new BajaRuntimeException((Throwable)exception);
                    }
                } else if (n2 == 2) {
                    return;
                }
            }
            if ((object2 = this.getShell()) != null) {
                object2.enterBusy();
            }
            this.table.getSelection().deselectAll();
            object = this.getHistory(this.getCurrentValue());
            BHistorySpace bHistorySpace = (BHistorySpace)object.getSpace();
            BHistoryId bHistoryId = object.getId();
            BITable bITable = null;
            BDynamicTimeRange bDynamicTimeRange = null;
            try {
                try {
                    bDynamicTimeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)exception);
                    throw new BajaRuntimeException((Throwable)exception);
                }
                BOrd bOrd = object.getOrdInSession();
                BOrd bOrd2 = BOrd.make((String)(bOrd.toString() + '?' + bDynamicTimeRange.toOrdParams()));
                if (this.useBql) {
                    String string;
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append(bOrd2.toString()).append('|');
                    stringBuffer.append("bql:select *");
                    StringBuffer stringBuffer2 = new StringBuffer(64);
                    if (this.filterSet != null && (string = this.filterSet.getPredicate()) != null && string.length() > 0) {
                        if (stringBuffer2.length() != 0) {
                            stringBuffer2.append(" and ");
                        }
                        stringBuffer2.append(string);
                    }
                    if (stringBuffer2.length() != 0) {
                        stringBuffer.append(" where ").append(stringBuffer2.toString());
                    }
                    string = BOrd.make((BOrd)object.getAbsoluteOrd(), (BOrd)BOrd.make((String)stringBuffer.toString())).normalize();
                    bITable = ((BICollection)string.resolve().get()).toTable();
                } else {
                    BOrd bOrd3 = BOrd.make((BOrd)object.getAbsoluteOrd(), (BOrd)bOrd2).normalize();
                    bITable = ((BICollection)bOrd3.resolve().get()).toTable();
                }
                ((HistoryEditorTableModel)this.table.getModel()).setCollection((BICollection)bITable);
                try {
                    this.saveValue(null);
                }
                catch (Exception exception) {}
                this.clearModified();
            }
            catch (Throwable throwable) {
                Object var8_19 = null;
                if (object2 != null) {
                    object2.exitBusy();
                }
                throw throwable;
            }
            {
                Object var8_20 = null;
                if (object2 == null) break block21;
            }
            object2.exitBusy();
        }
        this.updateTitle();
        this.tablePane.tableModified();
    }

    public void configOutliers() {
        if (this.outlierParams == null) {
            this.outlierParams = BHistoryEditor.getDefaultParams();
        }
        BOutlierParamsFE bOutlierParamsFE = new BOutlierParamsFE();
        bOutlierParamsFE.loadValue((BObject)this.outlierParams, this.tzContext);
        int n = BDialog.open((BWidget)this, (String)lex.getText("historyEditor.configOutliers.label"), (Object)((Object)bOutlierParamsFE), (int)3);
        if (n == 2) {
            return;
        }
        if (!bOutlierParamsFE.isModified()) {
            return;
        }
        try {
            this.outlierParams = (BOutlierParams)bOutlierParamsFE.saveValue();
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)lex.getText("historyEditor.configOutliers.error.title"), (Object)lex.getText("historyEditor.configOutliers.error.msg"), (Throwable)exception);
            return;
        }
        ((HistoryEditorTableModel)this.table.getModel()).setOutlierParams(this.outlierParams);
        this.updateTitle();
        this.updateCommandStates();
        this.table.repaint();
    }

    public void selectOutliers() {
        ((HistoryEditorTableModel)this.table.getModel()).selectOutliers();
    }

    public static BOutlierParams getDefaultParams() {
        if (options == null) {
            options = (BOutlierParams)BOptions.load((Type)BOutlierParams.TYPE);
        }
        return options;
    }

    protected BIHistory getHistory(BObject bObject) {
        if (bObject instanceof BIHistory) {
            return (BIHistory)bObject;
        }
        if (bObject instanceof BHistoryExt) {
            BHistoryExt bHistoryExt = (BHistoryExt)bObject;
            bHistoryExt.lease(1);
            BHistoryConfig bHistoryConfig = bHistoryExt.getHistoryConfig();
            BHistoryId bHistoryId = bHistoryConfig.getId();
            BOrd bOrd = bHistoryExt.getAbsoluteOrd();
            BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("history: " + (Object)((Object)bHistoryId)));
            return (BIHistory)bOrd2.resolve().get();
        }
        return null;
    }

    public void configFilters() {
        BITable bITable;
        if (this.table == null) {
            return;
        }
        if (this.filterSet == null) {
            bITable = ((CollectionTableModel)this.table.getModel()).getBITable();
            this.filterSet = this.buildFilterSet(bITable);
        }
        bITable = new BFilterSetDialog((BWidget)this, this.filterSet);
        bITable.setBoundsCenteredOnOwner();
        bITable.open();
        if (bITable.isCancelled()) {
            return;
        }
        if (!bITable.isModified()) {
            return;
        }
        this.filterSet = bITable.getResult();
        this.query();
    }

    private final BFilterSet buildFilterSet(BITable bITable) {
        ColumnList columnList = bITable.getColumns();
        int n = columnList.size();
        BFilterSet bFilterSet = new BFilterSet();
        int n2 = 0;
        while (n2 < n) {
            Type type = null;
            BFacets bFacets = null;
            try {
                AgentList agentList;
                String string;
                Column column = columnList.get(n2);
                bFacets = column.getFacets();
                if (bFacets != null && (string = bFacets.gets("origType", null)) != null) {
                    type = BTypeSpec.make((String)string).getResolvedType();
                }
                if (type == null) {
                    type = column.getType();
                }
                if ((string = type.getInstance()) instanceof BEnum && bFacets != null && bFacets.getFacet("range") != null) {
                    string = BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)bFacets.getFacet("range")));
                }
                if ((agentList = string.getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() != 0) {
                    BIBqlFilter bIBqlFilter = (BIBqlFilter)agentList.getDefault().getInstance();
                    bIBqlFilter.init((BObject)string);
                    BFilterEntry bFilterEntry = new BFilterEntry(false, column.getDisplayName(this.getCurrentContext()), bIBqlFilter);
                    bFilterSet.add(column.getName(), (BValue)bFilterEntry, 0, bFacets, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        try {
            bFilterSet.remove("timestamp");
        }
        catch (Exception exception) {}
        return bFilterSet;
    }

    public void doUpdateCommandStates() {
        boolean bl = this.table.getSelection().isEmpty();
        this.editCmd.setEnabled(bl ^ true);
        this.hideCmd.setEnabled(bl ^ true);
        this.unhideCmd.setEnabled(bl ^ true);
        this.selectOutliersCmd.setEnabled(this.outlierParams.getEnabled());
    }

    private final String toKey() {
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell == null) {
            return null;
        }
        OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
        if (ordTarget == null) {
            return null;
        }
        return "" + ordTarget.getOrdWithoutViewQuery();
    }

    public void activated() {
        this.restoreState(this.toKey());
    }

    public void deactivated() {
        this.saveState(this.toKey());
    }

    private final void saveState(String string) {
        try {
            State state = new State();
            state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            state.filterSet = this.filterSet == null ? null : (BFilterSet)this.filterSet.newCopy(true);
            state.outlierParams = this.outlierParams == null ? null : (BOutlierParams)this.outlierParams.newCopy(true);
            states.put(string, state);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void restoreState(String string) {
        if (string == null) {
            return;
        }
        State state = (State)states.get(string);
        if (state == null) {
            return;
        }
        this.timeRangeEd.loadValue((BObject)state.timeRange, this.tzContext);
        this.filterSet = state.filterSet;
        this.outlierParams = state.outlierParams;
        ((HistoryEditorTableModel)this.table.getModel()).setOutlierParams(this.outlierParams);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lexRecords = lex.getText("records");
        this.lastRowCount = 0;
        this.sizedToFit = false;
    }

    public BHistoryEditor() {
        this.this();
        this.initCommands();
        BEdgePane bEdgePane = new BEdgePane();
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        bEdgePane.setTop((BWidget)this.timeRangeEd);
        this.table = new BTable();
        this.table.setModel((TableModel)new HistoryEditorTableModel(null));
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new HistoryEditorCellRenderer());
        this.table.setMultipleSelection(true);
        this.tablePane = BTitlePane.makePane((String)"", (BTable)this.table, (String)this.lexRecords);
        bEdgePane.setCenter((BWidget)this.tablePane);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setRowAlign(BValign.fill);
        bGridPane.add(null, (BValue)new BButton(this.editCmd));
        bGridPane.add(null, (BValue)new BButton(this.selectOutliersCmd));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, (double)2, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
        this.linkTo("modLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
        this.linkTo("tableSelection", (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommandStates);
        this.outlierParams = BHistoryEditor.getDefaultParams();
        ((HistoryEditorTableModel)this.table.getModel()).setOutlierParams(this.outlierParams);
    }

    static {
        Class clazz = class$com$tridium$history$ui$BHistoryEditor;
        if (clazz == null) {
            clazz = class$com$tridium$history$ui$BHistoryEditor = BHistoryEditor.class("[Lcom.tridium.history.ui.BHistoryEditor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"history");
        states = new HashMap();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EditCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BHistoryEditor.this.editRecords();
            return null;
        }

        public EditCommand() {
            super((BWidget)BHistoryEditor.this, lex.module, "historyEditor.editRecords");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class State {
        BDynamicTimeRange timeRange;
        BFilterSet filterSet;
        BOutlierParams outlierParams;

        private State() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TableController {
        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add("hide", BHistoryEditor.this.hideCmd);
            bMenu.add("unhide", BHistoryEditor.this.unhideCmd);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add("edit", BHistoryEditor.this.editCmd);
            bMenu.add("selectOutliers", BHistoryEditor.this.selectOutliersCmd);
            bMenu.open((BWidget)BHistoryEditor.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BHistoryEditor.this.editRecords();
        }

        protected void handleEnter(BKeyEvent bKeyEvent) {
            BHistoryEditor.this.editRecords();
        }

        Controller() {
        }
    }
}

