/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.BHistoryFolder;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistorySpace;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryChooser
extends BWidget {
    public static final Action updateCommands = BHistoryChooser.newAction((int)4, null);
    public static final Topic selectionModified = BHistoryChooser.newTopic((int)0, null);
    public static final Type TYPE;
    private BHistorySpace historySpace;
    private BNavTree tree;
    private BScrollPane treePane;
    private BPane buttonPane;
    private BList list;
    private Command addCmd;
    private Command removeCmd;
    private Command clearCmd;
    static /* synthetic */ Class class$com$tridium$history$ui$BHistoryChooser;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setHistorySpace(BHistorySpace bHistorySpace) {
        this.historySpace = bHistorySpace;
        this.tree = this.makeTree(bHistorySpace);
        this.treePane.setContent((BWidget)this.tree);
        this.treePane.relayout();
        int n = 0;
        n = bHistorySpace.listDevices().length;
        if (n < 2) {
            this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
        }
        this.tree.relayout();
    }

    private final BNavTree makeTree(BHistorySpace bHistorySpace) {
        BNavTree bNavTree = new BNavTree((BINavNode)bHistorySpace);
        bNavTree.setMultipleSelection(true);
        bNavTree.setController((TreeController)new HistoryTreeController());
        return bNavTree;
    }

    public int getResultSize() {
        return this.list.getItemCount();
    }

    public void setSelection(BOrd[] bOrdArray) {
        this.list.removeAllItems();
        int n = 0;
        while (n < bOrdArray.length) {
            BINavNode bINavNode = (BINavNode)bOrdArray[n].get();
            this.list.addItem((Object)new Item(bINavNode));
            ++n;
        }
    }

    public BOrd[] getResult() {
        int n = this.list.getItemCount();
        BOrd[] bOrdArray = new BOrd[n];
        int n2 = 0;
        while (n2 < n) {
            bOrdArray[n2] = ((Item)this.list.getItem(n2)).getOrd();
            ++n2;
        }
        return bOrdArray;
    }

    public void computePreferredSize() {
        this.treePane.computePreferredSize();
        this.buttonPane.computePreferredSize();
        this.list.computePreferredSize();
        double d = this.buttonPane.getPreferredWidth();
        double d2 = this.list.getPreferredWidth();
        double d3 = Math.max(this.buttonPane.getPreferredHeight(), 200.0);
        this.setPreferredSize(d += Math.max(d2, 200.0) * (double)2, d3);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.buttonPane.computePreferredSize();
        double d = (this.getWidth() - this.buttonPane.getPreferredWidth()) / (double)2;
        this.treePane.setBounds(0.0, 0.0, d, this.getHeight());
        this.buttonPane.setBounds(d, (this.getHeight() - this.buttonPane.getPreferredHeight()) / (double)2, this.buttonPane.getPreferredWidth(), this.buttonPane.getPreferredHeight());
        double d2 = d + this.buttonPane.getPreferredWidth();
        this.list.setBounds(d2, 0.0, this.getWidth() - d2, this.getHeight());
    }

    public void add() {
        TreeNode[] treeNodeArray = this.tree.getSelection().getNodes();
        if (treeNodeArray == null || treeNodeArray.length == 0) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < treeNodeArray.length) {
            NavTreeNode navTreeNode = (NavTreeNode)treeNodeArray[n];
            BINavNode bINavNode = navTreeNode.getNavNode();
            if (!bINavNode.getNavName().equalsIgnoreCase("history:///")) {
                Item item = new Item(bINavNode);
                boolean bl2 = false;
                if (this.list.indexOfItem((Object)item) != -1) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                boolean bl4 = false;
                BINavNode bINavNode2 = bINavNode.getNavParent();
                while (bINavNode2 instanceof BISpaceNode) {
                    Item item2 = new Item(bINavNode2);
                    if (this.list.indexOfItem((Object)item2) != -1) {
                        bl4 = true;
                        break;
                    }
                    bINavNode2 = bINavNode2.getNavParent();
                }
                if (bINavNode instanceof BHistoryDevice) {
                    int n2 = this.list.getItemCount();
                    int n3 = n2 - 1;
                    while (n3 >= 0) {
                        BINavNode bINavNode3 = ((Item)this.list.getItem((int)n3)).node;
                        if (bINavNode3.getNavParent().getNavOrd().equals((Object)bINavNode.getNavOrd())) {
                            this.list.removeItem(n3);
                        }
                        --n3;
                    }
                } else if (bINavNode instanceof BHistoryFolder) {
                    int n4 = this.list.getItemCount();
                    String string = bINavNode.getNavOrd().toString() + '/';
                    int n5 = string.length();
                    int n6 = n4 - 1;
                    while (n6 >= 0) {
                        BINavNode bINavNode4 = ((Item)this.list.getItem((int)n6)).node;
                        String string2 = bINavNode4.getNavOrd().toString();
                        if (string2.length() > n5 && string2.startsWith(string)) {
                            this.list.removeItem(n6);
                        }
                        --n6;
                    }
                }
                if (!bl3 && !bl4) {
                    this.list.addItem((Object)item);
                    bl = true;
                }
                if (bl) {
                    this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
                }
            }
            ++n;
        }
    }

    public void remove() {
        this.list.removeSelectedItems();
        this.list.getSelection().deselectAll();
        this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
    }

    public void clear() {
        this.list.removeAllItems();
        this.list.getSelection().deselectAll();
        this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
    }

    public void doUpdateCommands() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BHistoryChooser() {
        this(null);
    }

    public BHistoryChooser(BHistorySpace bHistorySpace) {
        this.historySpace = bHistorySpace;
        if (bHistorySpace != null) {
            this.tree = this.makeTree(bHistorySpace);
        }
        this.treePane = this.tree != null ? new BTreePane((BTree)this.tree) : new BTreePane();
        this.add("tree", (BValue)this.treePane);
        this.addCmd = new AddCommand(this);
        this.removeCmd = new RemoveCommand(this);
        this.clearCmd = new ClearCommand(this);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add("add", (BValue)new BButton(this.addCmd));
        bGridPane.add("remove", (BValue)new BButton(this.removeCmd));
        bGridPane.add("clear", (BValue)new BButton(this.clearCmd));
        this.buttonPane = new BBorderPane((BWidget)bGridPane, (double)4, (double)4, (double)4, (double)4);
        this.add("buttons", (BValue)this.buttonPane);
        this.list = new BList();
        this.add("list", (BValue)this.list);
        if (bHistorySpace != null) {
            int n = 0;
            try {
                n = bHistorySpace.listDevices().length;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n < 2) {
                this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
            }
            this.tree.relayout();
        }
    }

    static {
        Class clazz = class$com$tridium$history$ui$BHistoryChooser;
        if (clazz == null) {
            clazz = class$com$tridium$history$ui$BHistoryChooser = BHistoryChooser.class("[Lcom.tridium.history.ui.BHistoryChooser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HistoryTreeController
    extends TreeController {
        public void doSelectAction(TreeNode treeNode, double d, double d2) {
            BHistoryChooser.this.add();
        }

        private HistoryTreeController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Item {
        BINavNode node;
        String display;

        public BOrd getOrd() {
            return ((BISpaceNode)this.node).getOrdInSpace();
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                return ((Item)object).display.equals(this.display);
            }
            return false;
        }

        public String toString() {
            return this.display;
        }

        public Item(BINavNode bINavNode) {
            this.node = bINavNode;
            this.display = ((BISpaceNode)bINavNode).getOrdInSpace().parse()[0].getBody();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AddCommand
    extends Command {
        final /* synthetic */ BHistoryChooser this;

        public CommandArtifact doInvoke() {
            this.this.add();
            return null;
        }

        public AddCommand(BHistoryChooser bHistoryChooser) {
            Class clazz = class$com$tridium$history$ui$BHistoryChooser;
            if (clazz == null) {
                clazz = class$com$tridium$history$ui$BHistoryChooser = BHistoryChooser.class("[Lcom.tridium.history.ui.BHistoryChooser;", false);
            }
            super((BWidget)bHistoryChooser, Sys.getModuleForClass((Class)clazz), "chooser.add");
            this.this = bHistoryChooser;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RemoveCommand
    extends Command {
        final /* synthetic */ BHistoryChooser this;

        public CommandArtifact doInvoke() {
            this.this.remove();
            return null;
        }

        public RemoveCommand(BHistoryChooser bHistoryChooser) {
            Class clazz = class$com$tridium$history$ui$BHistoryChooser;
            if (clazz == null) {
                clazz = class$com$tridium$history$ui$BHistoryChooser = BHistoryChooser.class("[Lcom.tridium.history.ui.BHistoryChooser;", false);
            }
            super((BWidget)bHistoryChooser, Sys.getModuleForClass((Class)clazz), "chooser.remove");
            this.this = bHistoryChooser;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ClearCommand
    extends Command {
        final /* synthetic */ BHistoryChooser this;

        public CommandArtifact doInvoke() {
            this.this.clear();
            return null;
        }

        public ClearCommand(BHistoryChooser bHistoryChooser) {
            Class clazz = class$com$tridium$history$ui$BHistoryChooser;
            if (clazz == null) {
                clazz = class$com$tridium$history$ui$BHistoryChooser = BHistoryChooser.class("[Lcom.tridium.history.ui.BHistoryChooser;", false);
            }
            super((BWidget)bHistoryChooser, Sys.getModuleForClass((Class)clazz), "chooser.clear");
            this.this = bHistoryChooser;
        }
    }
}

