/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.BHistoryMirror;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.nav.BNavContainerView;
import java.util.Comparator;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDeviceHistoriesView
extends BNavContainerView
implements NavListener {
    public static final Type TYPE;
    private static Lexicon lex;
    private static final Comparator histNameComparator;
    private static final BTypeSpec DEVICE_TYPE;
    String historyDeviceName;
    BHistorySpace space;
    Work work;
    static /* synthetic */ Class class$com$tridium$history$ui$BDeviceHistoriesView;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BWidget bWidget;
        this.space = BDeviceHistoriesView.getHistorySpace(bObject);
        super.doLoadValue(bObject, context);
        if (this.space != null) {
            this.space.fw(9903, (Object)this, null, null, null);
        }
        if ((bWidget = this.getContent()) instanceof BTitlePane) {
            if (this.historyDeviceName == null) {
                ((BTitlePane)bWidget).setTitle(lex.getText("deviceHistoriesView.title.unknown"));
            } else {
                ((BTitlePane)bWidget).setTitle(lex.getText("deviceHistoriesView.title", (Object[])new String[]{this.historyDeviceName}));
            }
        }
    }

    public void deactivated() {
        if (this.space != null) {
            this.space.fw(9903, (Object)this, BBoolean.TRUE, null, null);
        }
    }

    public void stopped() {
        if (this.space != null) {
            this.space.fw(9903, (Object)this, BBoolean.TRUE, null, null);
        }
    }

    protected BTable makeNavTable(BINavNode bINavNode) {
        this.historyDeviceName = BDeviceHistoriesView.getHistoryDeviceName((BValue)bINavNode, this.space);
        BINavNode[] bINavNodeArray = null;
        if (this.historyDeviceName != null && this.space != null && this.space.deviceExists(this.historyDeviceName)) {
            BHistoryDevice bHistoryDevice = this.space.getDevice(this.historyDeviceName);
            Object[] objectArray = this.space.listHistories(bHistoryDevice);
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)histNameComparator);
            int n = objectArray.length;
            bINavNodeArray = new BINavNode[n];
            int n2 = 0;
            while (n2 < n) {
                bINavNodeArray[n2] = new BHistoryMirror((BIHistory)objectArray[n2], bINavNode, true);
                ++n2;
            }
        } else {
            bINavNodeArray = new BINavNode[]{};
        }
        this.rows = new BNavContainerView.Row[bINavNodeArray.length];
        int n = 0;
        while (n < bINavNodeArray.length) {
            this.rows[n] = new BNavContainerView.Row(bINavNodeArray[n]);
            ++n;
        }
        return new BTable((TableModel)new BNavContainerView.Model((BNavContainerView)this), (TableController)new BNavContainerView.Controller((BNavContainerView)this));
    }

    static String getHistoryDeviceName(BValue bValue, BHistorySpace bHistorySpace) {
        Type type = DEVICE_TYPE.getResolvedType();
        String string = null;
        if (bValue instanceof BComplex) {
            BValue bValue2;
            BComplex bComplex = (BComplex)bValue;
            while (bComplex != null) {
                if (bComplex.getType().is(type)) {
                    string = bComplex.getName();
                    break;
                }
                bComplex = bComplex.getParent();
            }
            if ((string == null || bHistorySpace != null && !bHistorySpace.deviceExists(string)) && (bValue2 = ((BComplex)bValue).get("historyDeviceName")) instanceof BString && !bValue2.equals((Object)BString.DEFAULT)) {
                string = bValue2.toString();
            }
        }
        return string;
    }

    static BHistorySpace getHistorySpace(BObject bObject) {
        try {
            BOrd bOrd = BOrd.make((String)"history:");
            return (BHistorySpace)bOrd.get(bObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void navEvent(NavEvent navEvent) {
        BOrd bOrd = navEvent.getParentOrd();
        OrdQuery[] ordQueryArray = bOrd.parse();
        OrdQuery ordQuery = ordQueryArray[ordQueryArray.length - 1];
        if (!(ordQuery instanceof HistoryQuery)) {
            return;
        }
        HistoryQuery historyQuery = (HistoryQuery)ordQuery;
        if (!historyQuery.isDeviceQuery()) {
            return;
        }
        String string = historyQuery.getDeviceName();
        if (this.historyDeviceName != null && !this.historyDeviceName.equals(string)) {
            return;
        }
        if (this.work == null) {
            this.work = new Work(this);
        }
        UiEnv.get().invokeLater((Runnable)this.work);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.work = null;
    }

    public BDeviceHistoriesView() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$history$ui$BDeviceHistoriesView;
        if (clazz == null) {
            clazz = class$com$tridium$history$ui$BDeviceHistoriesView = BDeviceHistoriesView.class("[Lcom.tridium.history.ui.BDeviceHistoriesView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"history");
        histNameComparator = new HistoryNameComparator();
        DEVICE_TYPE = BTypeSpec.make((String)"driver:Device");
    }

    static class Work
    implements Runnable {
        BDeviceHistoriesView view;

        public void run() {
            try {
                this.view.makeNavTable((BINavNode)this.view.getCurrentValue());
                this.view.relayout();
            }
            catch (Exception exception) {}
        }

        public Work(BDeviceHistoriesView bDeviceHistoriesView) {
            this.view = bDeviceHistoriesView;
        }
    }

    private static class HistoryNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((BIHistory)object).getNavDisplayName(null).compareTo(((BIHistory)object2).getNavDisplayName(null));
        }

        public boolean equals(Object object) {
            return object instanceof HistoryNameComparator;
        }

        private HistoryNameComparator() {
        }
    }
}

