/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.rollup.RollupValue;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RollupCursor
implements Cursor {
    private static final BRelTime NONE = BRelTime.make((long)0L);
    private static final BRelTime ONE_MIN = BRelTime.make((long)60000L);
    private static final BRelTime FIVE_MIN = BRelTime.make((long)300000L);
    private static final BRelTime FIFTEEN_MIN = BRelTime.make((long)900000L);
    private static final BRelTime THIRTY_MIN = BRelTime.make((long)1800000L);
    private static final BRelTime HOURLY = BRelTime.make((long)3600000L);
    private RollupValue rollupVal;
    private BICollection collection;
    private BAbsTime startTime;
    private BAbsTime endTime;
    private BRelTime rollupTimeOffset;
    private BRollupInterval rollupInterval;
    private Cursor c;
    private BHistoryRecord currentRecord;
    private BAbsTime incrementStart;
    private BAbsTime incrementEnd;
    private BHistoryRecord lastRecord;
    private BAbsTime newTimestamp;
    private boolean skipLastIteration;

    public Context getContext() {
        return null;
    }

    public boolean nextComponent() {
        return false;
    }

    public boolean next(Class clazz) {
        if (clazz.isAssignableFrom(this.currentRecord.getClass())) {
            return this.next();
        }
        return false;
    }

    public boolean next() {
        if (this.startTime == null || this.endTime == null || this.startTime.isAfter(this.endTime)) {
            return false;
        }
        if (this.rollupInterval == BRollupInterval.none) {
            while (this.c.next()) {
                if (!(this.c.get() instanceof BHistoryRecord)) continue;
                BAbsTime bAbsTime = ((BHistoryRecord)this.c.get()).getTimestamp();
                this.rollupVal.reset();
                this.rollupVal.addElement((BHistoryRecord)this.c.get());
                this.currentRecord = this.rollupVal.getValue(bAbsTime, bAbsTime);
                return true;
            }
            return false;
        }
        boolean bl = true;
        if (this.incrementEnd.isAfter(this.endTime) && !this.skipLastIteration) {
            BAbsTime bAbsTime;
            bl = true;
            if (this.lastRecord != null) {
                bAbsTime = this.lastRecord.getTimestamp();
                if (bAbsTime.isAfter(this.endTime)) {
                    bl = false;
                } else if (bAbsTime.isAfter(this.incrementStart) && !bAbsTime.equals((Object)this.newTimestamp)) {
                    this.rollupVal.addElement(this.lastRecord);
                    this.lastRecord = null;
                } else {
                    this.lastRecord = null;
                }
            }
            if (bl) {
                while (this.c.next()) {
                    if (!(this.c.get() instanceof BHistoryRecord)) continue;
                    bAbsTime = ((BHistoryRecord)this.c.get()).getTimestamp();
                    if (bAbsTime.isAfter(this.endTime)) {
                        this.lastRecord = (BHistoryRecord)this.c.get();
                        break;
                    }
                    if (bAbsTime.isAfter(this.incrementStart) && !bAbsTime.equals((Object)this.newTimestamp)) {
                        this.rollupVal.addElement((BHistoryRecord)this.c.get());
                        continue;
                    }
                    this.lastRecord = null;
                }
            }
            this.newTimestamp = BAbsTime.make((long)this.endTime.getMillis(), (BTimeZone)this.endTime.getTimeZone());
            this.currentRecord = this.rollupVal.getValue(this.incrementStart, this.newTimestamp);
            this.rollupVal.reset();
            this.skipLastIteration = true;
            return true;
        }
        if (!this.incrementEnd.isAfter(this.endTime)) {
            BAbsTime bAbsTime;
            bl = true;
            if (this.lastRecord != null) {
                bAbsTime = this.lastRecord.getTimestamp();
                if (bAbsTime.isAfter(this.incrementEnd)) {
                    bl = false;
                } else if (bAbsTime.isAfter(this.incrementStart) && !bAbsTime.equals((Object)this.newTimestamp)) {
                    this.rollupVal.addElement(this.lastRecord);
                    this.lastRecord = null;
                } else {
                    this.lastRecord = null;
                }
            }
            if (bl) {
                while (this.c.next()) {
                    if (!(this.c.get() instanceof BHistoryRecord)) continue;
                    bAbsTime = ((BHistoryRecord)this.c.get()).getTimestamp();
                    if (bAbsTime.isAfter(this.incrementEnd)) {
                        this.lastRecord = (BHistoryRecord)this.c.get();
                        break;
                    }
                    if (bAbsTime.isAfter(this.incrementStart) && !bAbsTime.equals((Object)this.newTimestamp)) {
                        this.rollupVal.addElement((BHistoryRecord)this.c.get());
                        continue;
                    }
                    this.lastRecord = null;
                }
            }
            this.newTimestamp = BAbsTime.make((long)this.incrementEnd.getMillis(), (BTimeZone)this.incrementEnd.getTimeZone());
            this.currentRecord = this.rollupVal.getValue(this.incrementStart, this.newTimestamp);
            this.rollupVal.reset();
            this.skipLastIteration = this.incrementEnd.equals((Object)this.endTime);
            this.incrementTimeIntervals();
            return true;
        }
        return false;
    }

    public BObject get() {
        return this.currentRecord;
    }

    private final void incrementTimeIntervals() {
        if (this.rollupInterval == null) {
            this.incrementStart = this.incrementStart.add(this.rollupTimeOffset);
            this.incrementEnd = this.incrementEnd.add(this.rollupTimeOffset);
            return;
        }
        this.incrementStart = this.incrementEnd;
        if (this.rollupInterval == BRollupInterval.none) {
            return;
        }
        if (this.rollupInterval == BRollupInterval.oneMin) {
            this.incrementEnd = this.incrementStart.add(ONE_MIN);
        } else if (this.rollupInterval == BRollupInterval.fiveMin) {
            this.incrementEnd = this.incrementStart.add(FIVE_MIN);
        } else if (this.rollupInterval == BRollupInterval.fifteenMin) {
            this.incrementEnd = this.incrementStart.add(FIFTEEN_MIN);
        } else if (this.rollupInterval == BRollupInterval.thirtyMin) {
            this.incrementEnd = this.incrementStart.add(THIRTY_MIN);
        } else if (this.rollupInterval == BRollupInterval.hourly) {
            this.incrementEnd = this.incrementStart.add(HOURLY);
        } else if (this.rollupInterval == BRollupInterval.yearly) {
            this.incrementEnd = this.incrementStart.nextYear();
        } else if (this.rollupInterval == BRollupInterval.monthly) {
            this.incrementEnd = this.incrementStart.nextMonth();
        } else if (this.rollupInterval == BRollupInterval.daily) {
            this.incrementEnd = this.incrementStart.nextDay();
        }
    }

    private final /* synthetic */ void this() {
        this.startTime = null;
        this.endTime = null;
        this.rollupTimeOffset = null;
        this.rollupInterval = null;
        this.incrementStart = null;
        this.incrementEnd = null;
        this.lastRecord = null;
        this.newTimestamp = null;
        this.skipLastIteration = true;
    }

    public RollupCursor(RollupValue rollupValue, BICollection bICollection, BRollupInterval bRollupInterval) {
        this(rollupValue, bICollection, BRelTime.DEFAULT);
        this.rollupInterval = bRollupInterval;
        this.incrementTimeIntervals();
        if (this.endTime != null && !this.endTime.isNull() && this.incrementEnd != null && this.incrementEnd.isAfter(this.endTime)) {
            this.incrementEnd = (BAbsTime)this.endTime.newCopy();
        }
    }

    public RollupCursor(RollupValue rollupValue, BICollection bICollection, BRelTime bRelTime) {
        BFacets bFacets;
        this.this();
        this.rollupVal = rollupValue;
        this.collection = bICollection;
        this.rollupTimeOffset = bRelTime;
        BTimeZone bTimeZone = null;
        if (bICollection instanceof BITable) {
            bFacets = ((BITable)bICollection).getTableFacets();
            bTimeZone = (BTimeZone)bFacets.get("TimeZone", null);
            this.startTime = (BAbsTime)bFacets.get("startTime", (BObject)BAbsTime.NULL);
            this.endTime = (BAbsTime)bFacets.get("endTime", (BObject)BAbsTime.NULL);
            if (this.startTime.isNull()) {
                this.startTime = (BAbsTime)bFacets.get("firstTimestamp", (BObject)BAbsTime.NULL);
            }
            if (this.endTime.isNull()) {
                this.endTime = (BAbsTime)bFacets.get("lastTimestamp", (BObject)BAbsTime.NULL);
            }
        }
        this.c = bICollection.cursor();
        if (this.startTime.isNull() || this.endTime.isNull()) {
            while (this.c.next()) {
                if (!(this.c.get() instanceof BHistoryRecord)) continue;
                bFacets = ((BHistoryRecord)this.c.get()).getTimestamp();
                if (this.startTime.isNull()) {
                    this.startTime = bFacets;
                    if (!this.endTime.isNull()) break;
                }
                this.endTime = bFacets;
            }
            this.c = bICollection.cursor();
        }
        if (!this.startTime.isNull() && !this.endTime.isNull()) {
            this.incrementStart = (BAbsTime)this.startTime.newCopy();
            this.incrementEnd = this.incrementStart.add(bRelTime);
            if (this.incrementEnd.isAfter(this.endTime)) {
                this.incrementEnd = (BAbsTime)this.endTime.newCopy();
            }
            this.newTimestamp = this.incrementStart.subtract(bRelTime);
        }
        if (bTimeZone != null) {
            if (this.startTime != null && !this.startTime.isNull()) {
                this.startTime = BAbsTime.make((long)this.startTime.getMillis(), (BTimeZone)bTimeZone);
            }
            if (this.endTime != null && !this.endTime.isNull()) {
                this.endTime = BAbsTime.make((long)this.endTime.getMillis(), (BTimeZone)bTimeZone);
            }
            if (this.incrementStart != null && !this.incrementStart.isNull()) {
                this.incrementStart = BAbsTime.make((long)this.incrementStart.getMillis(), (BTimeZone)bTimeZone);
            }
            if (this.incrementEnd != null && !this.incrementEnd.isNull()) {
                this.incrementEnd = BAbsTime.make((long)this.incrementEnd.getMillis(), (BTimeZone)bTimeZone);
            }
            if (this.newTimestamp != null && !this.newTimestamp.isNull()) {
                this.newTimestamp = BAbsTime.make((long)this.newTimestamp.getMillis(), (BTimeZone)bTimeZone);
            }
        }
    }
}

