/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.HistoryTableCursor;
import com.tridium.history.collection.PropertyColumn;
import com.tridium.history.rollup.BHistoryRollupRecord;
import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.rollup.CollectiveRollupValue;
import com.tridium.history.rollup.HistoryRollupColumns;
import com.tridium.history.rollup.RollupCursor;
import com.tridium.history.rollup.RollupValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.baja.collection.BICollection;
import javax.baja.collection.BIList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.history.BHistoryRecord;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryRollup
extends BObject
implements BITable {
    public static final Type TYPE;
    private BITable table;
    private BRelTime rollupRelTimeInterval;
    private BRollupInterval rollupDefInterval;
    private ArrayList list;
    private ColumnList columns;
    private IFilter filter;
    private BFacets tableFacets;
    static /* synthetic */ Class class$com$tridium$history$rollup$BHistoryRollup;

    public Type getType() {
        return TYPE;
    }

    public static BITable rollup(BITable bITable, BRelTime bRelTime) {
        return BHistoryRollup.rollup(null, bITable, bRelTime);
    }

    public static BITable rollup(OrdTarget ordTarget, BITable bITable, BRelTime bRelTime) {
        if (bITable != null && bRelTime != null) {
            return new BHistoryRollup(bITable, bRelTime);
        }
        return null;
    }

    public static BITable rollup(OrdTarget ordTarget, BITable bITable, BRollupInterval bRollupInterval) {
        if (bITable != null && bRollupInterval != null) {
            return new BHistoryRollup(bITable, bRollupInterval);
        }
        return null;
    }

    public static BITable rollup(OrdTarget ordTarget, BRelTime bRelTime) {
        if (bRelTime == null) {
            return null;
        }
        BObject bObject = ordTarget.get();
        if (bObject instanceof BITable) {
            return BHistoryRollup.rollup(ordTarget, (BITable)bObject, bRelTime);
        }
        return null;
    }

    public static BITable rollup(OrdTarget ordTarget, BRollupInterval bRollupInterval) {
        if (bRollupInterval == null || ordTarget == null) {
            return null;
        }
        BObject bObject = ordTarget.get();
        if (bObject instanceof BITable) {
            return BHistoryRollup.rollup(ordTarget, (BITable)bObject, bRollupInterval);
        }
        return null;
    }

    public Cursor cursor() {
        RollupCursor rollupCursor = null;
        rollupCursor = this.rollupDefInterval != null ? new RollupCursor((RollupValue)new CollectiveRollupValue(), (BICollection)this.table, this.rollupDefInterval) : new RollupCursor((RollupValue)new CollectiveRollupValue(), (BICollection)this.table, this.rollupRelTimeInterval);
        return new HistoryTableCursor(this, rollupCursor, (javax.baja.nre.util.IFilter)this.filter);
    }

    public BICollection filter(IFilter iFilter) {
        return new BHistoryRollup(this.table, this.rollupRelTimeInterval, iFilter);
    }

    public BIList toList() {
        return this;
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    public BObject get(int n) {
        this.load();
        return (BObject)this.list.get(n);
    }

    public BObject[] list() {
        this.load();
        Class clazz = BHistoryRollupRecord.TYPE.getTypeClass();
        return (BObject[])this.list.toArray((Object[])Array.newInstance(clazz, this.list.size()));
    }

    public BObject[] list(BObject[] bObjectArray) {
        this.load();
        return this.list.toArray(bObjectArray);
    }

    public BITable toTable() {
        return this;
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryRollupColumns.getColumns(this.table);
        }
        return this.columns;
    }

    public BObject get(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).get((BObject)this.list.get(n));
    }

    public String getString(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getString((BObject)this.list.get(n));
    }

    public double getDouble(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getDouble((BObject)this.list.get(n));
    }

    public float getFloat(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getFloat((BObject)this.list.get(n));
    }

    public int getInt(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getInt((BObject)this.list.get(n));
    }

    public long getLong(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getLong((BObject)this.list.get(n));
    }

    public boolean getBoolean(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getBoolean((BObject)this.list.get(n));
    }

    public int getFlags(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getFlags((BObject)this.list.get(n));
    }

    public BFacets getFacets(int n, Column column) {
        this.load();
        return ((PropertyColumn)column).getFacets((BObject)this.list.get(n));
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    private final synchronized void load() {
        if (this.list != null) {
            return;
        }
        Cursor cursor = this.cursor();
        this.list = new ArrayList(128);
        while (cursor.next()) {
            BHistoryRecord bHistoryRecord = (BHistoryRecord)cursor.get();
            if (this.filter != null && !this.filter.accept((Object)bHistoryRecord)) continue;
            this.list.add(bHistoryRecord.newCopy(true));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BHistoryRollup(BITable bITable, BRelTime bRelTime) {
        this(bITable, bRelTime, null);
    }

    private BHistoryRollup(BITable bITable, BRollupInterval bRollupInterval) {
        this(bITable, bRollupInterval, null);
    }

    private BHistoryRollup(BITable bITable, BRelTime bRelTime, IFilter iFilter) {
        this.table = bITable;
        this.rollupRelTimeInterval = bRelTime;
        this.filter = iFilter;
        this.tableFacets = bITable.getTableFacets();
    }

    private BHistoryRollup(BITable bITable, BRollupInterval bRollupInterval, IFilter iFilter) {
        this.table = bITable;
        this.rollupRelTimeInterval = BRelTime.DEFAULT;
        this.filter = iFilter;
        this.tableFacets = bITable.getTableFacets();
        this.rollupDefInterval = bRollupInterval;
    }

    static {
        Class clazz = class$com$tridium$history$rollup$BHistoryRollup;
        if (clazz == null) {
            clazz = class$com$tridium$history$rollup$BHistoryRollup = BHistoryRollup.class("[Lcom.tridium.history.rollup.BHistoryRollup;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

