/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.pdf.BHistoryTableToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.PdfUtil;
import javax.baja.gx.BFont;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPdfHistoryChart
extends BPdfFlowPane {
    public static final Type TYPE;
    private static Lexicon lex;
    static /* synthetic */ Class class$com$tridium$history$pdf$BPdfHistoryChart;

    public Type getType() {
        return TYPE;
    }

    public void fromWidget(BWidget bWidget, PdfOp pdfOp) {
        BDynamicTimeRange bDynamicTimeRange;
        if (!(bWidget instanceof BHistoryChart)) {
            return;
        }
        BHistoryChart bHistoryChart = (BHistoryChart)bWidget;
        try {
            bDynamicTimeRange = bHistoryChart.getRange();
        }
        catch (Exception exception) {
            PdfUtil.log.error(exception.getMessage(), (Throwable)exception);
            return;
        }
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = bDynamicTimeRange.getStartTime(bAbsTime);
        BAbsTime bAbsTime3 = bDynamicTimeRange.getEndTime(bAbsTime);
        boolean bl = bHistoryChart.isDelta();
        if (bAbsTime2 == null || bAbsTime2.isNull()) {
            bAbsTime2 = bHistoryChart.getHistory().getFirstTimestamp();
        }
        if (bAbsTime3 == null || bAbsTime3.isNull()) {
            bAbsTime3 = bHistoryChart.getHistory().getLastTimestamp();
        }
        bDynamicTimeRange = BDynamicTimeRange.make((BAbsTime)bAbsTime2, (BAbsTime)bAbsTime3);
        BHistoryChart bHistoryChart2 = new BHistoryChart();
        bHistoryChart2.setDefaultTimeRange(bDynamicTimeRange);
        bHistoryChart2.setDefaultDelta(bl);
        bHistoryChart2.loadValue((BObject)bHistoryChart.getHistory(), (Context)pdfOp);
        try {
            while (!bHistoryChart2.isReady()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            PdfUtil.log.error(interruptedException.getMessage(), (Throwable)interruptedException);
        }
        boolean bl2 = false;
        if (pdfOp != null) {
            bl2 = pdfOp.getBaseOrdTarget().get() instanceof BHistoryChart;
        }
        if (bl2) {
            BLabel bLabel = new BLabel("history:" + bHistoryChart.getHistory().getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
            BLabel bLabel2 = new BLabel(BHistoryTableToPdf.getRangeStr(bDynamicTimeRange, (Context)pdfOp));
            bLabel.setFont(BFont.make((String)lex.getText("pdf.propertySheetToPdf.font")));
            bLabel.setHalign(BHalign.left);
            bLabel2.setHalign(BHalign.left);
            this.add(null, (BValue)bLabel);
            this.add(null, (BValue)bLabel2);
            this.add(null, (BValue)new BLabel(""));
        }
        this.add(null, (BValue)bHistoryChart2.popChartPane());
        this.setupPane();
        if (!bl2) {
            this.setLayout(bWidget.getLayout());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$history$pdf$BPdfHistoryChart;
        if (clazz == null) {
            clazz = class$com$tridium$history$pdf$BPdfHistoryChart = BPdfHistoryChart.class("[Lcom.tridium.history.pdf.BPdfHistoryChart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"pdf");
    }
}

