/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.pdf.BHistoryTableToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import javax.baja.gx.BFont;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAbstractHistoryChartToPdf
extends BPdfExporter {
    public static final Type TYPE;
    private static Lexicon lex;
    static /* synthetic */ Class class$com$tridium$history$pdf$BAbstractHistoryChartToPdf;

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp pdfOp) throws Exception {
        PdfDocument pdfDocument = new PdfDocument(pdfOp.getOutputStream(), pdfOp.getWidth(), pdfOp.getHeight());
        BHistoryChart bHistoryChart = this.getHistoryChart(pdfOp);
        BWidgetToPdf bWidgetToPdf = new BWidgetToPdf();
        bWidgetToPdf.renderDocument((BWidget)bHistoryChart, pdfDocument, pdfOp);
    }

    public static BPdfFlowPane createPdfComposite(PdfOp pdfOp, BHistoryChart bHistoryChart) throws Exception, InterruptedException {
        BDynamicTimeRange bDynamicTimeRange = bHistoryChart.getRange();
        boolean bl = bHistoryChart.isDelta();
        BLabel bLabel = new BLabel("history:" + bHistoryChart.getHistory().getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        BLabel bLabel2 = new BLabel(BHistoryTableToPdf.getRangeStr(bDynamicTimeRange, (Context)pdfOp));
        bLabel.setFont(BFont.make((String)lex.getText("pdf.propertySheetToPdf.font")));
        bLabel.setHalign(BHalign.left);
        bLabel2.setHalign(BHalign.left);
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = bDynamicTimeRange.getStartTime(bAbsTime);
        BAbsTime bAbsTime3 = bDynamicTimeRange.getEndTime(bAbsTime);
        if (bAbsTime2 == null || bAbsTime2.isNull()) {
            bAbsTime2 = bHistoryChart.getHistory().getFirstTimestamp();
        }
        if (bAbsTime3 == null || bAbsTime3.isNull()) {
            bAbsTime3 = bHistoryChart.getHistory().getLastTimestamp();
        }
        bDynamicTimeRange = BDynamicTimeRange.make((BAbsTime)bAbsTime2, (BAbsTime)bAbsTime3);
        BHistoryChart bHistoryChart2 = new BHistoryChart();
        bHistoryChart2.setDefaultTimeRange(bDynamicTimeRange);
        bHistoryChart2.setDefaultDelta(bl);
        bHistoryChart2.loadValue((BObject)bHistoryChart.getHistory(), (Context)pdfOp);
        while (!bHistoryChart2.isReady()) {
            Thread.sleep(1000L);
        }
        BPdfFlowPane bPdfFlowPane = new BPdfFlowPane();
        bPdfFlowPane.add(null, (BValue)bLabel);
        bPdfFlowPane.add(null, (BValue)bLabel2);
        bPdfFlowPane.add(null, (BValue)new BLabel(""));
        bPdfFlowPane.add(null, (BValue)bHistoryChart2.popChartPane());
        bPdfFlowPane.setupPane();
        return bPdfFlowPane;
    }

    protected abstract BHistoryChart getHistoryChart(PdfOp var1);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$history$pdf$BAbstractHistoryChartToPdf;
        if (clazz == null) {
            clazz = class$com$tridium$history$pdf$BAbstractHistoryChartToPdf = BAbstractHistoryChartToPdf.class("[Lcom.tridium.history.pdf.BAbstractHistoryChartToPdf;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"pdf");
    }
}

