/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.log;

import com.tridium.history.log.BLogRecord;
import com.tridium.history.log.BSeverity;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.ConsoleLogHandler;
import javax.baja.log.Log;
import javax.baja.log.LogHandler;
import javax.baja.log.LogRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLogHistoryService
extends BComponent
implements BIService,
LogHandler,
BIHistorySource {
    public static final Property enabled = BLogHistoryService.newProperty((int)0, (boolean)true, null);
    public static final Property minimumSeverity = BLogHistoryService.newProperty((int)0, (BValue)BSeverity.message, null);
    public static final Property historyConfig = BLogHistoryService.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.make("station", "LogHistory"), BTypeSpec.make((String)"history", (String)"LogRecord")), null);
    public static final Property lastRecord = BLogHistoryService.newProperty((int)3, (BValue)new BStringTrendRecord(), null);
    public static final Action testError = BLogHistoryService.newAction((int)0, null);
    public static final Action testErrorEx = BLogHistoryService.newAction((int)0, null);
    public static final Action testWarning = BLogHistoryService.newAction((int)0, null);
    public static final Action testMessage = BLogHistoryService.newAction((int)0, null);
    public static final Action testTrace = BLogHistoryService.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static Lexicon lex;
    private static Type[] serviceTypes;
    private boolean serviceStarted;
    private BLogRecord rec;
    private ConsoleLogHandler console;
    private BIHistory history;
    static /* synthetic */ Class class$com$tridium$history$log$BLogHistoryService;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BSeverity getMinimumSeverity() {
        return (BSeverity)this.get(minimumSeverity);
    }

    public void setMinimumSeverity(BSeverity bSeverity) {
        this.set(minimumSeverity, (BValue)bSeverity, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig bHistoryConfig) {
        this.set(historyConfig, (BValue)bHistoryConfig, null);
    }

    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    public void setLastRecord(BHistoryRecord bHistoryRecord) {
        this.set(lastRecord, (BValue)bHistoryRecord, null);
    }

    public void testError() {
        this.invoke(testError, null, null);
    }

    public void testErrorEx() {
        this.invoke(testErrorEx, null, null);
    }

    public void testWarning() {
        this.invoke(testWarning, null, null);
    }

    public void testMessage() {
        this.invoke(testMessage, null, null);
    }

    public void testTrace() {
        this.invoke(testTrace, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() {
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
    }

    public synchronized void started() {
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        BHistoryConfig bHistoryConfig = this.getHistoryConfig();
        bHistoryConfig.setRecordType(BTypeSpec.make((String)"history", (String)"LogRecord"));
        BHistoryId bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), "LogHistory");
        bHistoryConfig.setId(bHistoryId);
        this.startCollecting();
    }

    private final BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getHandleOrd());
    }

    private final void initHistory() throws ServiceNotFoundException {
        BHistoryConfig bHistoryConfig = this.getHistoryConfig();
        bHistoryConfig.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        BHistoryId bHistoryId = bHistoryConfig.getId();
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        if (!bHistoryDatabase.exists(bHistoryId)) {
            bHistoryDatabase.createHistory(this.getHistoryConfig());
        } else {
            bHistoryDatabase.reconfigureHistory(this.getHistoryConfig());
        }
        this.history = bHistoryDatabase.getHistory(bHistoryId);
        try {
            BHistoryRecord bHistoryRecord = this.history.getLastRecord();
            if (bHistoryRecord != null) {
                this.setLastRecord(bHistoryRecord);
            }
        }
        catch (Exception exception) {
            BHistoryService.logger.error("Could not initialize 'Last Record' property for LogHistoryService.", (Throwable)exception);
        }
    }

    private final synchronized void startCollecting() {
        try {
            this.initHistory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.install((LogHandler)this);
    }

    public synchronized void serviceStopped() {
        this.serviceStarted = false;
        this.stopCollecting();
    }

    private final synchronized void stopCollecting() {
        Log.install((LogHandler)new ConsoleLogHandler());
        this.history = null;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void doTestError() {
        BHistoryService.logger.error("LogHistoryService: Test Error");
    }

    public void doTestErrorEx() {
        try {
            throw new IllegalStateException("Test Test Test");
        }
        catch (Exception exception) {
            BHistoryService.logger.error("LogHistoryService: Test Error w/Exception", (Throwable)exception);
            return;
        }
    }

    public void doTestWarning() {
        BHistoryService.logger.warning("LogHistoryService: Test Warning");
    }

    public void doTestMessage() {
        BHistoryService.logger.message("LogHistoryService: Test Message");
    }

    public void doTestTrace() {
        BHistoryService.logger.trace("LogHistoryService: Test Trace");
    }

    public void publish(LogRecord logRecord) {
        this.console.publish(logRecord);
        if (!this.getEnabled() || !this.serviceStarted || this.history == null) {
            return;
        }
        BSeverity bSeverity = this.getMinimumSeverity();
        if (logRecord.severity < bSeverity.getOrdinal()) {
            return;
        }
        if (this.rec == null) {
            this.rec = BLogRecord.fromRecord(logRecord);
        } else {
            this.rec.setFromRecord(logRecord);
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.outOfOrderCheck(this.rec);
            this.history.append(this.rec);
            bl = true;
        }
        catch (HistoryException historyException) {
            if (historyException instanceof HistoryDeletedException || historyException instanceof HistoryNotFoundException) {
                try {
                    this.initHistory();
                    if (!bl2) {
                        this.outOfOrderCheck(this.rec);
                    }
                    this.history.append(this.rec);
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            historyException.printStackTrace();
        }
        if (bl) {
            this.setLastRecord((BHistoryRecord)this.rec.newCopy());
        }
    }

    public void historyConfigChanged(BHistoryConfig bHistoryConfig, Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (bHistoryConfig != this.getHistoryConfig()) {
            return;
        }
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        bHistoryDatabase.reconfigureHistory(this.getHistoryConfig());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.startCollecting();
            } else {
                this.stopCollecting();
            }
        }
    }

    protected boolean outOfOrderCheck(BLogRecord bLogRecord) {
        block4: {
            try {
                BAbsTime bAbsTime = this.history.getLastTimestamp();
                BAbsTime bAbsTime2 = bLogRecord.getTimestamp();
                if (bAbsTime == null || bAbsTime.isNull() || !bAbsTime2.isBefore(bAbsTime)) break block4;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(bLogRecord.getMessage()).append(" ");
                BHistoryConfig bHistoryConfig = this.getHistoryConfig();
                BFacets bFacets = null;
                try {
                    bFacets = (BFacets)bHistoryConfig.get("timestampFacets");
                    BTimeZone bTimeZone = bHistoryConfig.getTimeZone();
                    bFacets = bFacets != null ? BFacets.make((BFacets)bFacets, (String)"TimeZone", (BIDataValue)bTimeZone) : BFacets.make((String)"TimeZone", (BIDataValue)bTimeZone);
                    bFacets = BFacets.make((BFacets)bFacets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
                }
                catch (Exception exception) {}
                stringBuffer.append(lex.getText("log.append.outOfOrder", new Object[]{bAbsTime2.toString((Context)bFacets)}));
                bLogRecord.setMessage(stringBuffer.toString());
                bLogRecord.setTimestamp(bAbsTime);
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceStarted = false;
        this.console = new ConsoleLogHandler();
    }

    public BLogHistoryService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$history$log$BLogHistoryService;
        if (clazz == null) {
            clazz = class$com$tridium$history$log$BLogHistoryService = BLogHistoryService.class("[Lcom.tridium.history.log.BLogHistoryService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"history.png");
        lex = Lexicon.make((String)"history");
        serviceTypes = new Type[]{TYPE};
    }
}

