/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordStoreHeader {
    private static int MAGIC = 182299393;
    private static int HEADER_SIZE = 256;
    private int blockSize;
    private int pageBlocks;
    private int firstPage;
    private int lastPage;
    private int recordCount;
    private ByteBuffer buf;
    private boolean dirty;

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getPageBlocks() {
        return this.pageBlocks;
    }

    public int getSize() {
        return HEADER_SIZE;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(int n) {
        if (this.firstPage == n) {
            return;
        }
        this.firstPage = n;
        this.dirty = true;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(int n) {
        if (this.lastPage == n) {
            return;
        }
        this.lastPage = n;
        this.dirty = true;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int n) {
        if (this.recordCount == n) {
            return;
        }
        this.recordCount = n;
        this.dirty = true;
    }

    public void incrementRecordCount() {
        ++this.recordCount;
        this.dirty = true;
    }

    public void decrementRecordCount() {
        --this.recordCount;
        this.dirty = true;
    }

    public void read(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != MAGIC) {
            throw new IOException("Invalid or corrupt record store.");
        }
        int n2 = dataInput.readInt();
        this.blockSize = dataInput.readInt();
        this.pageBlocks = dataInput.readInt();
        this.firstPage = dataInput.readInt();
        this.lastPage = dataInput.readInt();
        this.recordCount = dataInput.readInt();
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (!this.dirty) {
            return;
        }
        this.buf.reset();
        this.buf.writeInt(MAGIC);
        this.buf.writeInt(1);
        this.buf.writeInt(this.blockSize);
        this.buf.writeInt(this.pageBlocks);
        this.buf.writeInt(this.firstPage);
        this.buf.writeInt(this.lastPage);
        this.buf.writeInt(this.recordCount);
        byte[] byArray = this.buf.getBytes();
        if (byArray.length > HEADER_SIZE) {
            throw new IOException("Header overflow: " + byArray.length + " > " + HEADER_SIZE);
        }
        dataOutput.write(byArray, 0, HEADER_SIZE);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        return "first=" + this.firstPage + ", last=" + this.lastPage + ", recordCount= " + this.recordCount;
    }

    private final /* synthetic */ void this() {
        this.firstPage = -1;
        this.lastPage = -1;
        this.recordCount = 0;
    }

    public RecordStoreHeader() {
        this.this();
        this.buf = new ByteBuffer(HEADER_SIZE);
        this.dirty = true;
    }

    public RecordStoreHeader(int n, int n2) {
        this.this();
        this.buf = new ByteBuffer(HEADER_SIZE);
        this.blockSize = n;
        this.pageBlocks = n2;
        this.dirty = true;
    }
}

