/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.EmptyHistoryCursor;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordSpec;
import com.tridium.history.file.recstore.RecordStoreCursor;
import com.tridium.history.file.recstore.RecordStoreDescendingCursor;
import com.tridium.history.file.recstore.RecordStoreHeader;
import com.tridium.history.io.RandomAccess;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryException;
import javax.baja.history.ITruncatable;
import javax.baja.io.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Cursor;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordStore {
    public static final int EQUAL_OR_AFTER = 0;
    public static final int EQUAL_OR_BEFORE = 1;
    public static final int EQUAL = 2;
    private static final int DIRTY_CACHE_SIZE = 5;
    private Page[] dirtyPages;
    private int oldestDirtyPageIndex;
    private BHistoryConfig config;
    private BFileHistoryTable table;
    private RecordStoreHeader header;
    private ByteBuffer writeBuffer;
    private Page firstPage;
    private Page lastPage;
    private int pageSize;
    private int pageCapacity;
    private ReadBlock updateReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordStoreHeader getHeader() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.header;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRecordCount() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.header.getRecordCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPageCount() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return (int)((this.table.getAccess().length() - (long)this.header.getSize()) / (long)this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPageSize() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.pageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getBlockSize() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.header.getBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create(int n, int n2) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RandomAccess randomAccess = this.table.getAccess();
            randomAccess.seek(0L);
            this.pageSize = Page.computePageSize(n, n2);
            this.pageCapacity = Page.computeCapacity(n, n2);
            this.header = new RecordStoreHeader(n, n2);
            this.header.write(randomAccess);
            this.writeBuffer = new ByteBuffer(n);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void open() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RandomAccess randomAccess = this.table.getAccess();
            randomAccess.seek(0L);
            this.header = new RecordStoreHeader();
            this.header.read(randomAccess);
            this.pageSize = Page.computePageSize(this.header.getBlockSize(), this.header.getPageBlocks());
            this.pageCapacity = Page.computeCapacity(this.header.getBlockSize(), this.header.getPageBlocks());
            this.writeBuffer = new ByteBuffer(this.header.getBlockSize());
            int n = this.header.getFirstPage();
            int n2 = this.header.getLastPage();
            this.firstPage = n != -1 ? this.readPage(n) : null;
            this.lastPage = n2 != -1 ? (n2 == this.firstPage.index ? this.firstPage : this.readPage(n2)) : null;
            this.updateReader = new ReadBlock(this.header.getBlockSize());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean flush() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            boolean bl;
            block12: {
                bl = false;
                if (this.firstPage != null) {
                    boolean bl2 = false;
                    if (this.writePage(this.firstPage) || bl) {
                        bl2 = bl = true;
                    }
                }
                if (this.lastPage != null) {
                    boolean bl3 = false;
                    if (this.writePage(this.lastPage) || bl) {
                        bl3 = bl = true;
                    }
                }
                if (this.dirtyPages == null) break block12;
                int n = 0;
                while (true) {
                    if (n >= 5) {
                        this.dirtyPages = null;
                        this.oldestDirtyPageIndex = 0;
                        break;
                    }
                    Page page = this.dirtyPages[n];
                    if (page != null) {
                        boolean bl4 = false;
                        if (this.writePage(page) || bl) {
                            bl4 = true;
                        }
                        bl = bl4;
                    }
                    ++n;
                }
            }
            if (this.header.isDirty()) {
                RandomAccess randomAccess = this.table.getAccess();
                bl = true;
                randomAccess.seek(0L);
                this.header.write(randomAccess);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(BHistoryRecord bHistoryRecord) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            Object object2;
            int n;
            boolean bl;
            block10: {
                block11: {
                    BCapacity bCapacity = this.config.getCapacity();
                    bl = false;
                    n = Integer.MAX_VALUE;
                    if (!bCapacity.isByRecordCount()) break block10;
                    object2 = this.config.getFullPolicy();
                    n = bCapacity.getMaxRecords();
                    if (object2 != BFullPolicy.stop) break block11;
                    if (this.header.getRecordCount() >= n) {
                        return;
                    }
                    break block10;
                }
                bl = true;
            }
            this.writeBuffer.reset();
            bHistoryRecord.write((DataOutput)this.writeBuffer);
            if (this.writeBuffer.getLength() > this.pageCapacity) {
                if (bHistoryRecord instanceof ITruncatable && ((ITruncatable)((Object)bHistoryRecord)).truncate(this.pageCapacity)) {
                    this.writeBuffer.reset();
                    bHistoryRecord.write((DataOutput)this.writeBuffer);
                } else {
                    throw new IOException("Page overflow: " + this.writeBuffer.getLength() + " > " + this.pageCapacity);
                }
            }
            object2 = this.getWritePage(this.writeBuffer.getLength(), bl);
            ((Page)object2).appendRecord(this.writeBuffer.getBytes(), 0, this.writeBuffer.getLength());
            this.header.incrementRecordCount();
            if (bl) {
                while (this.header.getRecordCount() > n) {
                    this.firstPage.trimFromStart();
                    this.header.decrementRecordCount();
                    if (!this.firstPage.isEmpty()) continue;
                    this.flush();
                    this.firstPage = this.firstPage.nextPage();
                    this.header.setFirstPage(this.firstPage.index);
                    this.flush();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(BHistoryRecord bHistoryRecord, BHistoryRecord bHistoryRecord2) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RecordSpec recordSpec = this.findRecord(bHistoryRecord2.getTimestamp(), 2);
            if (recordSpec == null) {
                throw new IOException("Record not found with timestamp " + bHistoryRecord2.getTimestamp() + '.');
            }
            if (bHistoryRecord != null) {
                this.updateReader.init(recordSpec.page, recordSpec.block);
                bHistoryRecord.read(this.updateReader);
            }
            this.writeBuffer.reset();
            bHistoryRecord2.write((DataOutput)this.writeBuffer);
            if (this.writeBuffer.getLength() > this.pageCapacity) {
                throw new IOException("Page overflow: " + this.writeBuffer.getLength() + " > " + this.pageCapacity);
            }
            Page page = recordSpec.page;
            page.updateRecord(recordSpec.block, this.writeBuffer.getBytes(), 0, this.writeBuffer.getLength());
            if (page != this.lastPage && page != this.firstPage) {
                if (this.dirtyPages == null) {
                    this.dirtyPages = new Page[5];
                    this.oldestDirtyPageIndex = 0;
                    this.dirtyPages[this.oldestDirtyPageIndex] = page;
                    return;
                }
                int n = 0;
                while (n < 5) {
                    if (this.dirtyPages[n] == null) {
                        this.dirtyPages[n] = page;
                        return;
                    }
                    ++n;
                }
                this.writePage(this.dirtyPages[this.oldestDirtyPageIndex]);
                this.dirtyPages[this.oldestDirtyPageIndex] = page;
                this.oldestDirtyPageIndex = this.oldestDirtyPageIndex++;
                if (this.oldestDirtyPageIndex == 5) {
                    this.oldestDirtyPageIndex = 0;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryCursor scan() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() != 0 && this.firstPage != null) {
                return new RecordStoreCursor(this, this.config, new RecordSpec(this, this.firstPage, this.firstPage.getFirst()), null, null);
            }
            return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor query(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0 || this.firstPage == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            RecordSpec recordSpec = null;
            recordSpec = bAbsTime == null || bAbsTime.isNull() ? new RecordSpec(this, this.firstPage, this.firstPage.getFirst()) : this.findRecord(bAbsTime, 0);
            if (recordSpec == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            if (recordSpec != null && bAbsTime2 != null && !bAbsTime2.isNull() && recordSpec.getTimestamp().isAfter(bAbsTime2)) {
                return new EmptyHistoryCursor(this.table.getConfig(), this.config.makeRecord(), null);
            }
            return new RecordStoreCursor(this, this.config, recordSpec, bAbsTime2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor queryDesc(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0 || this.firstPage == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            RecordSpec recordSpec = null;
            recordSpec = bAbsTime2 == null || bAbsTime2.isNull() ? new RecordSpec(this, this.lastPage, this.lastPage.getFree() - 1) : this.findRecord(bAbsTime2, 1);
            if (recordSpec == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            if (recordSpec != null && bAbsTime != null && recordSpec.getTimestamp().isBefore(bAbsTime)) {
                return new EmptyHistoryCursor(this.table.getConfig(), this.config.makeRecord(), null);
            }
            return new RecordStoreDescendingCursor(this, this.config, recordSpec, bAbsTime, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BAbsTime getFirstTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            RecordSpec recordSpec = new RecordSpec(this, this.firstPage, this.firstPage.getFirst());
            return recordSpec.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BAbsTime getLastTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            RecordSpec recordSpec = new RecordSpec(this, this.lastPage, this.lastPage.getFree() - 1);
            return recordSpec.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHistoryRecord getLastRecord() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0) {
                return null;
            }
            RecordSpec recordSpec = new RecordSpec(this, this.lastPage, this.lastPage.getFree() - 1);
            RecordStoreCursor recordStoreCursor = new RecordStoreCursor(this, this.config, recordSpec, null, null);
            if (recordStoreCursor.next()) {
                return (BHistoryRecord)recordStoreCursor.get();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordSpec findRecord(BAbsTime bAbsTime, int n) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            Object object2;
            if (this.header.getRecordCount() == 0) {
                return null;
            }
            RecordSpec recordSpec = null;
            RecordSpec recordSpec2 = new RecordSpec(this);
            RecordSpec recordSpec3 = null;
            int n2 = this.getPageCount();
            recordSpec3 = new RecordSpec(this, this.firstPage, this.firstPage.getFirst());
            if (bAbsTime.equals((Object)recordSpec3.getTimestamp())) {
                return recordSpec3;
            }
            recordSpec = new RecordSpec(this, this.lastPage, this.lastPage.getFirst());
            if (bAbsTime.equals((Object)recordSpec.getTimestamp())) {
                return recordSpec;
            }
            if (bAbsTime.isBefore(recordSpec3.getTimestamp())) {
                if (n == 0) {
                    return recordSpec3;
                }
                return null;
            }
            if (bAbsTime.isAfter(recordSpec.getTimestamp())) {
                recordSpec2.copyFrom(recordSpec);
            } else {
                int n3;
                do {
                    if (bAbsTime.equals(object2 = (recordSpec2 = this.spec(recordSpec2, recordSpec3.page.index, recordSpec.page.index, n2)).getTimestamp())) {
                        return recordSpec2;
                    }
                    if (bAbsTime.isBefore((BAbsTime)object2)) {
                        recordSpec.copyFrom(recordSpec2);
                        continue;
                    }
                    recordSpec3.copyFrom(recordSpec2);
                } while ((n3 = this.pageDelta(recordSpec3.page.index, recordSpec.page.index, n2)) >= 2);
                if (n3 == 0) {
                    recordSpec2.copyFrom(recordSpec3);
                } else if (bAbsTime.isAfter(recordSpec.getTimestamp())) {
                    recordSpec2.copyFrom(recordSpec);
                } else {
                    recordSpec2.copyFrom(recordSpec3);
                }
            }
            recordSpec3.copyFrom(recordSpec2);
            recordSpec.set(recordSpec2.page, recordSpec2.page.getFree() - 1);
            if (recordSpec3.equals(recordSpec)) {
                if (n == 1) {
                    return recordSpec3;
                }
                if (n == 0) {
                    if (recordSpec.page.index == this.header.getLastPage()) {
                        return null;
                    }
                    object2 = recordSpec.page.nextPage();
                    recordSpec.set((Page)object2, ((Page)object2).getFirst());
                    return recordSpec;
                }
            }
            if (bAbsTime.equals((Object)recordSpec.getTimestamp())) {
                return recordSpec;
            }
            if (bAbsTime.isAfter(recordSpec.getTimestamp())) {
                if (n == 1) {
                    return recordSpec;
                }
                if (n == 0) {
                    if (recordSpec.page.index == this.header.getLastPage()) {
                        return null;
                    }
                    object2 = recordSpec.page.nextPage();
                    recordSpec.set((Page)object2, ((Page)object2).getFirst());
                    return recordSpec;
                }
            }
            recordSpec2.set(null, -1);
            while (true) {
                if (!recordSpec2.set(recordSpec3.page, (recordSpec3.block + recordSpec.block) / 2)) {
                    object2 = new RecordSpec(this);
                    while (bAbsTime.isAfter(recordSpec3.getTimestamp()) && !recordSpec3.equals(recordSpec)) {
                        ((RecordSpec)object2).copyFrom(recordSpec3);
                        recordSpec3.set(recordSpec3.page, recordSpec3.block + recordSpec3.getBlocksInRec());
                    }
                    if (bAbsTime.equals((Object)recordSpec3.getTimestamp())) {
                        return recordSpec3;
                    }
                    if (n == 1) {
                        return object2;
                    }
                    if (n == 0) {
                        return recordSpec3;
                    }
                }
                if (bAbsTime.equals((Object)recordSpec2.getTimestamp())) {
                    return recordSpec2;
                }
                if (bAbsTime.isAfter(recordSpec2.getTimestamp())) {
                    recordSpec3.copyFrom(recordSpec2);
                    continue;
                }
                recordSpec.copyFrom(recordSpec2);
            }
        }
    }

    private final RecordSpec spec(RecordSpec recordSpec, int n, int n2, int n3) throws IOException {
        int n4 = -1;
        n4 = n < n2 ? (n + n2) / 2 : (n + (n3 - n + n2 + 1) / 2) % n3;
        Page page = this.readPage(n4);
        if (recordSpec == null) {
            recordSpec = new RecordSpec(this, page, page.getFirst());
        } else {
            recordSpec.set(page, page.getFirst());
        }
        return recordSpec;
    }

    private final int pageDelta(int n, int n2, int n3) {
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return n2 - n;
        }
        return n2 + n3 - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writePage(Page page) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (!page.isDirty()) {
                return false;
            }
            RandomAccess randomAccess = this.table.getAccess();
            randomAccess.seek((long)this.header.getSize() + (long)page.index * (long)this.pageSize);
            page.write(randomAccess);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page readPage(int n) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.lastPage != null && n == this.lastPage.index) {
                return this.lastPage;
            }
            if (this.firstPage != null && n == this.firstPage.index) {
                return this.firstPage;
            }
            if (this.dirtyPages != null) {
                int n2 = 0;
                while (n2 < 5) {
                    if (this.dirtyPages[n2] != null && n == this.dirtyPages[n2].index) {
                        return this.dirtyPages[n2];
                    }
                    ++n2;
                }
            }
            Page page = new Page(this, n, this.header.getBlockSize(), this.header.getPageBlocks());
            this.readPage(page);
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readPage(Page page) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RandomAccess randomAccess = this.table.getAccess();
            randomAccess.seek((long)this.header.getSize() + (long)page.index * (long)this.pageSize);
            page.read(randomAccess);
            return;
        }
    }

    private final Page getWritePage(int n, boolean bl) throws IOException {
        if (this.lastPage == null) {
            this.newLastPage(bl);
        }
        if (!this.lastPage.hasFree(n)) {
            this.newLastPage(bl);
        }
        return this.lastPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page getFirstPage() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.firstPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page getLastPage() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.lastPage;
        }
    }

    private final void newLastPage(boolean bl) throws IOException {
        if (this.lastPage != null) {
            this.writePage(this.lastPage);
        }
        int n = this.header.getLastPage() + 1;
        if (this.header.getFirstPage() == -1 && this.header.getLastPage() == -1) {
            this.lastPage = new Page(this, n, this.header.getBlockSize(), this.header.getPageBlocks());
            this.writePage(this.lastPage);
            this.header.setLastPage(n);
            this.firstPage = this.lastPage;
            this.header.setFirstPage(this.firstPage.index);
            return;
        }
        if (bl) {
            int n2 = this.getPageCount();
            if (n == n2) {
                int n3 = this.firstPage.index;
                if (n3 < 2) {
                    this.lastPage = new Page(this, n, this.header.getBlockSize(), this.header.getPageBlocks());
                    this.writePage(this.lastPage);
                    this.header.setLastPage(n);
                } else {
                    this.lastPage = this.readPage(0);
                    this.header.setRecordCount(this.header.getRecordCount() - this.lastPage.clear());
                    this.header.setLastPage(0);
                }
            } else {
                if (n == this.firstPage.index) {
                    this.lastPage = this.firstPage;
                    this.firstPage = this.firstPage.nextPage();
                    this.header.setFirstPage(this.firstPage.index);
                } else {
                    this.lastPage = this.readPage(n);
                }
                this.header.setRecordCount(this.header.getRecordCount() - this.lastPage.clear());
                this.header.setLastPage(this.lastPage.index);
            }
        } else {
            this.lastPage = new Page(this, n, this.header.getBlockSize(), this.header.getPageBlocks());
            this.writePage(this.lastPage);
            this.header.setLastPage(n);
            if (this.header.getFirstPage() == -1) {
                this.firstPage = this.lastPage;
                this.header.setFirstPage(this.firstPage.index);
            }
        }
    }

    public static BHistoryConfig cfg(BCapacity bCapacity, BFullPolicy bFullPolicy) {
        BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make("test", "var"), BTypeSpec.make((String)"history", (String)"StringTrendRecord"));
        bHistoryConfig.setCapacity(bCapacity);
        bHistoryConfig.setFullPolicy(bFullPolicy);
        return bHistoryConfig;
    }

    private final /* synthetic */ void this() {
        this.dirtyPages = null;
        this.oldestDirtyPageIndex = 0;
    }

    public RecordStore(BHistoryConfig bHistoryConfig, BFileHistoryTable bFileHistoryTable) throws IOException {
        this.this();
        this.config = bHistoryConfig;
        this.table = bFileHistoryTable;
        if (bFileHistoryTable.getAccess().length() == 0L) {
            throw new IOException("Invalid or corrupt record store.");
        }
        this.open();
    }

    public RecordStore(BHistoryConfig bHistoryConfig, BFileHistoryTable bFileHistoryTable, int n, int n2) throws IOException {
        this.this();
        this.config = bHistoryConfig;
        this.table = bFileHistoryTable;
        if (bFileHistoryTable.getAccess().length() == 0L) {
            this.create(n, n2);
        } else {
            this.open();
        }
    }
}

