/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordStore;
import java.io.DataInput;
import java.io.IOException;
import javax.baja.sys.BAbsTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordSpec {
    public final RecordStore store;
    public Page page;
    private int lastSetBlock;
    public int block;
    private ReadBlock reader;
    private int blocksInRec;
    private BAbsTime tstamp;

    public boolean set(Page page, int n) throws IOException {
        boolean bl = false;
        if (this.page != page) {
            bl = true;
        }
        this.page = page;
        if (n != this.lastSetBlock) {
            bl = true;
        }
        this.block = n;
        this.lastSetBlock = n;
        if (page != null) {
            if (this.reader == null) {
                this.reader = new ReadBlock(this.store.getBlockSize());
            }
            this.reader.init(page, n);
            if (this.reader.getRecBlock() != 0) {
                this.block -= this.reader.getRecBlock();
                this.reader.init(page, this.block);
            }
            this.blocksInRec = this.reader.getBlocksInRec();
            this.tstamp = (BAbsTime)BAbsTime.DEFAULT.decode((DataInput)this.reader);
        } else {
            this.tstamp = null;
        }
        return bl;
    }

    public BAbsTime getTimestamp() throws IOException {
        return this.tstamp;
    }

    public int getBlocksInRec() {
        return this.blocksInRec;
    }

    public void copyFrom(RecordSpec recordSpec) {
        this.page = recordSpec.page;
        this.block = recordSpec.block;
        this.tstamp = recordSpec.tstamp;
        this.blocksInRec = recordSpec.blocksInRec;
    }

    public boolean equals(Object object) {
        RecordSpec recordSpec = (RecordSpec)object;
        boolean bl = false;
        if (this.store == recordSpec.store && this.page == recordSpec.page && this.block == recordSpec.block) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        try {
            return "page=" + this.page.index + ", block=" + this.block + ", ts=" + this.getTimestamp();
        }
        catch (Exception exception) {
            return "page=" + this.page.index + ", block=" + this.block + ", ts=" + exception.toString();
        }
    }

    private final /* synthetic */ void this() {
        this.lastSetBlock = -1;
        this.block = -1;
    }

    public RecordSpec(RecordStore recordStore, Page page, int n) throws IOException {
        this.this();
        this.store = recordStore;
        this.set(page, n);
    }

    public RecordSpec(RecordStore recordStore) {
        this.this();
        this.store = recordStore;
    }
}

