/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordStore;
import com.tridium.history.file.recstore.WriteBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import javax.baja.sys.BAbsTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Page {
    public static final int HEADER_SIZE = 12;
    public final RecordStore store;
    public final int index;
    private int recordCount;
    private int first;
    private int free;
    byte[] buf;
    boolean dirty;
    private WriteBlock writeBlock;
    private ReadBlock readBlock;

    public Page nextPage() throws IOException {
        if (this.index == this.store.getHeader().getLastPage()) {
            return null;
        }
        int n = this.index + 1;
        if (n == this.store.getPageCount()) {
            n = 0;
        }
        return this.store.readPage(n);
    }

    public Page prevPage() throws IOException {
        if (this.index == this.store.getHeader().getFirstPage()) {
            return null;
        }
        int n = this.index - 1;
        if (n == -1) {
            n = this.store.getPageCount() - 1;
        }
        return this.store.readPage(n);
    }

    public static int computePageSize(int n, int n2) {
        return n2 * n + 12;
    }

    public static int computeCapacity(int n, int n2) {
        return n2 * n - n2 * 8;
    }

    public int getSize() {
        return this.buf.length;
    }

    public int getHeaderSize() {
        return 12;
    }

    public int getFirst() {
        return this.first;
    }

    public int getFree() {
        return this.free;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.recordCount == 0) {
            bl = true;
        }
        return bl;
    }

    public void appendRecord(byte[] byArray) throws IOException {
        this.appendRecord(byArray, 0, byArray.length);
    }

    public synchronized void appendRecord(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2 / this.writeBlock.capacity;
        if (n3 * this.writeBlock.capacity < n2) {
            ++n3;
        }
        int n4 = 0;
        while (n2 != 0) {
            int n5 = n2 > this.writeBlock.capacity ? this.writeBlock.capacity : n2;
            this.writeBlock.start(this.free, n3, n4);
            this.dirty = true;
            this.writeBlock.write(byArray, n, n5);
            n += n5;
            n2 -= n5;
            ++n4;
            ++this.free;
        }
        ++this.recordCount;
        if (this.first == -1) {
            this.first = 0;
        }
    }

    public synchronized void updateRecord(int n, byte[] byArray) throws IOException {
        this.updateRecord(n, byArray, 0, byArray.length);
    }

    public synchronized void updateRecord(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3 / this.writeBlock.capacity;
        if (n4 * this.writeBlock.capacity < n3) {
            ++n4;
        }
        if (this.readBlock == null) {
            this.readBlock = new ReadBlock(this.store.getBlockSize());
        }
        this.readBlock.init(this, n);
        int n5 = this.readBlock.getBlocksInRec();
        if (n4 > n5) {
            throw new IOException("Modified record requires more blocks than the original.");
        }
        int n6 = 0;
        while (n3 != 0) {
            int n7 = n3 > this.writeBlock.capacity ? this.writeBlock.capacity : n3;
            this.writeBlock.start(n, n4, n6);
            this.dirty = true;
            this.writeBlock.write(byArray, n2, n7);
            n2 += n7;
            n3 -= n7;
            ++n6;
            ++n;
        }
    }

    public synchronized boolean trimFromStart() throws IOException {
        if (this.recordCount == 0) {
            return false;
        }
        if (this.readBlock == null) {
            this.readBlock = new ReadBlock(this.store.getBlockSize());
        }
        this.readBlock.init(this, this.first);
        int n = this.readBlock.getBlocksInRec();
        int n2 = this.first;
        while (n2 < this.first + n) {
            this.clearBlock(n2);
            ++n2;
        }
        this.first += n;
        --this.recordCount;
        if (this.recordCount == 0) {
            this.first = -1;
            this.free = 0;
        }
        return true;
    }

    public synchronized int clear() {
        int n = this.recordCount;
        int n2 = this.buf.length;
        int n3 = 0;
        while (n3 < n2) {
            this.buf[n3] = 0;
            ++n3;
        }
        this.first = -1;
        this.free = 0;
        this.recordCount = 0;
        this.dirty = true;
        return n;
    }

    public synchronized boolean hasFree(int n) {
        int n2 = this.store.getBlockSize();
        int n3 = (this.buf.length - 12) / n2;
        int n4 = n3 - this.free;
        int n5 = n4 * (n2 - 8);
        boolean bl = false;
        if (n5 >= n) {
            bl = true;
        }
        return bl;
    }

    private final void clearBlock(int n) {
        int n2 = this.store.getBlockSize();
        int n3 = 0;
        while (n3 < n2) {
            this.buf[n3] = 0;
            ++n3;
        }
        this.dirty = true;
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized void read(DataInput dataInput) throws IOException {
        dataInput.readFully(this.buf);
        this.recordCount = this.readInt(0);
        this.first = this.readInt(4);
        this.free = this.readInt(8);
        this.dirty = false;
    }

    public synchronized void write(DataOutput dataOutput) throws IOException {
        this.writeInt(0, this.recordCount);
        this.writeInt(4, this.first);
        this.writeInt(8, this.free);
        dataOutput.write(this.buf, 0, this.buf.length);
        this.dirty = false;
    }

    private final int readInt(int n) throws IOException {
        return ((this.buf[n++] & 0xFF) << 24) + ((this.buf[n++] & 0xFF) << 16) + ((this.buf[n++] & 0xFF) << 8) + (this.buf[n++] & 0xFF);
    }

    private final void writeInt(int n, int n2) {
        this.buf[n++] = (byte)(n2 >>> 24 & 0xFF);
        this.buf[n++] = (byte)(n2 >>> 16 & 0xFF);
        this.buf[n++] = (byte)(n2 >>> 8 & 0xFF);
        this.buf[n++] = (byte)(n2 & 0xFF);
        this.dirty = true;
    }

    public String toString() {
        return "Page(" + this.index + "): records=" + this.recordCount + ", first=" + this.first + ", free=" + this.free + ", dirty=" + this.dirty;
    }

    public void dump(PrintWriter printWriter) throws IOException {
        printWriter.println("--- Page: " + this.index);
        printWriter.println("recordCount: " + this.recordCount);
        printWriter.println("first      : " + this.first);
        printWriter.println("free       : " + this.free);
        printWriter.println("dirty      : " + this.dirty);
        printWriter.println("blocks:");
        ReadBlock readBlock = new ReadBlock(this.store.getBlockSize());
        int n = this.first;
        while (n < this.free) {
            readBlock.init(this, n);
            printWriter.print(n + ") " + readBlock.getBlocksInRec() + ':' + readBlock.getRecBlock());
            if (readBlock.getRecBlock() == 0) {
                printWriter.println(" t=" + BAbsTime.DEFAULT.decode((DataInput)readBlock));
            } else {
                printWriter.println();
            }
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.recordCount = 0;
        this.first = -1;
        this.free = 0;
        this.dirty = false;
    }

    public Page(RecordStore recordStore, int n, int n2, int n3) {
        this.this();
        this.store = recordStore;
        this.index = n;
        this.buf = new byte[Page.computePageSize(n2, n3)];
        this.writeInt(0, this.recordCount);
        this.writeInt(4, this.first);
        this.writeInt(8, this.free);
        this.writeBlock = new WriteBlock(this, n2);
    }
}

