/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.fixed.Page;
import com.tridium.history.file.fixed.PageManager;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordSpec {
    private PageManager pageman;
    private Page page;
    int pageIndex;
    int recIndex;
    private int recCount;

    public String toString() {
        return "rec:" + this.pageIndex + ',' + this.recIndex;
    }

    public boolean equals(Object object) {
        if (object instanceof RecordSpec) {
            RecordSpec recordSpec = (RecordSpec)object;
            boolean bl = false;
            if (recordSpec.pageIndex == this.pageIndex && recordSpec.recIndex == this.recIndex) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void set(int n, int n2) throws IOException {
        this.pageIndex = n;
        this.recIndex = n2;
        if (this.page == null || this.page.index != n) {
            this.page = this.pageman.getPage(n);
            this.recCount = this.page.getRecordCount();
        }
    }

    public void copyFrom(RecordSpec recordSpec) {
        this.pageman = recordSpec.pageman;
        this.pageIndex = recordSpec.pageIndex;
        this.recIndex = recordSpec.recIndex;
        this.recCount = recordSpec.recCount;
        this.page = recordSpec.page;
    }

    public BHistoryRecord getRecord(BHistoryRecord bHistoryRecord) throws IOException {
        this.page.read(this.recIndex, bHistoryRecord);
        return bHistoryRecord;
    }

    public void setRecord(BHistoryRecord bHistoryRecord) throws IOException {
        this.page.set(this.recIndex, bHistoryRecord);
    }

    public BAbsTime getTimestamp() throws IOException {
        return this.page.readTimestamp(this.recIndex);
    }

    public boolean next() throws IOException {
        ++this.recIndex;
        if (this.recIndex == this.page.getMaxRecords()) {
            int n = this.pageman.nextPage(this.pageIndex);
            if (n == -1) {
                --this.recIndex;
                return false;
            }
            this.pageIndex = n;
            try {
                this.page = this.pageman.getPage(this.pageIndex);
                this.recIndex = 0;
                if (this.page.getRecordCount() == 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                --this.recIndex;
                --this.pageIndex;
                return false;
            }
        }
        return true;
    }

    public boolean prev() throws IOException {
        --this.recIndex;
        if (this.recIndex == -1) {
            int n = this.pageman.previousPage(this.pageIndex);
            this.pageIndex = n == -1 ? this.pageman.lastPage() : n;
            try {
                this.page = this.pageman.getPage(this.pageIndex);
                this.recIndex = this.page.getRecordCount() - 1 + this.page.getFirstIndex();
                if (this.page.getRecordCount() == 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ++this.recIndex;
                ++this.pageIndex;
                return false;
            }
        }
        return true;
    }

    private final /* synthetic */ void this() {
        this.pageIndex = -1;
        this.recIndex = -1;
    }

    public RecordSpec(PageManager pageManager) {
        this.this();
        this.pageman = pageManager;
    }

    public RecordSpec(PageManager pageManager, int n, int n2) throws IOException {
        this.this();
        this.pageman = pageManager;
        this.set(n, n2);
    }
}

