/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.baja.history.BHistoryRecord;
import javax.baja.io.ByteBuffer;
import javax.baja.sys.BAbsTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Page {
    private static final int HEADER_SIZE = 8;
    public final int index;
    private int recSize;
    private int first;
    private int last;
    private byte[] buf;
    private int maxRecords;
    private boolean dirty;
    private PageInput pageIn;
    private PageOutput pageOut;

    public static int computeRecordsPerPage(int n, int n2) {
        return (n - 8) / n2;
    }

    public int getRecordCount() {
        if (this.first == -1) {
            return 0;
        }
        return this.last - this.first + 1;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public int trimFromStart(int n) {
        if (this.first + n > this.maxRecords) {
            throw new IllegalArgumentException(this.first + n + " > " + this.maxRecords);
        }
        this.first += n;
        this.dirty = true;
        return this.getRecordCount();
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized void read(DataInput dataInput) throws IOException {
        dataInput.readFully(this.buf);
        this.pageOut.reset();
        this.pageIn.reset();
        this.first = this.pageIn.readInt();
        this.last = this.pageIn.readInt();
        this.dirty = false;
    }

    public synchronized void write(DataOutput dataOutput) throws IOException {
        this.pageOut.seek(0);
        this.pageOut.writeInt(this.first);
        this.pageOut.writeInt(this.last);
        dataOutput.write(this.buf, 0, this.buf.length);
        this.dirty = false;
    }

    public synchronized boolean isFull() {
        boolean bl = false;
        if (8 + (this.last + 1) * this.recSize + this.recSize > this.buf.length) {
            bl = true;
        }
        return bl;
    }

    public synchronized int getFirstIndex() {
        return this.first;
    }

    public synchronized int getLastIndex() {
        return this.last;
    }

    public synchronized void read(int n, BHistoryRecord bHistoryRecord) throws IOException {
        this.pageIn.seek(n * this.recSize + 8);
        bHistoryRecord.read(this.pageIn);
    }

    public synchronized BAbsTime readTimestamp(int n) throws IOException {
        this.pageIn.seek(n * this.recSize + 8);
        BAbsTime bAbsTime = (BAbsTime)BAbsTime.DEFAULT.decode((DataInput)this.pageIn);
        return bAbsTime;
    }

    public synchronized boolean append(BHistoryRecord bHistoryRecord) throws IOException {
        if (this.last + 1 == this.maxRecords) {
            return false;
        }
        if (this.first == -1) {
            this.last = 0;
            this.first = 0;
        } else {
            ++this.last;
        }
        this.pageOut.seek(this.last * this.recSize + 8);
        bHistoryRecord.write(this.pageOut);
        byte[] byArray = new byte[8];
        System.arraycopy(this.buf, this.last * this.recSize + 8, byArray, 0, 8);
        ByteBuffer byteBuffer = new ByteBuffer(byArray);
        this.pageIn.seek(this.last * this.recSize + 8);
        bHistoryRecord.read(this.pageIn);
        this.dirty = true;
        return true;
    }

    public synchronized boolean set(int n, BHistoryRecord bHistoryRecord) throws IOException {
        if (n >= this.maxRecords) {
            return false;
        }
        this.pageOut.seek(n * this.recSize + 8);
        bHistoryRecord.write(this.pageOut);
        this.dirty = true;
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Page ").append(this.index);
        stringBuffer.append(": first=").append(this.first);
        stringBuffer.append(" last=").append(this.last);
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.dirty = false;
    }

    public Page(int n, int n2, int n3) {
        this.this();
        this.index = n;
        this.recSize = n3;
        this.buf = new byte[n2];
        this.last = -1;
        this.first = -1;
        this.maxRecords = Page.computeRecordsPerPage(n2, n3);
        this.pageOut = new PageOutput();
        this.pageIn = new PageInput();
        this.dirty = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PageOutput
    implements DataOutput {
        private int offset;

        public void reset() {
            this.offset = 0;
        }

        public void seek(int n) {
            this.offset = n;
        }

        public void write(int n) {
            ((Page)Page.this).buf[this.offset++] = (byte)n;
        }

        public void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) {
            System.arraycopy(byArray, n, Page.this.buf, this.offset, n2);
            this.offset += n2;
        }

        public void writeBoolean(boolean bl) {
            this.write(bl ? 1 : 0);
        }

        public void writeByte(int n) {
            this.write(n);
        }

        public void writeShort(int n) {
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        }

        public void writeChar(int n) {
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        }

        public void writeInt(int n) {
            this.write(n >>> 24 & 0xFF);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        }

        public void writeLong(long l) {
            this.write((int)(l >>> 56) & 0xFF);
            this.write((int)(l >>> 48) & 0xFF);
            this.write((int)(l >>> 40) & 0xFF);
            this.write((int)(l >>> 32) & 0xFF);
            this.write((int)(l >>> 24) & 0xFF);
            this.write((int)(l >>> 16) & 0xFF);
            this.write((int)(l >>> 8) & 0xFF);
            this.write((int)l & 0xFF);
        }

        public void writeFloat(float f) {
            this.writeInt(Float.floatToIntBits(f));
        }

        public void writeDouble(double d) {
            this.writeLong(Double.doubleToLongBits(d));
        }

        public void writeBytes(String string) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                this.write((byte)string.charAt(n2));
                ++n2;
            }
        }

        public void writeChars(String string) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                this.write(c >>> 8 & 0xFF);
                this.write(c & 0xFF);
                ++n2;
            }
        }

        public void writeUTF(String string) throws UTFDataFormatException {
            throw new UnsupportedOperationException("writeUTF not supported");
        }

        public PageOutput() {
            this.reset();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PageInput
    implements DataInput {
        private int offset;

        public void reset() {
            this.offset = 0;
        }

        public void seek(int n) {
            this.offset = n;
        }

        public int read() throws IOException {
            try {
                return Page.this.buf[this.offset++] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new EOFException();
            }
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, Page.this.buf.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = Math.min(n2, Page.this.buf.length - this.offset);
            System.arraycopy(Page.this.buf, this.offset, byArray, n, n3);
            this.offset += n3;
            return n3;
        }

        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length);
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.read(byArray, n, n2);
            if (n3 != n2) {
                throw new EOFException();
            }
        }

        public int skipBytes(int n) throws IOException {
            this.offset += n;
            if (this.offset >= Page.this.buf.length) {
                throw new EOFException();
            }
            return n;
        }

        public boolean readBoolean() throws IOException {
            boolean bl = false;
            if (this.read() != 0) {
                bl = true;
            }
            return bl;
        }

        public byte readByte() throws IOException {
            return (byte)this.read();
        }

        public int readUnsignedByte() throws IOException {
            return this.read();
        }

        public short readShort() throws IOException {
            return (short)((this.read() << 8) + this.read());
        }

        public int readUnsignedShort() throws IOException {
            return (this.read() << 8) + this.read();
        }

        public char readChar() throws IOException {
            return (char)((this.read() << 8) + this.read());
        }

        public int readInt() throws IOException {
            return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
        }

        public long readLong() throws IOException {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }

        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String readUTF() throws IOException {
            throw new UnsupportedOperationException("readUTF not supported");
        }

        public PageInput() {
            this.reset();
        }
    }
}

