/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.db.TableHandle;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.bql.BqlQuery;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.InvalidHistoryIdException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHistoryDbTable
extends BObject {
    public static final Type TYPE;
    private long lastAccess;
    private boolean open;
    private boolean deleted;
    private BHistoryDatabase db;
    private TableHandle handle;
    protected Object tableLock;
    private BHistoryConfig config;
    private HashMap historySources;
    static /* synthetic */ Class class$com$tridium$history$db$BHistoryDbTable;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableHandle getTableHandle() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHistoryConfig getConfig() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setConfig(BHistoryConfig bHistoryConfig) {
        Object object = this.tableLock;
        synchronized (object) {
            this.config = bHistoryConfig;
            this.configChanged();
            return;
        }
    }

    public Object getTableLock() {
        return this.tableLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOpen() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void open() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            this.updateLastAccess();
            if (this.open) {
                return;
            }
            if (!this.getConfig().getId().isValid()) {
                throw new InvalidHistoryIdException(this.getConfig().getId());
            }
            if (this.handle != null) {
                this.handle.unbind();
                this.handle = null;
            }
            this.handle = new TableHandle(this, this.tableLock);
            this.doOpen();
            this.open = true;
            BCapacity bCapacity = this.getConfig().getCapacity();
            if (bCapacity.isByRecordCount() && this.getRecordCount() > bCapacity.getMaxRecords()) {
                BFullPolicy bFullPolicy = this.getConfig().getFullPolicy();
                this.resize(bCapacity, bFullPolicy);
            }
            return;
        }
    }

    protected abstract void doOpen() throws HistoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close() {
        Object object = this.tableLock;
        synchronized (object) {
            block7: {
                if (!this.open) break block7;
                try {
                    this.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this.doClose();
                }
                catch (Exception exception) {}
                this.handle.unbind();
                this.handle = null;
                this.open = false;
                this.lastAccess = 0L;
                this.unsubscribeAllHistorySources();
            }
            return;
        }
    }

    protected abstract void doClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void flush() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.updateLastAccess();
            this.doFlush();
            return;
        }
    }

    protected abstract void doFlush() throws HistoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void checkDeleted() throws HistoryDeletedException {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.deleted) {
                throw new HistoryDeletedException(this.config.getId());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean delete() {
        Object object = this.tableLock;
        synchronized (object) {
            this.close();
            if (this.doDelete()) {
                this.deleted = true;
                return true;
            }
            return false;
        }
    }

    protected abstract boolean doDelete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void renameHistory(String string) {
        Object object = this.tableLock;
        synchronized (object) {
            this.doRenameHistory(string);
            return;
        }
    }

    protected abstract void doRenameHistory(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void resize(BCapacity bCapacity, BFullPolicy bFullPolicy) {
        Object object = this.tableLock;
        synchronized (object) {
            this.doResize(bCapacity, bFullPolicy);
            return;
        }
    }

    protected abstract void doResize(BCapacity var1, BFullPolicy var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear() {
        Object object = this.tableLock;
        synchronized (object) {
            this.open();
            this.doClear();
            return;
        }
    }

    protected abstract void doClear();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear(BAbsTime bAbsTime) {
        Object object = this.tableLock;
        synchronized (object) {
            this.open();
            this.doClear(bAbsTime);
            return;
        }
    }

    protected abstract void doClear(BAbsTime var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLastAccess() {
        Object object = this.tableLock;
        synchronized (object) {
            if (Thread.currentThread() != BLocalHistoryDatabase.WARM_UP_THREAD) {
                this.lastAccess = Clock.ticks();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkLastAccess(long l, long l2) {
        Object object = this.tableLock;
        synchronized (object) {
            long l3 = l - l2;
            if (l3 < 0L) {
                return true;
            }
            boolean bl = false;
            if (this.lastAccess < l3) return bl;
            return true;
        }
    }

    public abstract int getRecordCount() throws HistoryException, UnsupportedOperationException;

    public abstract BAbsTime getFirstTimestamp() throws HistoryException;

    public abstract BAbsTime getLastTimestamp() throws HistoryException;

    public abstract BHistoryRecord getLastRecord() throws HistoryException;

    public Cursor scan(boolean bl) throws HistoryException {
        return this.timeQuery(null, null, bl);
    }

    public abstract Cursor timeQuery(BAbsTime var1, BAbsTime var2, boolean var3) throws HistoryException;

    public Cursor bqlQuery(BqlQuery bqlQuery) throws HistoryException {
        Range range;
        SelectQuery selectQuery = (SelectQuery)bqlQuery;
        RangeSet rangeSet = null;
        boolean bl = false;
        if (selectQuery.getSelect().hasOrdering()) {
            range = selectQuery.getSelect().getOrdering().getOrderByColumns();
            int n = 0;
            while (n < ((BOrderByColumn[])range).length) {
                BFieldExpression bFieldExpression;
                if (range[n].getColumnExpression() instanceof BFieldExpression && (bFieldExpression = (BFieldExpression)range[n].getColumnExpression()).getField().equals(BHistoryRecord.timestamp.getName())) {
                    bl = range[n].isAscending() ^ true;
                }
                ++n;
            }
        }
        if (!selectQuery.hasPredicate()) {
            return this.scan(bl);
        }
        rangeSet = selectQuery.getRange("timestamp", BAbsTime.TYPE, false);
        if (rangeSet.isAll()) {
            return this.scan(bl);
        }
        rangeSet.sort();
        range = rangeSet.getRange(0);
        Range range2 = rangeSet.getRange(rangeSet.getCount() - 1);
        return this.timeQuery((BAbsTime)range.min, (BAbsTime)range2.max, bl);
    }

    public abstract int append(BIHistoryRecordSet var1) throws HistoryException;

    public abstract void update(BHistoryRecord var1, BHistoryRecord var2) throws HistoryException, UnsupportedOperationException;

    protected final void configChanged() {
        this.doConfigChanged();
    }

    protected void doConfigChanged() {
    }

    public BHistoryDatabase getDatabase() {
        return this.db;
    }

    public void setDatabase(BHistoryDatabase bHistoryDatabase) {
        this.db = bHistoryDatabase;
    }

    public void inspect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int updateHistorySubscriptionCount(BComponent bComponent, int n) {
        HashMap hashMap = null;
        Object object = this.tableLock;
        synchronized (object) {
            if (!this.open) {
                return 0;
            }
            if (n == 0) {
                int n2 = 0;
                if (this.historySources != null) {
                    n2 = this.historySources.size();
                }
                return n2;
            }
            if (this.historySources == null) {
                this.historySources = new HashMap();
            }
            hashMap = this.historySources;
        }
        object = hashMap;
        synchronized (object) {
            if (this.open) {
                if (bComponent instanceof BIPollableHistorySource) {
                    ((BIPollableHistorySource)bComponent).updateHistorySubscriptionCount(n);
                }
                BHistoryDbTable.updateHistorySources(hashMap, bComponent, n);
            }
        }
        object = this.tableLock;
        synchronized (object) {
            if (this.historySources != null && this.historySources.isEmpty()) {
                this.historySources = null;
            }
            int n3 = 0;
            if (this.historySources != null) {
                n3 = this.historySources.size();
            }
            return n3;
        }
    }

    private static final void updateHistorySources(HashMap hashMap, BComponent bComponent, int n) {
        Integer n2 = (Integer)hashMap.get(bComponent);
        int n3 = n;
        if (n2 != null && (n3 = n2 + n3) <= 0) {
            hashMap.remove(bComponent);
            return;
        }
        hashMap.put(bComponent, new Integer(n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unsubscribeAllHistorySources() {
        if (this.historySources == null) {
            return;
        }
        HashMap hashMap = this.historySources;
        synchronized (hashMap) {
            Iterator iterator = this.historySources.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.historySources.clear();
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.historySources = null;
                    return;
                }
                Object k = iterator.next();
                try {
                    Integer n = (Integer)this.historySources.get(k);
                    if (!(k instanceof BIPollableHistorySource)) continue;
                    ((BIPollableHistorySource)k).updateHistorySubscriptionCount(-1 * n);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastAccess = 0L;
        this.open = false;
        this.deleted = false;
        this.tableLock = new Object();
        this.historySources = null;
    }

    public BHistoryDbTable() {
        this.this();
    }

    public BHistoryDbTable(BHistoryConfig bHistoryConfig) {
        this.this();
        this.setConfig(bHistoryConfig);
    }

    static {
        Class clazz = class$com$tridium$history$db$BHistoryDbTable;
        if (clazz == null) {
            clazz = class$com$tridium$history$db$BHistoryDbTable = BHistoryDbTable.class("[Lcom.tridium.history.db.BHistoryDbTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

