/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.collection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BFacets;

public class ColumnSpec {
    public final String name;
    public final String displayName;
    public final BFacets facets;

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.name);
        dataOutput.writeUTF(this.displayName);
        if (this.facets.isNull()) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.facets.encodeToString());
        }
    }

    public static ColumnSpec read(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        String string2 = dataInput.readUTF();
        boolean bl = dataInput.readBoolean();
        BFacets bFacets = null;
        if (bl) {
            bFacets = (BFacets)BFacets.DEFAULT.decodeFromString(dataInput.readUTF());
        }
        return new ColumnSpec(string, string2, bFacets);
    }

    public ColumnSpec(String string, String string2, BFacets bFacets) {
        this.name = string;
        this.displayName = string2;
        this.facets = bFacets == null ? BFacets.NULL : bFacets;
    }
}

