/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.audit;

import com.tridium.history.audit.BAuditRecord;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAuditHistoryService
extends BComponent
implements BIService,
Auditor,
BIHistorySource {
    public static final Property enabled = BAuditHistoryService.newProperty((int)0, (boolean)true, null);
    public static final Property historyConfig = BAuditHistoryService.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.make("station", "AuditHistory"), BTypeSpec.make((String)"history", (String)"AuditRecord")), null);
    public static final Property lastRecord = BAuditHistoryService.newProperty((int)3, (BValue)new BStringTrendRecord(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static Lexicon lex;
    private static Type[] serviceTypes;
    private boolean serviceStarted;
    private BAuditRecord rec;
    private BIHistory history;
    static /* synthetic */ Class class$com$tridium$history$audit$BAuditHistoryService;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig bHistoryConfig) {
        this.set(historyConfig, (BValue)bHistoryConfig, null);
    }

    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    public void setLastRecord(BHistoryRecord bHistoryRecord) {
        this.set(lastRecord, (BValue)bHistoryRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() {
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
    }

    public synchronized void started() {
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        BHistoryConfig bHistoryConfig = this.getHistoryConfig();
        bHistoryConfig.setRecordType(BTypeSpec.make((String)"history", (String)"AuditRecord"));
        BHistoryId bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), "AuditHistory");
        bHistoryConfig.setId(bHistoryId);
        this.startAudit();
    }

    private final BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getHandleOrd());
    }

    private final void initHistory() throws ServiceNotFoundException {
        BHistoryConfig bHistoryConfig = this.getHistoryConfig();
        bHistoryConfig.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        BHistoryId bHistoryId = bHistoryConfig.getId();
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        if (!bHistoryDatabase.exists(bHistoryId)) {
            bHistoryDatabase.createHistory(bHistoryConfig);
        } else {
            bHistoryDatabase.reconfigureHistory(bHistoryConfig);
        }
        this.history = bHistoryDatabase.getHistory(bHistoryId);
        try {
            BHistoryRecord bHistoryRecord = this.history.getLastRecord();
            if (bHistoryRecord != null) {
                this.setLastRecord(bHistoryRecord);
            }
        }
        catch (Exception exception) {
            BHistoryService.logger.error("Could not initialize 'Last Record' property for AuditHistoryService.", (Throwable)exception);
        }
    }

    private final synchronized void startAudit() {
        try {
            this.initHistory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Sys.setAuditor((Auditor)this);
    }

    public synchronized void serviceStopped() {
        this.stopAudit();
        this.serviceStarted = false;
    }

    private final synchronized void stopAudit() {
        Sys.setAuditor(null);
        this.history = null;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void audit(AuditEvent auditEvent) {
        if (this.rec == null) {
            this.rec = BAuditRecord.fromEvent(auditEvent);
        } else {
            this.rec.setFromEvent(auditEvent);
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.outOfOrderCheck(this.rec);
            this.history.append(this.rec);
            bl = true;
        }
        catch (HistoryException historyException) {
            if (historyException instanceof HistoryDeletedException || historyException instanceof HistoryNotFoundException) {
                this.initHistory();
                if (!bl2) {
                    this.outOfOrderCheck(this.rec);
                }
                this.history.append(this.rec);
                bl = true;
            }
            throw historyException;
        }
        if (bl) {
            this.setLastRecord((BHistoryRecord)this.rec.newCopy());
        }
    }

    public void historyConfigChanged(BHistoryConfig bHistoryConfig, Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (bHistoryConfig != this.getHistoryConfig()) {
            return;
        }
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        bHistoryDatabase.reconfigureHistory(this.getHistoryConfig());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.startAudit();
            } else {
                this.stopAudit();
            }
        }
    }

    protected boolean outOfOrderCheck(BAuditRecord bAuditRecord) {
        block4: {
            try {
                BAbsTime bAbsTime = this.history.getLastTimestamp();
                BAbsTime bAbsTime2 = bAuditRecord.getTimestamp();
                if (bAbsTime == null || bAbsTime.isNull() || !bAbsTime2.isBefore(bAbsTime)) break block4;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(bAuditRecord.getOperation()).append(" ");
                BHistoryConfig bHistoryConfig = this.getHistoryConfig();
                BFacets bFacets = null;
                try {
                    bFacets = (BFacets)bHistoryConfig.get("timestampFacets");
                    BTimeZone bTimeZone = bHistoryConfig.getTimeZone();
                    bFacets = bFacets != null ? BFacets.make((BFacets)bFacets, (String)"TimeZone", (BIDataValue)bTimeZone) : BFacets.make((String)"TimeZone", (BIDataValue)bTimeZone);
                    bFacets = BFacets.make((BFacets)bFacets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
                }
                catch (Exception exception) {}
                stringBuffer.append(lex.getText("log.append.outOfOrder", new Object[]{bAbsTime2.toString((Context)bFacets)}));
                bAuditRecord.setOperation(stringBuffer.toString());
                bAuditRecord.setTimestamp(bAbsTime);
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceStarted = false;
    }

    public BAuditHistoryService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$history$audit$BAuditHistoryService;
        if (clazz == null) {
            clazz = class$com$tridium$history$audit$BAuditHistoryService = BAuditHistoryService.class("[Lcom.tridium.history.audit.BAuditHistoryService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"history.png");
        lex = Lexicon.make((String)"history");
        serviceTypes = new Type[]{TYPE};
    }
}

