/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.log.BLogHistoryService;
import java.io.DataInput;
import javax.baja.agent.BIAgent;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.io.BIEncodable;
import javax.baja.io.ByteBuffer;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDataRecoveryHistoryRecorder
extends BObject
implements BIAgent,
HistoryEventListener {
    public static final Type TYPE;
    protected static final byte[] EMPTY_DATA;
    public static final Log LOG;
    private BIDataRecoveryService dataRecoveryService;
    private BLogHistoryService logHistoryService;
    private BHistorySpace db;
    static /* synthetic */ Class class$com$tridium$history$BDataRecoveryHistoryRecorder;

    public Type getType() {
        return TYPE;
    }

    public final void setDataRecoveryService(BIDataRecoveryService bIDataRecoveryService) {
        this.dataRecoveryService = bIDataRecoveryService;
    }

    public final BIDataRecoveryService getDataRecoveryService() {
        return this.dataRecoveryService;
    }

    public final void setHistorySpace(BHistorySpace bHistorySpace) {
        this.db = bHistorySpace;
    }

    public final BHistorySpace getHistorySpace() {
        return this.db;
    }

    public final void setLogHistoryService(BLogHistoryService bLogHistoryService) {
        this.logHistoryService = bLogHistoryService;
    }

    public final BLogHistoryService getLogHistoryService() {
        return this.logHistoryService;
    }

    public void historyEvent(BHistoryEvent bHistoryEvent) {
        try {
            if (this.isEventCritical(bHistoryEvent)) {
                if (LOG.isTraceOn()) {
                    LOG.trace("Recording history event " + (Object)((Object)bHistoryEvent));
                }
                this.dataRecoveryService.append((BIDataRecoverySource)this.db, (BIEncodable)BHistoryEvent.makeShorthand(bHistoryEvent, true), EMPTY_DATA);
            }
        }
        catch (DataRecoveryServiceInFaultException dataRecoveryServiceInFaultException) {
            try {
                ((BHistoryDatabase)this.db).removeHistoryEventListener(this);
            }
            catch (Throwable throwable) {}
            LOG.warning("DataRecoveryService in fault, could not append history event " + (Object)((Object)bHistoryEvent) + ". Stopped data recovery history recording.", (Throwable)dataRecoveryServiceInFaultException);
        }
        catch (Throwable throwable) {
            LOG.error("Could not append history event to the DataRecoveryService, event " + (Object)((Object)bHistoryEvent), throwable);
        }
    }

    public boolean restore(BHistorySpace bHistorySpace, IDataRecoveryRecord iDataRecoveryRecord) throws Exception {
        BHistoryEvent bHistoryEvent = BHistoryEvent.makeDbSaved();
        BHistoryEvent bHistoryEvent2 = null;
        try {
            byte[] byArray = iDataRecoveryRecord.getKey();
            ByteBuffer byteBuffer = new ByteBuffer(byArray);
            bHistoryEvent2 = (BHistoryEvent)bHistoryEvent.decode((DataInput)byteBuffer);
            if (LOG.isTraceOn()) {
                LOG.trace("Restoring history event " + (Object)((Object)bHistoryEvent2));
            }
            switch (bHistoryEvent2.getId()) {
                case 0: {
                    BHistoryConfig bHistoryConfig = bHistoryEvent2.getConfig();
                    if (bHistoryConfig != null) {
                        try {
                            bHistorySpace.createHistory(bHistoryConfig);
                        }
                        catch (DuplicateHistoryException duplicateHistoryException) {
                            if (LOG.isTraceOn()) {
                                LOG.trace("History already exists, could not restore history creation event " + (Object)((Object)bHistoryEvent2), (Throwable)((Object)duplicateHistoryException));
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    bHistorySpace.deleteHistory(bHistoryEvent2.getHistoryId(), null);
                    break;
                }
                case 2: {
                    BIHistory bIHistory = bHistorySpace.getHistory(bHistoryEvent2.getHistoryId());
                    BAbsTime bAbsTime = bIHistory.getLastTimestamp();
                    BIHistoryRecordSet bIHistoryRecordSet = bHistoryEvent2.getRecordSet();
                    if (bAbsTime == null || bAbsTime.isNull()) {
                        bIHistory.append(bIHistoryRecordSet);
                        break;
                    }
                    int n = bIHistoryRecordSet.getRecordCount();
                    int n2 = 0;
                    while (n2 < n) {
                        BHistoryRecord bHistoryRecord = bIHistoryRecordSet.getRecord(n2);
                        if (bHistoryRecord.getTimestamp().isAfter(bAbsTime)) {
                            bIHistory.append(bHistoryRecord);
                        }
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    bHistorySpace.getHistory(bHistoryEvent2.getHistoryId()).update((BHistoryRecord)bHistoryEvent2.getRecordSet(), null);
                    break;
                }
                case 4: {
                    bHistorySpace.clearAllRecords(bHistoryEvent2.getHistoryId(), null);
                    break;
                }
                case 5: {
                    bHistorySpace.clearOldRecords(bHistoryEvent2.getHistoryId(), bHistoryEvent2.getClearOldTime(), null);
                    break;
                }
                case 6: {
                    bHistorySpace.renameHistory(bHistoryEvent2.getHistoryId(), bHistoryEvent2.getNewHistoryName());
                    break;
                }
                case 7: {
                    ((BHistoryDatabase)bHistorySpace).resizeHistory(bHistoryEvent2.getHistoryId(), bHistoryEvent2.getCapacity(), bHistoryEvent2.getFullPolicy());
                    break;
                }
                case 12: {
                    ((BHistoryDatabase)bHistorySpace).setConfig(bHistoryEvent2.getConfig());
                    break;
                }
                default: {
                    LOG.error("DataRecoveryService could not restore unexpected history event '" + (Object)((Object)bHistoryEvent2) + '\'');
                    return false;
                }
            }
        }
        catch (Exception exception) {
            if (bHistoryEvent2 != null) {
                LOG.error("DataRecoveryService could not restore history event " + bHistoryEvent2, (Throwable)exception);
            } else {
                LOG.error("DataRecoveryService could not restore null history event", (Throwable)exception);
            }
            throw exception;
        }
        return true;
    }

    protected boolean isEventCritical(BHistoryEvent bHistoryEvent) {
        switch (bHistoryEvent.getId()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                BHistoryId bHistoryId = null;
                try {
                    bHistoryId = this.logHistoryService.getHistoryConfig().getId();
                }
                catch (Throwable throwable) {
                    bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), "LogHistory");
                }
                return bHistoryEvent.getHistoryId().equals((Object)bHistoryId) ^ true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$history$BDataRecoveryHistoryRecorder;
        if (clazz == null) {
            clazz = class$com$tridium$history$BDataRecoveryHistoryRecorder = BDataRecoveryHistoryRecorder.class("[Lcom.tridium.history.BDataRecoveryHistoryRecorder;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        EMPTY_DATA = new byte[0];
        LOG = Log.getLog((String)"history.dataRecovery");
    }
}

