/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.npsdk;

import com.tridium.platSerial.BSerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSerialPortNpsdk
extends BSerialPort {
    public static final Type TYPE;
    private static String STATION_PREFIX;
    private static String _TEMP_DIRECTORY;
    private boolean ownerInit;
    private int fd;
    private BBaudRate baudrate;
    private BSerialDataBits databits;
    private BSerialStopBits stopbits;
    private BSerialParity parity;
    private BSerialFlowControlMode flowControl;
    private int rcvThreshold;
    private int rcvTimeout;
    static /* synthetic */ Class class$com$tridium$platSerial$npsdk$BSerialPortNpsdk;

    public Type getType() {
        return TYPE;
    }

    private final String getLockFileName() {
        return _TEMP_DIRECTORY + File.separatorChar + "niagara-ser" + this.getPortIndex() + ".owner";
    }

    public synchronized void lock(String string) throws PortNotFoundException, PortDeniedException {
        this.checkOwner();
        log.trace("Attempting to lock " + this.getName() + " for owner " + string);
        if (!"none".equalsIgnoreCase(this.getOwner())) {
            throw new PortDeniedException("Unabled to create lock for " + this.getName() + " for owner " + string + ", already owned by " + this.getOwner());
        }
        this.setOwner(string);
        this.locked = true;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getLockFileName());
            fileOutputStream.write((STATION_PREFIX + string).getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.setOwner("none");
            this.locked = false;
            throw new PortDeniedException("Unable to create lock for " + this.getName() + " for owner " + string + ": " + exception.getMessage());
        }
        log.trace(this.getName() + " locked for owner " + string);
    }

    public synchronized void unlock() throws PortDeniedException {
        log.trace("Attempting to unlock " + this.getName() + " as " + this.getOwner());
        if (!this.locked) {
            throw new PortDeniedException("Unable to unlock " + this.getName() + ", " + this.getOwner() + " does not have the port lock");
        }
        File file = new File(this.getLockFileName());
        if (file.exists() && !file.delete()) {
            throw new PortDeniedException("Unable to unlock " + this.getName() + ", failed to delete " + this.getLockFileName());
        }
        this.setOwner("none");
        this.locked = false;
        log.trace(this.getName() + " unlocked");
    }

    public synchronized void initOwner() {
        try {
            File file = new File(this.getLockFileName());
            String string = null;
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                StringBuffer stringBuffer = new StringBuffer();
                int n = fileInputStream.read();
                while (n != -1) {
                    stringBuffer.append((char)n);
                    n = fileInputStream.read();
                }
                fileInputStream.close();
                string = stringBuffer.toString();
            }
            if (string != null && string.startsWith(STATION_PREFIX)) {
                log.trace("Cleaning up old lock file " + this.getLockFileName() + ", old owner: " + string);
                if (file.exists() && !file.delete()) {
                    log.error("Failed to clean up old lock file " + this.getLockFileName() + " could not delete lock file");
                    this.setOwner(string);
                    this.locked = true;
                    return;
                }
                this.setOwner("none");
                this.locked = false;
            } else if (string == null) {
                this.setOwner("none");
                this.locked = false;
            } else {
                log.trace("Can not initialize owner of " + this.getName() + ", port already owned by " + string + ", lock file " + this.getLockFileName());
                this.setOwner(string);
                this.locked = true;
            }
        }
        catch (Exception exception) {
            log.error("Problem reading lock file for " + this.getName(), (Throwable)exception);
        }
    }

    public synchronized void checkOwner() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getLockFileName());
            StringBuffer stringBuffer = new StringBuffer();
            int n = fileInputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = fileInputStream.read();
            }
            fileInputStream.close();
            this.locked = true;
            this.setOwner(stringBuffer.toString());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            log.error("Problem reading lock file " + this.getLockFileName() + " for " + this.getName() + " defaulting to no ownership", (Throwable)exception);
        }
        this.locked = false;
        this.setOwner("none");
    }

    protected void openPort() {
        log.trace("Opening " + this.getOsPortName() + "...");
        this.fd = this.open0(this.getOsPortName());
        log.trace("Port " + this.getOsPortName() + " is open, file descriptor is " + this.fd);
    }

    protected void closePort() {
        log.trace("Closing " + this.getOsPortName() + ", file descriptor is " + this.fd + "...");
        if (this.fd > 0) {
            this.close0(this.fd);
            this.fd = 0;
            log.trace("Port " + this.getOsPortName() + " is closed");
        } else {
            log.trace("Can not close port " + this.getOsPortName() + " invalid file descriptor");
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Can not obtain input stream, invalid file descriptor " + this.fd);
        }
        return new SerialInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Can not obtain output stream, invalid file descriptor " + this.fd);
        }
        return new SerialOutputStream();
    }

    public void enableReceiveThreshold(int n) throws UnsupportedOperationException {
        if (n <= 0) {
            throw new UnsupportedOperationException("Threshold must be >= 1");
        }
        this.rcvThreshold = n;
    }

    public void disableReceiveThreshold() {
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        boolean bl = false;
        if (this.rcvThreshold >= 0) {
            bl = true;
        }
        return bl;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedOperationException {
        this.rcvTimeout = n;
    }

    public void disableReceiveTimeout() {
        this.rcvTimeout = -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        boolean bl = false;
        if (this.rcvTimeout >= 0) {
            bl = true;
        }
        return bl;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    public BBaudRate getBaudRate() {
        return this.baudrate;
    }

    public BSerialDataBits getDataBits() {
        return this.databits;
    }

    public BSerialStopBits getStopBits() {
        return this.stopbits;
    }

    public BSerialParity getParity() {
        return this.parity;
    }

    public void sendBreak(int n) {
        if (this.fd <= 0) {
            return;
        }
        this.sendBreak0(this.fd, n);
    }

    public void setFlowControlMode(BSerialFlowControlMode bSerialFlowControlMode) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        if (bSerialFlowControlMode != BSerialFlowControlMode.none && bSerialFlowControlMode != BSerialFlowControlMode.rtsCtsOnInput && bSerialFlowControlMode != BSerialFlowControlMode.rtsCtsOnOutput && bSerialFlowControlMode != BSerialFlowControlMode.xonXoffOnInput && bSerialFlowControlMode != BSerialFlowControlMode.xonXoffOnOutput) {
            throw new UnsupportedOperationException("Invalid flow control mode.");
        }
        this.setFlowControlMode0(this.fd, bSerialFlowControlMode.getBits());
        this.flowControl = bSerialFlowControlMode;
    }

    public BSerialFlowControlMode getFlowControlMode() {
        return this.flowControl;
    }

    public void setSerialPortParams(BBaudRate bBaudRate, BSerialDataBits bSerialDataBits, BSerialStopBits bSerialStopBits, BSerialParity bSerialParity) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        this.setSerialPortParams0(this.fd, bBaudRate.getOrdinal(), bSerialDataBits.getOrdinal(), bSerialStopBits.getOrdinal(), bSerialParity.getOrdinal());
        this.baudrate = bBaudRate;
        this.databits = bSerialDataBits;
        this.stopbits = bSerialStopBits;
        this.parity = bSerialParity;
    }

    public void setDTR(boolean bl) {
        if (this.fd <= 0) {
            return;
        }
        this.setDTR0(this.fd, bl);
    }

    public boolean isDTR() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isDTR0(this.fd);
    }

    public void setRTS(boolean bl) {
        if (this.fd <= 0) {
            return;
        }
        this.setRTS0(this.fd, bl);
    }

    public boolean isRTS() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isRTS0(this.fd);
    }

    public boolean isCTS() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isCTS0(this.fd);
    }

    public boolean isDSR() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isDSR0(this.fd);
    }

    public boolean isRI() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isRI0(this.fd);
    }

    public boolean isCD() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isCD0(this.fd);
    }

    private final native int open0(String var1);

    private final native int available0(int var1);

    private final native void close0(int var1);

    private final native int read0(int var1, int var2);

    private final native int read0(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    private final native void write0(int var1, int var2);

    private final native void write0(int var1, byte[] var2, int var3, int var4);

    private final native void flush0(int var1);

    private final native void setSerialPortParams0(int var1, int var2, int var3, int var4, int var5);

    private final native boolean isCD0(int var1);

    private final native boolean isCTS0(int var1);

    private final native boolean isDSR0(int var1);

    private final native boolean isDTR0(int var1);

    private final native boolean isRI0(int var1);

    private final native boolean isRTS0(int var1);

    private final native void setFlowControlMode0(int var1, int var2);

    private final native void setRTS0(int var1, boolean var2);

    private final native void setDTR0(int var1, boolean var2);

    private final native void sendBreak0(int var1, int var2);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ownerInit = false;
        this.fd = 0;
        this.baudrate = BSerialBaudRate.baud9600;
        this.databits = BSerialDataBits.dataBits8;
        this.stopbits = BSerialStopBits.stopBit1;
        this.parity = BSerialParity.none;
        this.flowControl = BSerialFlowControlMode.none;
        this.rcvThreshold = -1;
        this.rcvTimeout = -1;
    }

    public BSerialPortNpsdk() {
        this.this();
    }

    public BSerialPortNpsdk(String string, int n) {
        this.this();
        this.setOsPortName(string);
        this.setPortIndex(n);
        this.initOwner();
    }

    static {
        Class clazz = class$com$tridium$platSerial$npsdk$BSerialPortNpsdk;
        if (clazz == null) {
            clazz = class$com$tridium$platSerial$npsdk$BSerialPortNpsdk = BSerialPortNpsdk.class("[Lcom.tridium.platSerial.npsdk.BSerialPortNpsdk;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        STATION_PREFIX = "station:";
        _TEMP_DIRECTORY = System.getProperty("java.io.tmpdir", "/tmp");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SerialInputStream
    extends InputStream {
        boolean closed;

        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            int n = BSerialPortNpsdk.this.available0(BSerialPortNpsdk.this.fd);
            if (n < 0) {
                throw new IOException("Unable to read available bytes");
            }
            return n;
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            return BSerialPortNpsdk.this.read0(BSerialPortNpsdk.this.fd, BSerialPortNpsdk.this.rcvTimeout);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            return BSerialPortNpsdk.this.read0(BSerialPortNpsdk.this.fd, BSerialPortNpsdk.this.rcvTimeout, BSerialPortNpsdk.this.rcvThreshold, byArray, n, n2);
        }

        public void close() throws IOException {
            this.closed = true;
        }

        private final /* synthetic */ void this() {
            this.closed = false;
        }

        SerialInputStream() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SerialOutputStream
    extends OutputStream {
        boolean closed;

        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortNpsdk.this.write0(BSerialPortNpsdk.this.fd, n);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortNpsdk.this.write0(BSerialPortNpsdk.this.fd, byArray, n, n2);
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortNpsdk.this.flush0(BSerialPortNpsdk.this.fd);
        }

        public void close() throws IOException {
            this.closed = true;
        }

        private final /* synthetic */ void this() {
            this.closed = false;
        }

        SerialOutputStream() {
            this.this();
        }
    }
}

