/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.xml;

import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import java.io.InputStream;
import java.util.Comparator;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.SortUtil;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XWirelessTstatFile {
    private static final String THERMOSTAT_SECTION = "thermostats";
    private static final String MODEL_NUMBER_SECTION = "modelnumber";
    private static final String MIN_FIRMWARE_VERSION_SECTION = "minfirmware";
    private static final String MAX_FIRMWARE_VERSION_SECTION = "maxfirmware";
    private static final String MODEL_SECTION = "model";
    private static XElem xmlData;
    private static final BDynamicEnum unknownDynEnum;
    private static final String[] unknownStringArray;
    private static final int[] unknownIntArray;
    private static final int unknownModelNumber = -1;
    private static final String unknownString = "Unknown";
    private static final XElem[] unknownPointList;
    private static final Lexicon lex;
    private static final String moduleName = "wirelessTstatDevices";
    private static final String TSTAT_FILE_NAME = "TstatModels.xml";
    private static String databasePathName;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
    static /* synthetic */ Class class$javax$baja$sys$BInteger;
    static /* synthetic */ Class class$java$lang$String;

    public static void loadFile() {
        try {
            BIFile bIFile = (BIFile)BOrd.make((String)databasePathName).resolve().get();
            InputStream inputStream = bIFile.getInputStream();
            xmlData = XParser.make((InputStream)inputStream).parse();
            bIFile = null;
            inputStream = null;
            return;
        }
        catch (UnresolvedException unresolvedException) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlFile", new Object[]{databasePathName}), unresolvedException);
            unresolvedException.printStackTrace();
        }
        catch (XException xException) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.malformedXml", new Object[]{databasePathName}), xException);
            xException.printStackTrace();
        }
        catch (Exception exception) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}), exception);
            exception.printStackTrace();
        }
        Object var0_1 = null;
        Object var1_3 = null;
    }

    public static String getModelNameFromModelNumber(int n) {
        if (xmlData == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return unknownString;
        }
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return unknownString;
        }
        int n2 = 0;
        while (n2 < xElem.elems().length) {
            if (xElem.elems()[n2].get(MODEL_NUMBER_SECTION).equals(Integer.toString(n))) {
                String string = xElem.elems()[n2].get(MODEL_SECTION);
                if (string != null) {
                    return string;
                }
                WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{MODEL_SECTION}));
                return unknownString;
            }
            ++n2;
        }
        return unknownString;
    }

    public static int getModelNumberFromModelName(String string) {
        if (xmlData == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return -1;
        }
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return -1;
        }
        int n = 0;
        while (n < xElem.elems().length) {
            String string2 = xElem.elems()[n].get(MODEL_SECTION);
            if (string2 == null) {
                return -1;
            }
            if (string2.equals(string)) {
                String string3 = xElem.elems()[n].get(MODEL_NUMBER_SECTION);
                if (string3 != null) {
                    try {
                        return Integer.valueOf(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return -1;
                    }
                }
                WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{MODEL_NUMBER_SECTION}));
                return -1;
            }
            ++n;
        }
        return -1;
    }

    public static int[] getModelNumberList() {
        Object object;
        if (xmlData == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return unknownIntArray;
        }
        Class clazz = class$javax$baja$sys$BInteger;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BInteger = XWirelessTstatFile.class("[Ljavax.baja.sys.BInteger;", false);
        }
        Array array = new Array(clazz);
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return unknownIntArray;
        }
        int n = 0;
        while (n < xElem.elems().length) {
            object = xElem.elems()[n].get(MODEL_NUMBER_SECTION);
            array.add((Object)BInteger.make((String)object));
            ++n;
        }
        BInteger[] bIntegerArray = (BInteger[])array.trim();
        object = new int[bIntegerArray.length];
        int n2 = 0;
        while (n2 < bIntegerArray.length) {
            object[n2] = bIntegerArray[n2].getInt();
            ++n2;
        }
        return object;
    }

    public static String[] getModelNameList() {
        if (xmlData == null) {
            System.out.println("XML data is null");
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return unknownStringArray;
        }
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = XWirelessTstatFile.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return unknownStringArray;
        }
        int n = 0;
        while (n < xElem.elems().length) {
            String string = xElem.elems()[n].get(MODEL_SECTION);
            array.add((Object)string);
            ++n;
        }
        return (String[])array.trim();
    }

    public static BDynamicEnum getModelEnumRange() {
        Object[] objectArray;
        if (xmlData == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return unknownDynEnum;
        }
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = XWirelessTstatFile.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$javax$baja$sys$BInteger;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$sys$BInteger = XWirelessTstatFile.class("[Ljavax.baja.sys.BInteger;", false);
        }
        Array array2 = new Array(clazz2);
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return unknownDynEnum;
        }
        int n = 0;
        while (n < xElem.elems().length) {
            objectArray = xElem.elems()[n].get(MODEL_SECTION);
            int n2 = Integer.valueOf(xElem.elems()[n].get(MODEL_NUMBER_SECTION));
            array.add((Object)objectArray);
            array2.add((Object)BInteger.make((int)n2));
            ++n;
        }
        Object[] objectArray2 = (BInteger[])array2.trim();
        objectArray = (String[])array.trim();
        Object[] objectArray3 = (String[])objectArray.clone();
        SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)SortUtil.ASCENDING);
        SortUtil.sort((Object[])objectArray3, (Object[])objectArray2, (Comparator)SortUtil.ASCENDING);
        int[] nArray = new int[objectArray2.length];
        int n3 = 0;
        while (n3 < objectArray2.length) {
            nArray[n3] = objectArray2[n3].getInt();
            ++n3;
        }
        BDynamicEnum bDynamicEnum = BDynamicEnum.make((BEnum)BEnumRange.make((int[])nArray, (String[])objectArray).get(nArray[0]));
        return bDynamicEnum;
    }

    public static XElem[] getPointListFromModelNumber(int n) {
        if (xmlData == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return unknownPointList;
        }
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return unknownPointList;
        }
        int n2 = 0;
        while (n2 < xElem.elems().length) {
            if (Integer.valueOf(xElem.elems()[n2].get(MODEL_NUMBER_SECTION)) == n) {
                XElem[] xElemArray = xElem.elems()[n2].elems();
                return xElemArray;
            }
            ++n2;
        }
        return unknownPointList;
    }

    public static XElem[] getPointListFromModelNumberAndVersion(int n, int n2) {
        if (xmlData == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.noXmlData", new Object[]{databasePathName}));
            return unknownPointList;
        }
        XElem xElem = xmlData.elem(THERMOSTAT_SECTION);
        if (xElem == null) {
            WirelessTstatToolkit.error(lex.getText("XWirelessTstatFile.missingSectionInXml", new Object[]{THERMOSTAT_SECTION}));
            return unknownPointList;
        }
        int n3 = 0;
        while (n3 < xElem.elems().length) {
            if (Integer.valueOf(xElem.elems()[n3].get(MODEL_NUMBER_SECTION)) == n) {
                int n4 = Integer.valueOf(xElem.elems()[n3].get(MIN_FIRMWARE_VERSION_SECTION, "0"));
                int n5 = Integer.valueOf(xElem.elems()[n3].get(MAX_FIRMWARE_VERSION_SECTION, "255"));
                if (n2 >= n4 && n2 <= n5) {
                    XElem[] xElemArray = xElem.elems()[n3].elems();
                    return xElemArray;
                }
            }
            ++n3;
        }
        return unknownPointList;
    }

    public static String getDatabasePathName() {
        return databasePathName;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public XWirelessTstatFile() {
        XWirelessTstatFile.loadFile();
    }

    static {
        unknownDynEnum = BDynamicEnum.make((BEnum)BEnumRange.make((int[])new int[]{-1}, (String[])new String[]{unknownString}).get(-1));
        unknownStringArray = new String[]{unknownString};
        unknownIntArray = new int[]{-1};
        unknownPointList = new XElem[0];
        Class clazz = class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$BWirelessTstatNetwork = XWirelessTstatFile.class("[Lcom.viconics.wirelessTstat.BWirelessTstatNetwork;", false);
        }
        lex = Lexicon.make((Class)clazz);
        databasePathName = "local:|module://wirelessTstatDevices/com/viconics/wirelessTstatDevices/xml/TstatModels.xml";
    }
}

