/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBitString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BConfigStatus
extends BBitString {
    public static final int INVALID_COMM = 1;
    public static final int DUPLICATE_COMM = 2;
    public static final int DUPLICATE_ZIGBEE = 4;
    public static final int DUPLICATE_IEEE = 8;
    public static final int MODEL_MISMATCH = 16;
    public static final int ZIGBEE_MISMATCH = 32;
    public static final int IEEE_MISMATCH = 64;
    public static final BConfigStatus ok = new BConfigStatus(0, BFacets.NULL);
    public static final BConfigStatus duplicateComm = new BConfigStatus(2, BFacets.NULL);
    public static final BConfigStatus invalidComm = new BConfigStatus(1, BFacets.NULL);
    public static final BConfigStatus duplicateZigbee = new BConfigStatus(4, BFacets.NULL);
    public static final BConfigStatus duplicateIEEE = new BConfigStatus(8, BFacets.NULL);
    public static final BConfigStatus modelMismatch = new BConfigStatus(16, BFacets.NULL);
    public static final BConfigStatus zigbeeMismatch = new BConfigStatus(32, BFacets.NULL);
    public static final BConfigStatus ieeeMismatch = new BConfigStatus(64, BFacets.NULL);
    public static final BConfigStatus DEFAULT = ok;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private static final Lexicon lex;
    private int bits;
    private BFacets facets;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$utils$BConfigStatus;

    public static final BConfigStatus make(int n) {
        return BConfigStatus.make(n, BFacets.NULL);
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, int n) {
        if (bConfigStatus.bits == n) {
            return bConfigStatus;
        }
        return BConfigStatus.make(n, bConfigStatus.facets);
    }

    public static final BConfigStatus make(int n, BFacets bFacets) {
        if (bFacets.isNull()) {
            switch (n) {
                case 0: {
                    return ok;
                }
                case 2: {
                    return duplicateComm;
                }
                case 1: {
                    return invalidComm;
                }
                case 4: {
                    return duplicateZigbee;
                }
                case 8: {
                    return duplicateIEEE;
                }
                case 16: {
                    return modelMismatch;
                }
                case 32: {
                    return zigbeeMismatch;
                }
                case 64: {
                    return ieeeMismatch;
                }
            }
        }
        return new BConfigStatus(n, bFacets);
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, int n, boolean bl) {
        int n2;
        int n3 = n2 = bl ? bConfigStatus.bits | n : bConfigStatus.bits & ~n;
        if (n2 == 0 && bConfigStatus.facets.isNull()) {
            return ok;
        }
        if (bConfigStatus.bits == n2) {
            return bConfigStatus;
        }
        return new BConfigStatus(n2, bConfigStatus.facets);
    }

    public static final BConfigStatus makeDuplicateComm(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 2, bl);
    }

    public static final BConfigStatus makeInvalidComm(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 1, bl);
    }

    public static final BConfigStatus makeDuplicateZigbee(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 4, bl);
    }

    public static final BConfigStatus makeDuplicateIeee(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 8, bl);
    }

    public static final BConfigStatus makeModelMismatch(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 16, bl);
    }

    public static final BConfigStatus makeZigbeeMismatch(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 32, bl);
    }

    public static final BConfigStatus makeIeeeMismatch(BConfigStatus bConfigStatus, boolean bl) {
        return BConfigStatus.make(bConfigStatus, 64, bl);
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, String string, BIDataValue bIDataValue) {
        BFacets bFacets = BFacets.make((BFacets)bConfigStatus.facets, (String)string, (BIDataValue)bIDataValue);
        if (bFacets == bConfigStatus.facets) {
            return bConfigStatus;
        }
        return BConfigStatus.make(bConfigStatus.bits, bFacets);
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, String string, boolean bl) {
        return BConfigStatus.make(bConfigStatus, string, (BIDataValue)BBoolean.make((boolean)bl));
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, String string, int n) {
        return BConfigStatus.make(bConfigStatus, string, (BIDataValue)BInteger.make((int)n));
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, String string, float f) {
        return BConfigStatus.make(bConfigStatus, string, (BIDataValue)BFloat.make((float)f));
    }

    public static final BConfigStatus make(BConfigStatus bConfigStatus, String string, String string2) {
        return BConfigStatus.make(bConfigStatus, string, (BIDataValue)BString.make((String)string2));
    }

    public final BConfigStatus getStatus() {
        return this;
    }

    public final BFacets getFacets() {
        return this.facets;
    }

    public final BObject get(String string) {
        return this.facets.get(string);
    }

    public final boolean getb(String string, boolean bl) {
        return this.facets.getb(string, bl);
    }

    public final int geti(String string, int n) {
        return this.facets.geti(string, n);
    }

    public final long getl(String string, long l) {
        return this.facets.getl(string, l);
    }

    public final float getf(String string, float f) {
        return this.facets.getf(string, f);
    }

    public final double getd(String string, double d) {
        return this.facets.getd(string, d);
    }

    public final String gets(String string, String string2) {
        return this.facets.gets(string, string2);
    }

    public final int getBits() {
        return this.bits;
    }

    public final boolean isValid() {
        boolean bl = false;
        if ((this.bits & 1) == 0 && (this.bits & 2) == 0 && (this.bits & 4) == 0 && (this.bits & 8) == 0 && (this.bits & 0x10) == 0 && (this.bits & 0x20) == 0 && (this.bits & 0x40) == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDuplicate() {
        boolean bl = false;
        if ((this.bits & 4) == 0 && (this.bits & 8) == 0) {
            bl = true;
        }
        return bl ^ true;
    }

    public final boolean isMismatched() {
        boolean bl = false;
        if ((this.bits & 0x10) == 0 && (this.bits & 0x20) == 0 && (this.bits & 0x40) == 0) {
            bl = true;
        }
        return bl ^ true;
    }

    public final boolean isOk() {
        boolean bl = false;
        if (this.bits == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDuplicateComm() {
        boolean bl = false;
        if ((this.bits & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isInvalidComm() {
        boolean bl = false;
        if ((this.bits & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDuplicateZigbee() {
        boolean bl = false;
        if ((this.bits & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDuplicateIEEE() {
        boolean bl = false;
        if ((this.bits & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isModelMismatch() {
        boolean bl = false;
        if ((this.bits & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isZigbeeMismatch() {
        boolean bl = false;
        if ((this.bits & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isIeeeMismatch() {
        boolean bl = false;
        if ((this.bits & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean getBit(int n) {
        boolean bl = false;
        if ((this.bits & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean getBit(String string) {
        return this.getBit(this.tagToOrdinal(string));
    }

    public final int[] getOrdinals() {
        return support.getOrdinals();
    }

    public final boolean isOrdinal(int n) {
        return support.isOrdinal(n);
    }

    public final String getTag(int n) {
        return support.getTag(n);
    }

    public final String getDisplayTag(int n, Context context) {
        return support.getDisplayTag(n, context);
    }

    public final BBitString getInstance(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n |= nArray[n2];
            ++n2;
        }
        return BConfigStatus.make(n);
    }

    public final boolean isTag(String string) {
        return support.isTag(string);
    }

    public final int tagToOrdinal(String string) {
        return support.tagToOrdinal(string);
    }

    public final boolean isEmpty() {
        boolean bl = false;
        if (this.bits == 0) {
            bl = true;
        }
        return bl;
    }

    public final String getEmptyTag() {
        return "ok";
    }

    public final boolean equals(Object object) {
        if (object instanceof BConfigStatus) {
            BConfigStatus bConfigStatus = (BConfigStatus)((Object)object);
            boolean bl = false;
            if (bConfigStatus.bits == this.bits && bConfigStatus.facets.equals((Object)this.facets)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String flagsToString(Context context) {
        if (this.bits == 0) {
            return lex.getText("ConfigStatus.ok");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDuplicateComm()) {
            stringBuffer.append(lex.getText("ConfigStatus.duplicateComm")).append(',');
        }
        if (this.isInvalidComm()) {
            stringBuffer.append(lex.getText("ConfigStatus.invalidComm")).append(',');
        }
        if (this.isDuplicateZigbee()) {
            stringBuffer.append(lex.getText("ConfigStatus.duplicateZigbee")).append(',');
        }
        if (this.isDuplicateIEEE()) {
            stringBuffer.append(lex.getText("ConfigStatus.duplicateIEEE")).append(',');
        }
        if (this.isModelMismatch()) {
            stringBuffer.append(lex.getText("ConfigStatus.modelMismatch")).append(',');
        }
        if (this.isZigbeeMismatch()) {
            stringBuffer.append(lex.getText("ConfigStatus.zigbeeMismatch")).append(',');
        }
        if (this.isIeeeMismatch()) {
            stringBuffer.append(lex.getText("ConfigStatus.ieeeMismatch")).append(',');
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.flagsToString(context));
        if (!this.facets.isNull()) {
            String[] stringArray = this.facets.list();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                BObject bObject = this.facets.get(string);
                if (bObject == BBoolean.TRUE) {
                    stringBuffer.append(' ').append(string);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.bits);
        dataOutput.writeUTF(this.facets.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BConfigStatus.make(dataInput.readInt(), (BFacets)BFacets.NULL.decodeFromString(dataInput.readUTF()));
    }

    public final String encodeToString() throws IOException {
        String string = Integer.toHexString(this.bits);
        if (this.facets.isNull()) {
            return string;
        }
        return string + ';' + this.facets.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = string.indexOf(59);
            if (n < 0) {
                return BConfigStatus.make(Integer.parseInt(string, 16));
            }
            int n2 = Integer.parseInt(string.substring(0, n), 16);
            BFacets bFacets = (BFacets)BFacets.NULL.decodeFromString(string.substring(n + 1));
            return BConfigStatus.make(n2, bFacets);
        }
        catch (Exception exception) {
            throw new IOException("Invalid bits: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BConfigStatus(int n, BFacets bFacets) {
        this.bits = n;
        this.facets = bFacets;
    }

    static {
        support.add(1, "invalidComm");
        support.add(2, "duplicateComm");
        support.add(4, "duplicateZigbee");
        support.add(8, "duplicateIEEE");
        support.add(16, "modelMismatch");
        support.add(32, "zigbeeMismatch");
        support.add(64, "ieeeMismatch");
        Class clazz = class$com$viconics$wirelessTstat$utils$BConfigStatus;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$utils$BConfigStatus = BConfigStatus.class("[Lcom.viconics.wirelessTstat.utils.BConfigStatus;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$viconics$wirelessTstat$utils$BConfigStatus;
        if (clazz2 == null) {
            clazz2 = class$com$viconics$wirelessTstat$utils$BConfigStatus = BConfigStatus.class("[Lcom.viconics.wirelessTstat.utils.BConfigStatus;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

