/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.unsolicited;

import com.tridium.basicdriver.message.Message;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatOutputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatReceivedMessage;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WirelessTstatSignalQualityMsg
extends WirelessTstatReceivedMessage
implements WirelessTstatConst {
    private static final int SIGNAL_QUALITY_PAYLOAD_SIZE = 2;
    public static int POLLED_ONLY = 0;
    public static int COV_COMMPRESSES_DUMP = 1;
    public static int COV_SINGLE_NO_DUMP = 2;
    private int trss;

    public String toString() {
        return "Signal quality msg for comm address " + this.getCommAddress();
    }

    protected byte[] message() {
        WirelessTstatOutputStream wirelessTstatOutputStream = new WirelessTstatOutputStream();
        if (this.getCmdType() == 2) {
            wirelessTstatOutputStream.writeByte(64);
            wirelessTstatOutputStream.writeByte(0);
            wirelessTstatOutputStream.writeWord(4212);
            wirelessTstatOutputStream.writeByte(3);
            wirelessTstatOutputStream.writeByte(this.getCommAddress());
            wirelessTstatOutputStream.writeByte(this.getTransSequence());
            wirelessTstatOutputStream.writeByte(0);
            wirelessTstatOutputStream.writeByte(wirelessTstatOutputStream.getDataCrc());
            wirelessTstatOutputStream.setMsgLength();
            this.getLog().trace("Sending signal quality response to unsolicited message: " + ByteArrayUtil.toHexString((byte[])wirelessTstatOutputStream.toByteArray()));
        }
        return wirelessTstatOutputStream.toByteArray();
    }

    public String description() {
        return "Signal Quality message";
    }

    public int getExpectedDataSize() {
        return 2;
    }

    public String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Unsolicited signal quality message received ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(this.toString());
            stringBuffer.append("\n   From comm address = ");
            stringBuffer.append(this.getCommAddress());
            stringBuffer.append("\n   Point address = 0x");
            stringBuffer.append(Integer.toHexString(this.getMsgType()));
            stringBuffer.append("\n   TRSS value = 0x");
            stringBuffer.append(Integer.toHexString(this.getTrss()));
            stringBuffer.append("\n   CRSS value = 0x");
            stringBuffer.append(Integer.toHexString(this.getLinkQuality()));
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.getTag());
            stringBuffer.append("\n   Response Expected = ");
            stringBuffer.append(this.getResponseExpected());
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.message());
    }

    public void readResponseBody(byte[] byArray, int n) {
        super.readResponseBody(byArray, n);
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.trss = wirelessTstatInputStream.readWordNumber();
        wirelessTstatInputStream = null;
    }

    public int getTrss() {
        return this.lookupTable(this.trss);
    }

    private final /* synthetic */ void this() {
        this.trss = 0;
    }

    public WirelessTstatSignalQualityMsg(byte[] byArray, int n) {
        super(byArray, n);
        this.this();
        this.readResponseBody(this.getPayload(), this.getPayloadSize());
        this.setResponseExpected(false);
        this.setTag(Message.DEFAULT_TAG);
    }
}

