/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.unsolicited;

import com.tridium.basicdriver.message.Message;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatOutputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatReceivedMessage;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WirelessTstatPointWriteMsg
extends WirelessTstatReceivedMessage
implements WirelessTstatConst {
    private static final int POINT_WRITE_RESPONSE_PAYLOAD_SIZE = 2;
    private int pointValue;

    public String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Unsolicited point update received ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(this.toString());
            stringBuffer.append("\n   From comm address = ");
            stringBuffer.append(this.getCommAddress());
            stringBuffer.append("\n   Point address = 0x");
            stringBuffer.append(Integer.toHexString(this.getMsgType()));
            stringBuffer.append("\n   Point value: ");
            stringBuffer.append(this.pointValue);
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.getTag());
            stringBuffer.append("\n   Response Expected = ");
            stringBuffer.append(this.getResponseExpected());
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.message());
    }

    protected byte[] message() {
        WirelessTstatOutputStream wirelessTstatOutputStream = new WirelessTstatOutputStream();
        if (this.getCmdType() == 2) {
            wirelessTstatOutputStream.writeByte(64);
            wirelessTstatOutputStream.writeByte(0);
            wirelessTstatOutputStream.writeWord(this.getMsgType());
            wirelessTstatOutputStream.writeByte(3);
            wirelessTstatOutputStream.writeByte(this.getCommAddress());
            wirelessTstatOutputStream.writeByte(this.getTransSequence());
            wirelessTstatOutputStream.writeByte(0);
            wirelessTstatOutputStream.writeByte(wirelessTstatOutputStream.getDataCrc());
            wirelessTstatOutputStream.setMsgLength();
            this.getLog().trace("Receiving point update from unsolicited message: " + ByteArrayUtil.toHexString((byte[])wirelessTstatOutputStream.toByteArray()));
        }
        return wirelessTstatOutputStream.toByteArray();
    }

    public String description() {
        return "Point write message";
    }

    public int getExpectedDataSize() {
        return 2;
    }

    public void readResponseBody(byte[] byArray, int n) {
        super.readResponseBody(byArray, n);
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.pointValue = wirelessTstatInputStream.readWordNumber();
        wirelessTstatInputStream = null;
    }

    public int getPointValue() {
        return this.pointValue;
    }

    private final /* synthetic */ void this() {
        this.pointValue = 0;
    }

    public WirelessTstatPointWriteMsg(byte[] byArray, int n) {
        super(byArray, n);
        this.this();
        this.readResponseBody(this.getPayload(), this.getPayloadSize());
        this.setResponseExpected(false);
        this.setTag(Message.DEFAULT_TAG);
    }
}

