/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.unsolicited;

import com.tridium.basicdriver.message.Message;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatIEEEAddress;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeAddress;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatOutputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatReceivedMessage;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WirelessTstatIdentifyMsg
extends WirelessTstatReceivedMessage
implements WirelessTstatConst {
    private static final int PING_RESPONSE_PAYLOAD_SIZE = 15;
    private int firmwareNumber;
    private int firmwareVersion;
    private int zbFirmwareNumber;
    private int chipRevision;
    private BWirelessTstatIEEEAddress IEEEAddress;
    private BWirelessTstatZigbeeAddress zigbeeAddress;

    public String toString() {
        return "Identify msg for comm address " + this.getCommAddress();
    }

    public String toDebugString() {
        return "Identify msg for comm address " + this.getCommAddress() + ": " + ByteArrayUtil.toHexString((byte[])this.message());
    }

    protected byte[] message() {
        WirelessTstatOutputStream wirelessTstatOutputStream = new WirelessTstatOutputStream();
        if (this.getCmdType() == 2) {
            wirelessTstatOutputStream.writeByte(64);
            wirelessTstatOutputStream.writeByte(0);
            wirelessTstatOutputStream.writeWord(0);
            wirelessTstatOutputStream.writeByte(3);
            wirelessTstatOutputStream.writeByte(this.getCommAddress());
            wirelessTstatOutputStream.writeByte(this.getTransSequence());
            wirelessTstatOutputStream.writeByte(0);
            wirelessTstatOutputStream.writeByte(wirelessTstatOutputStream.getDataCrc());
            wirelessTstatOutputStream.setMsgLength();
            WirelessTstatToolkit.trace("Sending device identify response to unsolicited message: " + ByteArrayUtil.toHexString((byte[])wirelessTstatOutputStream.toByteArray()));
        }
        return wirelessTstatOutputStream.toByteArray();
    }

    public String description() {
        return "Device identify message";
    }

    public int getExpectedDataSize() {
        return 15;
    }

    public void readResponseBody(byte[] byArray, int n) {
        super.readResponseBody(byArray, n);
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.firmwareNumber = wirelessTstatInputStream.readByteNumber();
        this.firmwareVersion = wirelessTstatInputStream.readByteNumber();
        this.zbFirmwareNumber = wirelessTstatInputStream.readWordNumber();
        this.zigbeeAddress = BWirelessTstatZigbeeAddress.make(wirelessTstatInputStream.readByteArray(2));
        this.IEEEAddress = BWirelessTstatIEEEAddress.make(wirelessTstatInputStream.readByteArray(8));
        this.chipRevision = wirelessTstatInputStream.readByteNumber();
        wirelessTstatInputStream = null;
    }

    public int getThermostatFirmwareNumber() {
        return this.firmwareNumber;
    }

    public int getThermostatFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int getZbFirmwareNumber() {
        return this.zbFirmwareNumber;
    }

    public int getChipRevision() {
        return this.chipRevision;
    }

    public BWirelessTstatIEEEAddress getIEEEAddress() {
        return this.IEEEAddress;
    }

    public BWirelessTstatZigbeeAddress getZigbeeAddress() {
        return this.zigbeeAddress;
    }

    private final /* synthetic */ void this() {
        this.firmwareNumber = 0;
        this.firmwareVersion = 0;
        this.zbFirmwareNumber = 0;
        this.chipRevision = 0;
        this.IEEEAddress = BWirelessTstatIEEEAddress.DEFAULT;
        this.zigbeeAddress = BWirelessTstatZigbeeAddress.DEFAULT;
    }

    public WirelessTstatIdentifyMsg(byte[] byArray, int n) {
        super(byArray, n);
        this.this();
        this.readResponseBody(this.getPayload(), this.getPayloadSize());
        this.setResponseExpected(false);
        this.setTag(Message.DEFAULT_TAG);
    }
}

