/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.viconics.wirelessTstat.BWirelessTstatDevice;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.point.BWirelessTstatPointDeviceExt;
import com.viconics.wirelessTstat.point.scale.BWirelessTstatSerialScale;
import com.viconics.wirelessTstat.utils.GenUtils;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BWirelessTstatProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
WirelessTstatConst {
    private static BFacets SERIAL_SCALE_FACET = BFacets.make((String)"fieldEditor", (String)"wirelessTstat:WirelessTstatSerialScaleFE");
    public static int INVALID_POINT_ADDRESS = 0;
    public static final Property status = BWirelessTstatProxyExt.newProperty((int)67, (BValue)BStatus.stale, null);
    public static final Property pollFrequency = BWirelessTstatProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property address = BWirelessTstatProxyExt.newProperty((int)4, (int)INVALID_POINT_ADDRESS, (BFacets)BFacets.make((String)"radix", (BIDataValue)BInteger.make((int)16)));
    public static final Property scaleFactor = BWirelessTstatProxyExt.newProperty((int)4, (BValue)BWirelessTstatSerialScale.DEFAULT, (BFacets)SERIAL_SCALE_FACET);
    public static final Action forcePoll = BWirelessTstatProxyExt.newAction((int)16, null);
    public static final Type TYPE;
    private int oldAddress;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$point$BWirelessTstatProxyExt;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int n) {
        this.setInt(address, n, null);
    }

    public BWirelessTstatSerialScale getScaleFactor() {
        return (BWirelessTstatSerialScale)this.get(scaleFactor);
    }

    public void setScaleFactor(BWirelessTstatSerialScale bWirelessTstatSerialScale) {
        this.set(scaleFactor, (BValue)bWirelessTstatSerialScale, null);
    }

    public void forcePoll() {
        this.invoke(forcePoll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean requiresPointSubscription() {
        BBoolean bBoolean = (BBoolean)this.get("subscription");
        if (bBoolean != null) {
            return bBoolean.getBoolean();
        }
        return BWirelessTstatNetwork.get().getSubscription();
    }

    public BWirelessTstatPointDeviceExt points() {
        return (BWirelessTstatPointDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        int n = this.getAddress();
        if (n == INVALID_POINT_ADDRESS) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(WirelessTstatToolkit.getText("error.invalidPointAddress"));
            WirelessTstatToolkit.getLog().error(WirelessTstatToolkit.getText("error.invalidPointAddressLong", new Object[]{this.getPoint().getDisplayName(null), this.getDevice().getDisplayName(null), GenUtils.intToHexString(n, 4)}));
            return;
        }
        BWirelessTstatProxyExt bWirelessTstatProxyExt = this.points().lookupPoint(n);
        if (bWirelessTstatProxyExt != null && bWirelessTstatProxyExt != this && bWirelessTstatProxyExt.isMounted()) {
            this.setFaultCause(WirelessTstatToolkit.getText("error.duplicatePointAddress", new Object[]{GenUtils.intToHexString(n, 4), this.getPoint().getDisplayName(null), BInteger.make((int)this.oldAddress)}));
            WirelessTstatToolkit.getLog().error(WirelessTstatToolkit.getText("error.duplicatePointAddress", new Object[]{GenUtils.intToHexString(n, 4), bWirelessTstatProxyExt.getParent().getDisplayName(null), GenUtils.intToHexString(this.oldAddress, 4)}));
            this.set(address, (BValue)BInteger.make((int)this.oldAddress), WirelessTstatConst.fallback);
            return;
        }
        this.setStale(true, null);
        this.setFaultCause("");
        this.points().registerPoint(this);
        this.oldAddress = this.getAddress();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.points().unregisterPoint(this);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || context == WirelessTstatConst.fallback) {
            return;
        }
        if (Context.decoding.equals(context)) {
            return;
        }
        if (address.equals((Object)property)) {
            int n = this.getAddress();
            if (n == INVALID_POINT_ADDRESS) {
                System.out.println("Error occured with context " + context);
                this.setStatus(BStatus.fault);
                this.setFaultCause(WirelessTstatToolkit.getText("error.invalidPointAddress"));
                WirelessTstatToolkit.getLog().error(WirelessTstatToolkit.getText("error.invalidPointAddressLong", new Object[]{this.getPoint().getDisplayName(null), this.getDevice().getDisplayName(null), GenUtils.intToHexString(n, 4)}));
                return;
            }
            BWirelessTstatProxyExt bWirelessTstatProxyExt = this.points().lookupPoint(n);
            if (bWirelessTstatProxyExt != null && bWirelessTstatProxyExt != this) {
                WirelessTstatToolkit.getLog().error(WirelessTstatToolkit.getText("error.duplicatePointAddress", new Object[]{GenUtils.intToHexString(n, 4), bWirelessTstatProxyExt.getParent().getDisplayName(null), GenUtils.intToHexString(this.oldAddress, 4)}));
                this.set(address, (BValue)BInteger.make((int)this.oldAddress), WirelessTstatConst.fallback);
                return;
            }
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
            this.points().updatePoint(this, context);
            bWirelessTstatProxyExt = null;
        }
    }

    public final BWirelessTstatNetwork getWirelessTstatNetwork() {
        return (BWirelessTstatNetwork)this.getNetwork();
    }

    public final BWirelessTstatDevice getWirelessTstatDevice() {
        return (BWirelessTstatDevice)this.getDevice();
    }

    public final BWirelessTstatPointDeviceExt getWirelessTstatPointDeviceExt() {
        return (BWirelessTstatPointDeviceExt)this.getDeviceExt();
    }

    public int getDeviceAddress() {
        return this.getWirelessTstatDevice().getAddress();
    }

    public Type getDeviceExtType() {
        return BWirelessTstatPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public BControlPoint getPoint() {
        return (BControlPoint)this.getParent();
    }

    protected abstract void pollForData();

    public void doForcePoll() {
        this.poll();
    }

    protected boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    protected boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    protected boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    protected boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public abstract void receivedValue(int var1);

    public abstract void poll();

    public void readSubscribed(Context context) throws Exception {
        BWirelessTstatNetwork bWirelessTstatNetwork = (BWirelessTstatNetwork)this.getNetwork();
        if (bWirelessTstatNetwork != null) {
            if (bWirelessTstatNetwork.getPollScheduler().getPollEnabled()) {
                super.readSubscribed(context);
            } else if (bWirelessTstatNetwork.getCovManager().getCovEnabled()) {
                bWirelessTstatNetwork.getCovManager().subscribe((BIPollable)this);
                if (bWirelessTstatNetwork.getLog().isTraceOn()) {
                    bWirelessTstatNetwork.getLog().trace("Queuing point for initial poll before COV <" + this + '>');
                }
            }
        }
    }

    public void readUnsubscribed(Context context) throws Exception {
        super.readUnsubscribed(context);
        BWirelessTstatNetwork bWirelessTstatNetwork = (BWirelessTstatNetwork)this.getNetwork();
        if (bWirelessTstatNetwork != null) {
            bWirelessTstatNetwork.getCovManager().unsubscribe((BIPollable)this);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldAddress = 0;
    }

    public BWirelessTstatProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$point$BWirelessTstatProxyExt;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$point$BWirelessTstatProxyExt = BWirelessTstatProxyExt.class("[Lcom.viconics.wirelessTstat.point.BWirelessTstatProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

