/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.point;

import com.tridium.util.EscUtil;
import com.viconics.wirelessTstat.BWirelessTstatDevice;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.job.BWirelessTstatLearnPointsJob;
import com.viconics.wirelessTstat.point.BWirelessTstatBooleanProxyExt;
import com.viconics.wirelessTstat.point.BWirelessTstatEnumProxyExt;
import com.viconics.wirelessTstat.point.BWirelessTstatNumericProxyExt;
import com.viconics.wirelessTstat.point.BWirelessTstatPointFolder;
import com.viconics.wirelessTstat.point.BWirelessTstatProxyExt;
import com.viconics.wirelessTstat.point.scale.BWirelessTstatSerialScale;
import com.viconics.wirelessTstat.utils.GenUtils;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import com.viconics.wirelessTstat.xml.XWirelessTstatFile;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.TextUtil;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessTstatPointDeviceExt
extends BPointDeviceExt
implements WirelessTstatConst {
    public static final Action submitPointDiscoveryJob = BWirelessTstatPointDeviceExt.newAction((int)4, null);
    public static final Action lookupPointByAddress = BWirelessTstatPointDeviceExt.newAction((int)20, (BValue)BInteger.make((int)BWirelessTstatProxyExt.INVALID_POINT_ADDRESS), null);
    public static final Type TYPE;
    private static final String NAME_MAP = "displayNames";
    private Hashtable byAddress;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$point$BWirelessTstatPointDeviceExt;

    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    public BWirelessTstatProxyExt lookupPointByAddress(BInteger bInteger) {
        return (BWirelessTstatProxyExt)this.invoke(lookupPointByAddress, (BValue)bInteger, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BWirelessTstatNetwork getWirelessTstatNetwork() {
        return (BWirelessTstatNetwork)this.getNetwork();
    }

    public final BWirelessTstatDevice getWirelessTstatDevice() {
        return (BWirelessTstatDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BWirelessTstatDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BWirelessTstatPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BWirelessTstatProxyExt.TYPE;
    }

    public BOrd doSubmitPointDiscoveryJob(Context context) {
        if (this.getDevice().isFatalFault()) {
            return null;
        }
        return new BWirelessTstatLearnPointsJob(this).submit(context);
    }

    public void registerPoint(BWirelessTstatProxyExt bWirelessTstatProxyExt) {
        if (bWirelessTstatProxyExt.getAddress() != 0) {
            this.byAddress.put(BInteger.make((int)bWirelessTstatProxyExt.getAddress()), bWirelessTstatProxyExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterPoint(BWirelessTstatProxyExt bWirelessTstatProxyExt) {
        BWirelessTstatPointDeviceExt bWirelessTstatPointDeviceExt = this;
        synchronized (bWirelessTstatPointDeviceExt) {
            this.byAddress.remove(BInteger.make((int)bWirelessTstatProxyExt.getAddress()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePoint(BWirelessTstatProxyExt bWirelessTstatProxyExt, Context context) {
        BWirelessTstatPointDeviceExt bWirelessTstatPointDeviceExt = this;
        synchronized (bWirelessTstatPointDeviceExt) {
            this.byAddress.values().remove(bWirelessTstatProxyExt);
            this.byAddress.put(BInteger.make((int)bWirelessTstatProxyExt.getAddress()), bWirelessTstatProxyExt);
            return;
        }
    }

    public BWirelessTstatProxyExt lookupPoint(int n) {
        return this.doLookupPointByAddress(BInteger.make((int)n));
    }

    public BWirelessTstatProxyExt doLookupPointByAddress(BInteger bInteger) {
        if (bInteger.getInt() == 0) {
            return null;
        }
        BWirelessTstatProxyExt bWirelessTstatProxyExt = (BWirelessTstatProxyExt)this.byAddress.get(bInteger);
        return bWirelessTstatProxyExt;
    }

    public void installPoints(boolean bl, JobLog jobLog, Context context) {
        if (this.getPoints().length > 0) {
            this.removeAll();
            this.byAddress.clear();
        }
        try {
            int n = this.getWirelessTstatDevice().getThermostatFirmwareNumber();
            this.getWirelessTstatNetwork().getTStatDatabase();
            XElem[] xElemArray = XWirelessTstatFile.getPointListFromModelNumber(n);
            BNameMap bNameMap = BNameMap.NULL;
            BValue bValue = this.get(NAME_MAP);
            if (bValue != null && bValue instanceof BNameMap) {
                bNameMap = (BNameMap)bValue;
            }
            Transaction transaction = this.getComponentSpace().newTransaction(context);
            int n2 = 0;
            while (n2 < xElemArray.length) {
                block13: {
                    if (!bl) {
                        return;
                    }
                    try {
                        String string = xElemArray[n2].get("name");
                        String string2 = xElemArray[n2].get("type", "missing in XML");
                        if (!this.isStandardPoint(string2)) break block13;
                        String string3 = xElemArray[n2].get("scale", "na");
                        String string4 = xElemArray[n2].get("facets", null);
                        String string5 = xElemArray[n2].get("tuningPolicy", "defaultPolicy");
                        int n3 = Integer.parseInt(xElemArray[n2].get("address", "0"), 16);
                        BFacets bFacets = BFacets.NULL;
                        try {
                            bFacets = string4 == null ? BFacets.NULL : GenUtils.facetFtomString(string4);
                        }
                        catch (Exception exception) {
                            jobLog.failed("Invalid facet " + string4 + " for point " + string + " on device " + this.getWirelessTstatDevice().getDisplayName(null));
                        }
                        String string6 = TextUtil.replace((String)string, (String)" ", (String)"");
                        string6 = TextUtil.replace((String)string6, (String)"-", (String)"");
                        string6 = TextUtil.replace((String)string6, (String)"#", (String)"");
                        string6 = TextUtil.replace((String)string6, (String)"/", (String)"");
                        String string7 = EscUtil.slot.unescape(string);
                        bNameMap = BNameMap.make((BNameMap)bNameMap, (String)string6, (String)string7);
                        this.addPointEntry(string6, string2, bFacets, string3, n3, string5, context);
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        WirelessTstatToolkit.error("Exception in BWirelessTstatLearnPointsJob.run() while creating points for pointName", exception);
                    }
                }
                ++n2;
            }
            transaction.commit(context);
            if (bValue != null) {
                if (bValue instanceof BNameMap) {
                    this.set(NAME_MAP, (BValue)bNameMap);
                }
            } else {
                this.add(NAME_MAP, (BValue)bNameMap);
            }
        }
        catch (Exception exception) {
            WirelessTstatToolkit.error("Exception in BWirelessTstatAutoInstallPointsJob.run() while creating points", exception);
        }
    }

    public boolean isStandardPoint(String string) {
        return BBooleanPoint.TYPE.getDisplayName(null).equals(string) || BBooleanWritable.TYPE.getDisplayName(null).equals(string) || BNumericPoint.TYPE.getDisplayName(null).equals(string) || BNumericWritable.TYPE.getDisplayName(null).equals(string) || BEnumPoint.TYPE.getDisplayName(null).equals(string) || BEnumWritable.TYPE.getDisplayName(null).equals(string);
    }

    public void addPointEntry(String string, String string2, BFacets bFacets, String string3, int n, String string4, Context context) throws Exception {
        BNumericWritable bNumericWritable = null;
        if (BNumericWritable.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BNumericWritable();
        } else if (BNumericPoint.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BNumericPoint();
        } else if (BBooleanWritable.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BBooleanWritable();
        } else if (BBooleanPoint.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BBooleanPoint();
        } else if (BStringWritable.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BStringWritable();
        } else if (BStringPoint.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BStringPoint();
        } else if (BEnumWritable.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BEnumWritable();
        } else if (BEnumPoint.TYPE.getDisplayName(null).equals(string2)) {
            bNumericWritable = new BEnumPoint();
        }
        if (bNumericWritable == null) {
            return;
        }
        bNumericWritable.setFacets(bFacets);
        Object object = new BNullProxyExt();
        if (bNumericWritable instanceof BBooleanPoint) {
            object = new BWirelessTstatBooleanProxyExt();
        } else if (bNumericWritable instanceof BNumericPoint) {
            object = new BWirelessTstatNumericProxyExt();
        } else if (bNumericWritable instanceof BEnumPoint) {
            object = new BWirelessTstatEnumProxyExt();
        } else if (bNumericWritable instanceof BStringPoint) {
            throw new RuntimeException("String object not supported");
        }
        if (object instanceof BWirelessTstatProxyExt) {
            BFacets bFacets2 = (BFacets)bNumericWritable.getFacets().newCopy();
            BWirelessTstatProxyExt bWirelessTstatProxyExt = (BWirelessTstatProxyExt)object;
            bWirelessTstatProxyExt.setDeviceFacets(bFacets2);
            bWirelessTstatProxyExt.setAddress(n);
            bWirelessTstatProxyExt.setScaleFactor(BWirelessTstatSerialScale.make(string3));
            bWirelessTstatProxyExt.setTuningPolicyName(string4);
            if (string3.equals("na")) {
                if (string2.indexOf("Numeric") > -1) {
                    bWirelessTstatProxyExt.setScaleFactor(BWirelessTstatSerialScale.make("10;0"));
                } else if (string2.indexOf("Boolean") > -1) {
                    bWirelessTstatProxyExt.setScaleFactor(BWirelessTstatSerialScale.make("1;0"));
                } else if (string2.indexOf("Enum") > -1) {
                    bWirelessTstatProxyExt.setScaleFactor(BWirelessTstatSerialScale.make("1;1"));
                } else {
                    bWirelessTstatProxyExt.setScaleFactor(BWirelessTstatSerialScale.make("10;0"));
                }
            } else {
                bWirelessTstatProxyExt.setScaleFactor(BWirelessTstatSerialScale.make(string3));
            }
        }
        bNumericWritable.setProxyExt((BAbstractProxyExt)object);
        this.add(SlotPath.escape((String)string), (BValue)bNumericWritable);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        if (((BWirelessTstatNetwork)this.getNetwork()).getDebug()) {
            Object[] objectArray;
            Object object;
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Hash Enumeration Table byAddress (" + this.byAddress.size() + ')'), 3);
            spyWriter.w((Object)"<tr>").th((Object)"Key").th((Object)"Address").th((Object)"Point Name").w((Object)"</tr>\n");
            Enumeration enumeration = this.byAddress.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                objectArray = (Object[])this.byAddress.get(object);
                spyWriter.tr((Object)Integer.toHexString(65536 + ((BInteger)object).getInt()).substring(1), (Object)Integer.toHexString(65536 + objectArray.getAddress()).substring(1), (Object)objectArray.getParent().getDisplayName(null));
            }
            spyWriter.endTable();
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Hash Table byAddress (" + this.byAddress.size() + ')'), 2);
            spyWriter.w((Object)"<tr>").th((Object)"Address").th((Object)"Point Name").w((Object)"</tr>\n");
            object = this.byAddress.values();
            objectArray = object.toArray();
            int n = 0;
            while (n < object.size()) {
                BWirelessTstatProxyExt bWirelessTstatProxyExt = (BWirelessTstatProxyExt)objectArray[n];
                spyWriter.tr((Object)Integer.toHexString(65536 + bWirelessTstatProxyExt.getAddress()).substring(1), (Object)bWirelessTstatProxyExt.getParent().getDisplayName(null));
                ++n;
            }
            spyWriter.endTable();
            spyWriter.startTable(true);
            BControlPoint[] bControlPointArray = this.getPoints();
            spyWriter.trTitle((Object)("Device List (" + bControlPointArray.length + ')'), 2);
            spyWriter.w((Object)"<tr>").th((Object)"Address").th((Object)"Name").w((Object)"</tr>\n");
            int n2 = 0;
            while (n2 < bControlPointArray.length) {
                BControlPoint bControlPoint = bControlPointArray[n2];
                spyWriter.tr((Object)Integer.toHexString(65536 + ((BWirelessTstatProxyExt)bControlPoint.getProxyExt()).getAddress()).substring(1), (Object)bControlPoint.getDisplayName(null));
                ++n2;
            }
            spyWriter.endTable();
        }
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byAddress = new Hashtable();
    }

    public BWirelessTstatPointDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$point$BWirelessTstatPointDeviceExt;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$point$BWirelessTstatPointDeviceExt = BWirelessTstatPointDeviceExt.class("[Lcom.viconics.wirelessTstat.point.BWirelessTstatPointDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

