/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.point;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.util.BIBasicPollable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Stack;
import javax.baja.driver.util.BIPollable;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessTstatCovManager
extends BComponent
implements Runnable {
    public static final Property covEnabled = BWirelessTstatCovManager.newProperty((int)0, (boolean)true, null);
    public static final Property statisticsStart = BWirelessTstatCovManager.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property averagePoll = BWirelessTstatCovManager.newProperty((int)323, (String)"-", null);
    public static final Property busyTime = BWirelessTstatCovManager.newProperty((int)323, (String)"-", null);
    public static final Property totalPolls = BWirelessTstatCovManager.newProperty((int)323, (String)"-", null);
    public static final Action resetStatistics = BWirelessTstatCovManager.newAction((int)384, null);
    public static final Action enable = BWirelessTstatCovManager.newAction((int)0, null);
    public static final Action disable = BWirelessTstatCovManager.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final DecimalFormat timeFormat;
    boolean isAlive;
    Thread thread;
    long start;
    long totalPollTime;
    int totalPollCount;
    double average;
    Stack dibs;
    int dibsPollTotal;
    int dibsSizeTotal;
    Object lock;
    int statsCount;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$point$BWirelessTstatCovManager;

    public boolean getCovEnabled() {
        return this.getBoolean(covEnabled);
    }

    public void setCovEnabled(boolean bl) {
        this.setBoolean(covEnabled, bl, null);
    }

    public BAbsTime getStatisticsStart() {
        return (BAbsTime)this.get(statisticsStart);
    }

    public void setStatisticsStart(BAbsTime bAbsTime) {
        this.set(statisticsStart, (BValue)bAbsTime, null);
    }

    public String getAveragePoll() {
        return this.getString(averagePoll);
    }

    public void setAveragePoll(String string) {
        this.setString(averagePoll, string, null);
    }

    public String getBusyTime() {
        return this.getString(busyTime);
    }

    public void setBusyTime(String string) {
        this.setString(busyTime, string, null);
    }

    public String getTotalPolls() {
        return this.getString(totalPolls);
    }

    public void setTotalPolls(String string) {
        this.setString(totalPolls, string, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doEnable() {
        this.setCovEnabled(true);
    }

    public void doDisable() {
        this.setCovEnabled(false);
    }

    public final void poll(BIPollable bIPollable) {
        long l = Clock.ticks();
        try {
            this.doPoll(bIPollable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l2 = Clock.ticks();
        ++this.totalPollCount;
        this.totalPollTime += l2 - l;
        this.average = (double)this.totalPollTime / (double)this.totalPollCount;
    }

    public void doPoll(BIPollable bIPollable) throws Exception {
        BBasicNetwork bBasicNetwork;
        boolean bl = true;
        try {
            bBasicNetwork = (BBasicNetwork)this.getParent();
            boolean bl2 = false;
            if (!(bBasicNetwork.isDisabled() || bBasicNetwork.isDown() || bBasicNetwork.isFault())) {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            return;
        }
        bBasicNetwork = (BIBasicPollable)bIPollable;
        try {
            if (((BBasicNetwork)this.getParent()).getLog().isTraceOn()) {
                ((BBasicNetwork)this.getParent()).getLog().trace("Poll <" + bIPollable + '>');
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            bBasicNetwork.poll();
        }
        catch (NotRunningException notRunningException) {
            notRunningException.printStackTrace();
        }
    }

    public void started() {
        this.startThread();
    }

    public void stopped() {
        this.stopThread();
    }

    public void startThread() {
        this.doResetStatistics();
        this.stopThread();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "Cov:" + this.getParent().getName());
        this.thread.start();
    }

    public void stopThread() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void run() {
        long l = Clock.ticks() + 10000L;
        while (this.isAlive) {
            try {
                if (!this.getCovEnabled()) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.pollDibs();
                long l2 = this.computeSleep();
                if (l2 > 0L) {
                    Thread.sleep(l2);
                }
                if (Clock.ticks() <= l) continue;
                this.updateStats();
                l = Clock.ticks() + 10000L;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void pollDibs() {
        while (true) {
            BIPollable bIPollable = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.dibs.empty()) {
                    return;
                }
                bIPollable = (BIPollable)this.dibs.pop();
                ++this.dibsPollTotal;
            }
            this.poll(bIPollable);
        }
    }

    public void doResetStatistics() {
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.average = 0.0;
        this.statsCount = 0;
        this.dibsPollTotal = 0;
        this.dibsSizeTotal = 0;
        this.start = Clock.ticks();
        this.setStatisticsStart(Clock.time());
        this.updateStats();
    }

    private final void updateStats() {
        long l = Clock.ticks();
        long l2 = l - this.start;
        ++this.statsCount;
        this.setAveragePoll(timeFormat.format(this.average));
        if (this.totalPollTime > 0L) {
            this.setBusyTime((int)(100.0 * ((double)this.totalPollTime / (double)l2)) + "% (" + this.duration(this.totalPollTime) + '/' + this.duration(l2) + ')');
        }
        this.setTotalPolls(this.count(this.totalPollCount) + " over " + this.duration(this.totalPollTime));
    }

    private final String count(int n) {
        if (n < 10000) {
            return String.valueOf(n);
        }
        return String.valueOf(n / 1000) + 'k';
    }

    private final String duration(long l) {
        if (l < 10000L) {
            return String.valueOf(l) + "ms";
        }
        return String.valueOf(l / 1000L) + "sec";
    }

    private final long computeSleep() {
        long l = 1000L;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(BIPollable bIPollable) {
        Object object = this.lock;
        synchronized (object) {
            this.dibs.push(bIPollable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unsubscribe(BIPollable bIPollable) {
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            while (n < this.dibs.size()) {
                if (this.dibs.get(n) == bIPollable) {
                    this.dibs.remove(n);
                    break;
                }
                ++n;
            }
            return false;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dibs = new Stack();
        this.lock = new Object();
    }

    public BWirelessTstatCovManager() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$point$BWirelessTstatCovManager;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$point$BWirelessTstatCovManager = BWirelessTstatCovManager.class("[Lcom.viconics.wirelessTstat.point.BWirelessTstatCovManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"pollService.png");
        timeFormat = new DecimalFormat("0.0#ms");
    }

    static class Bucket {
        Property rateProp;
        ArrayList q = new ArrayList();
        int index;
        long nextTicks;
        int pollTotal;
        int sizeTotal;
        int cycleTotal;

        boolean remove(BIPollable bIPollable) {
            int n = this.q.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.q.get(n2) == bIPollable) {
                    this.q.remove(n2);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        void reset() {
            this.index = 0;
            this.nextTicks = 0L;
            this.pollTotal = 0;
            this.sizeTotal = 0;
            this.cycleTotal = 0;
        }

        Bucket(Property property) {
            this.rateProp = property;
        }
    }
}

