/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatResponse;
import com.viconics.wirelessTstat.messages.WirelessTstatSignalQualityRequest;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WirelessTstatSignalQualityResponse
extends WirelessTstatResponse
implements WirelessTstatConst {
    private static final int POINT_READ_RESPONSE_PAYLOAD_SIZE = 2;
    private final WirelessTstatSignalQualityRequest request;
    private int trss;

    public final String description() {
        return "Point read response";
    }

    public final void readResponseBody(byte[] byArray, int n) {
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(this.getPayload());
        this.trss = wirelessTstatInputStream.readWordNumber();
        wirelessTstatInputStream = null;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.toDebugString());
        }
    }

    public final String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Point read response ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength()));
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.request.getTag());
            stringBuffer.append("\n   Successful Response: ");
            stringBuffer.append(this.getSuccessfulResponse());
            stringBuffer.append("\n   Message status code: ");
            stringBuffer.append(this.getMessageStatusCode());
            stringBuffer.append("\n   Device address = ");
            stringBuffer.append(Integer.toHexString(this.getCommAddress()));
            stringBuffer.append("\n   Point address = ");
            stringBuffer.append(Integer.toHexString(this.getMsgType()));
            stringBuffer.append("\n   TRSS value = 0x");
            stringBuffer.append(Integer.toHexString(this.getTrss()));
            stringBuffer.append("\n   CRSS value = 0x");
            stringBuffer.append(Integer.toHexString(this.getLinkQuality()));
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength());
    }

    public final WirelessTstatSignalQualityRequest getRequest() {
        return this.request;
    }

    public final int getTrss() {
        return this.lookupTable(this.trss);
    }

    public final int getExpectedDataSize() {
        return 2;
    }

    private final /* synthetic */ void this() {
        this.trss = 0;
    }

    public WirelessTstatSignalQualityResponse(WirelessTstatSignalQualityRequest wirelessTstatSignalQualityRequest) {
        this.this();
        this.request = wirelessTstatSignalQualityRequest;
    }
}

