/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.utils.GenUtils;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import javax.baja.log.Log;
import javax.baja.sys.BInteger;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class WirelessTstatResponse
extends ReceivedMessage
implements WirelessTstatConst {
    static Log log = BWirelessTstatNetwork.get().getLog();
    private int msgLength;
    private int msgType;
    private int cmdType;
    private int commAddress;
    private int transSequence;
    private byte[] responseData;
    private int responseDataSize;
    private int linkQuality;
    private int messageStatusCode;
    private int readCrc;
    private byte[] data;
    private boolean isValide;
    int length;

    public void readResponse(byte[] byArray, int n) {
        this.data = byArray;
        this.length = n;
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.msgLength = wirelessTstatInputStream.readByteNumber();
        if (this.msgLength != n - 1) {
            WirelessTstatToolkit.error(this.description() + " has an invalid message size (Expected: " + this.msgLength + " has: " + (n - 1) + ')');
            this.setSuccessfulResponse(false);
            this.setValidResponse(false);
            wirelessTstatInputStream = null;
            return;
        }
        this.msgType = wirelessTstatInputStream.readWordNumber();
        this.cmdType = wirelessTstatInputStream.readByteNumber();
        this.commAddress = wirelessTstatInputStream.readByteNumber();
        this.transSequence = wirelessTstatInputStream.readByteNumber();
        if (this.cmdType == 1 || this.cmdType == 3) {
            this.responseDataSize = this.getMsgLength() - 8;
            this.messageStatusCode = wirelessTstatInputStream.readByteNumber();
        } else {
            this.responseDataSize = this.getMsgLength() - 7;
            this.messageStatusCode = 0;
        }
        this.responseData = wirelessTstatInputStream.readByteArray(this.responseDataSize);
        this.linkQuality = wirelessTstatInputStream.readByteNumber();
        this.readCrc = wirelessTstatInputStream.readByteNumber();
        wirelessTstatInputStream = null;
        int n2 = GenUtils.getPayloadCRC(byArray, 1, n - 2);
        if (this.readCrc != n2) {
            WirelessTstatToolkit.error("description() +   has an invalid CRC (" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n) + ')');
            this.setSuccessfulResponse(false);
            this.setValidResponse(false);
            return;
        }
        if (this.messageStatusCode != 0) {
            this.setSuccessfulResponse(false);
            this.setValidResponse(true);
            return;
        }
        if (this.getExpectedDataSize() != this.responseDataSize) {
            WirelessTstatToolkit.error(this.description() + " has an invalid size (" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n) + ") Expected: " + this.msgLength + " Received: " + (n - 1));
            this.setSuccessfulResponse(false);
            this.setValidResponse(false);
            return;
        }
        this.readResponseBody(this.responseData, this.responseDataSize);
    }

    public abstract void readResponseBody(byte[] var1, int var2);

    public abstract int getExpectedDataSize();

    public abstract String description();

    public int getMsgLength() {
        return this.msgLength;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public int getCmdType() {
        return this.cmdType;
    }

    public int getCommAddress() {
        return this.commAddress;
    }

    public int getTransSequence() {
        return this.transSequence;
    }

    public int getMessageStatusCode() {
        return this.messageStatusCode;
    }

    public byte[] getPayload() {
        return this.responseData;
    }

    public int getLinkQuality() {
        return this.lookupTable(this.linkQuality);
    }

    public int getReadCrc() {
        return this.readCrc;
    }

    public int getPayloadSize() {
        return this.responseDataSize;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public String getErrorString() {
        switch (this.messageStatusCode) {
            case 0: {
                return "No error";
            }
            case 1: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code1");
            }
            case 2: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code2");
            }
            case 3: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code3");
            }
            case 4: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code4");
            }
            case 5: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code5");
            }
            case 6: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code6");
            }
            case 7: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code7");
            }
            case 8: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code8");
            }
            case 9: {
                return WirelessTstatToolkit.getText("wirelessTstatResponse.code9");
            }
        }
        return WirelessTstatToolkit.getText("wirelessTstatResponse.codeOthers", new Object[]{BInteger.make((int)this.messageStatusCode)});
    }

    protected int lookupTable(int n) {
        return WirelessTstatConst.lookUpValues[Math.min(WirelessTstatConst.lookUpValues.length - 1, n)];
    }

    public boolean isValidResponse() {
        return this.isValide;
    }

    public void setValidResponse(boolean bl) {
        this.isValide = bl;
    }

    public Log getLog() {
        return log;
    }

    private final /* synthetic */ void this() {
        this.isValide = false;
    }

    public WirelessTstatResponse() {
        this.this();
    }
}

