/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.utils.GenUtils;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import java.io.OutputStream;
import javax.baja.log.Log;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WirelessTstatReceivedMessage
extends ReceivedMessage
implements WirelessTstatConst {
    static Log log = BWirelessTstatNetwork.get().getLog();
    private boolean isValide;
    private int msgLength;
    private int msgType;
    private int cmdType;
    private int commAddress;
    private int transSequence;
    private int payloadSize;
    private byte[] payload;
    private int linkQuality;
    private int readCrc;
    private byte[] data;
    private int length;
    private int messageStatusCode;

    public void make(byte[] byArray, int n) {
        this.data = byArray;
        this.length = n;
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.msgLength = wirelessTstatInputStream.readByteNumber();
        if (this.msgLength != n - 1) {
            WirelessTstatToolkit.error(this.description() + " has an invalid size (" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n) + ") Expected: " + this.msgLength + " Received: " + (n - 1));
            this.setSuccessfulResponse(false);
            this.setValidResponse(false);
            wirelessTstatInputStream = null;
            return;
        }
        this.msgType = wirelessTstatInputStream.readWordNumber();
        this.cmdType = wirelessTstatInputStream.readByteNumber();
        this.commAddress = wirelessTstatInputStream.readByteNumber();
        this.transSequence = wirelessTstatInputStream.readByteNumber();
        if (this.cmdType == 1 || this.cmdType == 3) {
            this.payloadSize = this.getMsgLength() - 8;
            this.messageStatusCode = wirelessTstatInputStream.readByteNumber();
        } else {
            this.payloadSize = this.getMsgLength() - 7;
            this.messageStatusCode = 0;
        }
        this.payload = wirelessTstatInputStream.readByteArray(this.payloadSize);
        this.linkQuality = wirelessTstatInputStream.readByteNumber();
        this.readCrc = wirelessTstatInputStream.readByteNumber();
        int n2 = GenUtils.getPayloadCRC(byArray, 1, n - 2);
        if (this.readCrc != n2) {
            WirelessTstatToolkit.error(this.description() + " has an invalid CRC (" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n) + ')');
            this.setSuccessfulResponse(false);
            this.setValidResponse(false);
            return;
        }
        this.setSuccessfulResponse(true);
        this.setValidResponse(true);
    }

    public void write(OutputStream outputStream) {
        try {
            outputStream.write(this.message());
        }
        catch (Exception exception) {
            WirelessTstatToolkit.error("Error writing to output stream", exception);
        }
    }

    protected byte[] message() {
        throw new BajaRuntimeException("message() needs to be overriden");
    }

    public boolean isValidResponse() {
        boolean bl = false;
        if (this.isValide && this.messageStatusCode == 0) {
            bl = true;
        }
        return bl;
    }

    public void setValidResponse(boolean bl) {
        this.isValide = bl;
    }

    public String description() {
        return "Unknown message";
    }

    public String toString() {
        return ByteArrayUtil.toHexString((byte[])this.data, (int)0, (int)this.length);
    }

    public int getMsgType() {
        return this.msgType;
    }

    public int getCmdType() {
        return this.cmdType;
    }

    public int getCommAddress() {
        return this.commAddress;
    }

    public int getTransSequence() {
        return this.transSequence;
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getLinkQuality() {
        return this.lookupTable(this.linkQuality);
    }

    public int getReadCrc() {
        return this.readCrc;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void setBytes(byte[] byArray) {
        this.data = byArray;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public Log getLog() {
        return log;
    }

    protected int lookupTable(int n) {
        return WirelessTstatConst.lookUpValues[Math.min(WirelessTstatConst.lookUpValues.length - 1, n)];
    }

    public void readResponseBody(byte[] byArray, int n) {
        if (this.getExpectedDataSize() != n) {
            this.setSuccessfulResponse(false);
            this.setValidResponse(false);
            return;
        }
    }

    public int getExpectedDataSize() {
        throw new BajaRuntimeException("getExpectedDataSize() needs to be overriden");
    }

    public int getMessageStatusCode() {
        return this.messageStatusCode;
    }

    private final /* synthetic */ void this() {
        this.isValide = false;
        this.msgLength = 0;
        this.msgType = 0;
        this.cmdType = 0;
        this.commAddress = 0;
        this.transSequence = 0;
        this.payloadSize = 0;
        this.payload = new byte[0];
        this.linkQuality = 0;
        this.readCrc = 0;
    }

    public WirelessTstatReceivedMessage(byte[] byArray, int n) {
        this.this();
        this.make(byArray, n);
    }
}

