/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatReadNetworkConfigRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatResponse;
import javax.baja.util.ByteArrayUtil;

public final class WirelessTstatReadNetworkConfigResponse
extends WirelessTstatResponse {
    private static final int READ_NETWORK_CONFIG_RESPONSE_PAYLOAD_SIZE = 3;
    private int channel;
    private int panId;
    private final WirelessTstatReadNetworkConfigRequest request;

    public final String description() {
        return "Read network config response";
    }

    public final void readResponseBody(byte[] byArray, int n) {
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(this.getPayload());
        this.panId = wirelessTstatInputStream.readWordNumber();
        this.channel = wirelessTstatInputStream.readByteNumber();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.toDebugString());
        }
    }

    public final String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Read network config response ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength()));
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.request.getTag());
            stringBuffer.append("\n   Successful Response: ");
            stringBuffer.append(this.getSuccessfulResponse());
            stringBuffer.append("\n   Message status code: ");
            stringBuffer.append(this.getMessageStatusCode());
            stringBuffer.append("\n   Channel: ");
            stringBuffer.append(this.getChannel());
            stringBuffer.append("\n   PanId: ");
            stringBuffer.append(this.getPanId());
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength());
    }

    public final int getChannel() {
        return this.channel;
    }

    public final int getPanId() {
        return this.panId;
    }

    public final int getExpectedDataSize() {
        return 3;
    }

    public WirelessTstatReadNetworkConfigResponse(WirelessTstatReadNetworkConfigRequest wirelessTstatReadNetworkConfigRequest) {
        this.request = wirelessTstatReadNetworkConfigRequest;
    }
}

