/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatPointReadRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatResponse;
import javax.baja.util.ByteArrayUtil;

public final class WirelessTstatPointReadResponse
extends WirelessTstatResponse
implements WirelessTstatConst {
    private static final int POINT_READ_RESPONSE_PAYLOAD_SIZE = 2;
    private final WirelessTstatPointReadRequest request;
    private long value;

    public final String description() {
        return "Point read response";
    }

    public final void readResponseBody(byte[] byArray, int n) {
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(this.getPayload());
        this.value = wirelessTstatInputStream.readWordNumber();
        wirelessTstatInputStream = null;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.toDebugString());
        }
    }

    public final boolean getBooleanValue() {
        boolean bl = false;
        if (this.getShortValue() > 0) {
            bl = true;
        }
        return bl;
    }

    public final double getLongValue() {
        return this.value;
    }

    public final float getFloatValue() {
        return this.value;
    }

    public final String getStringValue() {
        return "";
    }

    public final String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Point read response ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength()));
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.request.getTag());
            stringBuffer.append("\n   Successful Response: ");
            stringBuffer.append(this.getSuccessfulResponse());
            stringBuffer.append("\n   Message status code: ");
            stringBuffer.append(this.getMessageStatusCode());
            stringBuffer.append("\n   Device address = ");
            stringBuffer.append(Integer.toHexString(this.getCommAddress()));
            stringBuffer.append("\n   Point address = ");
            stringBuffer.append(Integer.toHexString(this.getMsgType()));
            stringBuffer.append("\n   Point Value = ");
            stringBuffer.append(this.value);
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength());
    }

    public final WirelessTstatPointReadRequest getRequest() {
        return this.request;
    }

    public final long getValue() {
        return (short)(this.value & 0xFFFFL);
    }

    private final short getShortValue() {
        return (short)this.value;
    }

    public final int getExpectedDataSize() {
        return 2;
    }

    public WirelessTstatPointReadResponse(WirelessTstatPointReadRequest wirelessTstatPointReadRequest) {
        this.request = wirelessTstatPointReadRequest;
    }
}

