/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.viconics.wirelessTstat.datatypes.BWirelessTstatIEEEAddress;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeAddress;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatOutputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatPingRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatResponse;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WirelessTstatPingResponse
extends WirelessTstatResponse {
    private static final int PING_RESPONSE_PAYLOAD_SIZE = 15;
    private final WirelessTstatPingRequest request;
    private int firmwareNumber;
    private int firmwareVersion;
    private int zbFirmwareMajNumber;
    private int zbFirmwareMinNumber;
    private int chipRevision;
    private BWirelessTstatIEEEAddress IEEEAddress;
    private BWirelessTstatZigbeeAddress zigbeeAddress;

    public final String description() {
        return "Ping response";
    }

    public final void readResponseBody(byte[] byArray, int n) {
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.firmwareNumber = wirelessTstatInputStream.readByteNumber();
        this.firmwareVersion = wirelessTstatInputStream.readByteNumber();
        this.zbFirmwareMajNumber = wirelessTstatInputStream.readByteNumber();
        this.zbFirmwareMinNumber = wirelessTstatInputStream.readByteNumber();
        this.zigbeeAddress = BWirelessTstatZigbeeAddress.make(wirelessTstatInputStream.readByteArray(2));
        this.IEEEAddress = BWirelessTstatIEEEAddress.make(wirelessTstatInputStream.readByteArray(8));
        this.chipRevision = wirelessTstatInputStream.readByteNumber();
        wirelessTstatInputStream = null;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.toDebugString());
        }
    }

    public final int getExpectedDataSize() {
        return 15;
    }

    public final int getThermostatFirmwareNumber() {
        return this.firmwareNumber;
    }

    public final int getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public final BWirelessTstatIEEEAddress getIEEEAddress() {
        return this.IEEEAddress;
    }

    public final BWirelessTstatZigbeeAddress getZigbeeAddress() {
        return this.zigbeeAddress;
    }

    public final int getZbFirmwareMajNumber() {
        return this.zbFirmwareMajNumber;
    }

    public final int getZbFirmwareMinNumber() {
        return this.zbFirmwareMinNumber;
    }

    public final int getChipRevision() {
        return this.chipRevision;
    }

    public final String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Ping response ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength()));
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.request.getTag());
            stringBuffer.append("\n   Successful Response: ");
            stringBuffer.append(this.getSuccessfulResponse());
            stringBuffer.append("\n   Message status code: ");
            stringBuffer.append(this.getMessageStatusCode());
            stringBuffer.append("\n   MsgLength = ");
            stringBuffer.append(this.getMsgLength());
            stringBuffer.append("\n   Msg Type = 0x");
            stringBuffer.append(Integer.toString(this.getMsgType()));
            stringBuffer.append("\n   Cmd Type = ");
            stringBuffer.append(this.getCmdType());
            stringBuffer.append("\n   Device address = 0x");
            stringBuffer.append(Integer.toHexString(this.getCommAddress()));
            stringBuffer.append("\n   Transaction sequence = 0x");
            stringBuffer.append(Integer.toHexString(this.getTransSequence()));
            stringBuffer.append("\n   Model number = ");
            stringBuffer.append(this.firmwareNumber);
            stringBuffer.append("\n   Model firmware version = ");
            stringBuffer.append(this.firmwareVersion);
            stringBuffer.append("\n   Zigbee firmware maj number = ");
            stringBuffer.append(this.zbFirmwareMajNumber);
            stringBuffer.append("\n   Zigbee firmware min number = ");
            stringBuffer.append(this.zbFirmwareMinNumber);
            stringBuffer.append("\n   Network address = 0x");
            stringBuffer.append(this.zigbeeAddress.toString());
            stringBuffer.append("\n   IEEE address = 0x");
            stringBuffer.append(this.IEEEAddress.toString());
            stringBuffer.append("\n   Chip revision = 0x");
            stringBuffer.append(Integer.toHexString(this.chipRevision));
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.message());
    }

    protected final byte[] message() {
        WirelessTstatOutputStream wirelessTstatOutputStream = new WirelessTstatOutputStream();
        wirelessTstatOutputStream.writeByte(64);
        wirelessTstatOutputStream.writeByte(0);
        wirelessTstatOutputStream.writeWord(0);
        wirelessTstatOutputStream.writeByte(3);
        wirelessTstatOutputStream.writeByte(this.getCommAddress());
        wirelessTstatOutputStream.writeByte(this.getTransSequence());
        wirelessTstatOutputStream.writeByte(0);
        wirelessTstatOutputStream.writeByte(wirelessTstatOutputStream.getDataCrc());
        wirelessTstatOutputStream.setMsgLength();
        return wirelessTstatOutputStream.toByteArray();
    }

    private final /* synthetic */ void this() {
        this.firmwareNumber = 0;
        this.firmwareVersion = 0;
        this.zbFirmwareMajNumber = 0;
        this.zbFirmwareMinNumber = 0;
        this.chipRevision = 0;
        this.IEEEAddress = BWirelessTstatIEEEAddress.DEFAULT;
        this.zigbeeAddress = BWirelessTstatZigbeeAddress.DEFAULT;
    }

    public WirelessTstatPingResponse(WirelessTstatPingRequest wirelessTstatPingRequest) {
        this.this();
        this.request = wirelessTstatPingRequest;
    }

    public WirelessTstatPingResponse() {
        this.this();
        this.request = null;
    }
}

