/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import java.io.ByteArrayOutputStream;

public class WirelessTstatOutputStream
extends ByteArrayOutputStream {
    public void writeByteAsAscii(int n) {
        try {
            this.write(Integer.toHexString((n & 0xF0) >> 4).getBytes());
            this.write(Integer.toHexString(n & 0xF).getBytes());
        }
        catch (Exception exception) {
            System.out.println("Catch exception in writeWordAsAscii");
        }
    }

    public void writeWordAsAscii(int n) {
        try {
            this.write(Integer.toHexString((n & 0xF000) >> 12).getBytes());
            this.write(Integer.toHexString((n & 0xF00) >> 8).getBytes());
            this.write(Integer.toHexString((n & 0xF0) >> 4).getBytes());
            this.write(Integer.toHexString(n & 0xF).getBytes());
        }
        catch (Exception exception) {
            System.out.println("Catch exception in writeByteAsAscii");
        }
    }

    public void writeDoubleAsAscii(double d) {
        this.writeWordAsAscii((int)d);
    }

    public void writeWord(int n) {
        try {
            this.write((n & 0xFF00) >> 8);
            this.write(n & 0xFF);
        }
        catch (Exception exception) {
            System.out.println("Catch exception in writeWord");
            exception.printStackTrace();
        }
    }

    public void writeByte(int n) {
        try {
            this.write(n & 0xFF);
        }
        catch (Exception exception) {
            System.out.println("Catch exception in writeByte");
            exception.printStackTrace();
        }
    }

    public void setMsgLength() {
        this.buf[1] = (byte)(this.size() - 2);
    }

    public int getDataCrc() {
        return this.getDataCrc(2, this.size() - 2);
    }

    public int getDataCrc(int n) {
        return this.getDataCrc(n, this.size() - n);
    }

    public int getDataCrc(int n, int n2) {
        if (this.buf == null) {
            return -1;
        }
        if (this.buf.length == 0) {
            return -1;
        }
        if (n < 0 || n2 < 0 || n >= this.buf.length || n + n2 > this.buf.length) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 += this.buf[n4];
            ++n4;
        }
        return n3 & 0xFF;
    }

    public WirelessTstatOutputStream() {
    }

    public WirelessTstatOutputStream(int n) {
        super(n);
    }
}

