/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.messages;

import com.viconics.wirelessTstat.datatypes.BWirelessTstatIEEEAddress;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeAddress;
import com.viconics.wirelessTstat.messages.WirelessTstatIdentifyRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatInputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatOutputStream;
import com.viconics.wirelessTstat.messages.WirelessTstatResponse;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WirelessTstatIdentifyResponse
extends WirelessTstatResponse {
    private static final int MODULE_IDENTIFY_RESPONSE_PAYLOAD_SIZE = 13;
    private final WirelessTstatIdentifyRequest request;
    private int firmwareMinRevision;
    private int firmwareMajRevision;
    private int chipRevision;
    private BWirelessTstatIEEEAddress IEEEAddress;
    private BWirelessTstatZigbeeAddress zigbeeAddress;

    public final String description() {
        return "FR Module Identify response";
    }

    public final void readResponseBody(byte[] byArray, int n) {
        WirelessTstatInputStream wirelessTstatInputStream = new WirelessTstatInputStream(byArray);
        this.firmwareMajRevision = wirelessTstatInputStream.readByteNumber();
        this.firmwareMinRevision = wirelessTstatInputStream.readByteNumber();
        this.zigbeeAddress = BWirelessTstatZigbeeAddress.make(wirelessTstatInputStream.readByteArray(2));
        this.IEEEAddress = BWirelessTstatIEEEAddress.make(wirelessTstatInputStream.readByteArray(8));
        this.chipRevision = wirelessTstatInputStream.readByteNumber();
        wirelessTstatInputStream = null;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.toDebugString());
        }
    }

    public final int getExpectedDataSize() {
        return 13;
    }

    public final int getModuleMinFirmwareNumber() {
        return this.firmwareMinRevision;
    }

    public final int getModuleMajFirmwareNumber() {
        return this.firmwareMajRevision;
    }

    public final BWirelessTstatIEEEAddress getIEEEAddress() {
        return this.IEEEAddress;
    }

    public final BWirelessTstatZigbeeAddress getZigbeeAddress() {
        return this.zigbeeAddress;
    }

    public final int getChipRevision() {
        return this.chipRevision;
    }

    public final String toDebugString() {
        if (this.getLog().isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n   **** Comm module identify response ****");
            stringBuffer.append("\n   ");
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.getData(), (int)0, (int)this.getLength()));
            stringBuffer.append("\n   Tag = ");
            stringBuffer.append(this.request.getTag());
            stringBuffer.append("\n   Successful Response: ");
            stringBuffer.append(this.getSuccessfulResponse());
            stringBuffer.append("\n   Message status code: ");
            stringBuffer.append(this.getMessageStatusCode());
            stringBuffer.append("\n   MsgLength = ");
            stringBuffer.append(this.getMsgLength());
            stringBuffer.append("\n   Msg Type = 0x");
            stringBuffer.append(Integer.toString(this.getMsgType()));
            stringBuffer.append("\n   Cmd Type = ");
            stringBuffer.append(this.getCmdType());
            stringBuffer.append("\n   Device address = 0x");
            stringBuffer.append(Integer.toHexString(this.getCommAddress()));
            stringBuffer.append("\n   Transaction sequence = 0x");
            stringBuffer.append(Integer.toHexString(this.getTransSequence()));
            stringBuffer.append("\n   Maj rev number = ");
            stringBuffer.append(this.firmwareMajRevision);
            stringBuffer.append("\n   Min rev number = ");
            stringBuffer.append(this.firmwareMinRevision);
            stringBuffer.append("\n   Zigbee Network address = 0x");
            stringBuffer.append(this.zigbeeAddress.toString());
            stringBuffer.append("\n   IEEE address = 0x");
            stringBuffer.append(this.IEEEAddress.toString());
            stringBuffer.append("\n   Chip revision = 0x");
            stringBuffer.append(Integer.toHexString(this.chipRevision));
            stringBuffer.append("\n   **********************");
            return stringBuffer.toString();
        }
        return ByteArrayUtil.toHexString((byte[])this.message());
    }

    protected final byte[] message() {
        WirelessTstatOutputStream wirelessTstatOutputStream = new WirelessTstatOutputStream();
        wirelessTstatOutputStream.writeByte(64);
        wirelessTstatOutputStream.writeByte(0);
        wirelessTstatOutputStream.writeWord(3843);
        wirelessTstatOutputStream.writeByte(1);
        wirelessTstatOutputStream.writeByte(this.getCommAddress());
        wirelessTstatOutputStream.writeByte(this.getTransSequence());
        wirelessTstatOutputStream.writeByte(0);
        wirelessTstatOutputStream.writeByte(wirelessTstatOutputStream.getDataCrc());
        wirelessTstatOutputStream.setMsgLength();
        return wirelessTstatOutputStream.toByteArray();
    }

    private final /* synthetic */ void this() {
        this.firmwareMinRevision = 0;
        this.firmwareMajRevision = 0;
        this.chipRevision = 0;
        this.IEEEAddress = BWirelessTstatIEEEAddress.DEFAULT;
        this.zigbeeAddress = BWirelessTstatZigbeeAddress.DEFAULT;
    }

    public WirelessTstatIdentifyResponse(WirelessTstatIdentifyRequest wirelessTstatIdentifyRequest) {
        this.this();
        this.request = wirelessTstatIdentifyRequest;
    }

    public WirelessTstatIdentifyResponse() {
        this.this();
        this.request = null;
    }
}

