/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.job;

import com.viconics.wirelessTstat.BWirelessTstatLearnPointEntry;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.point.BWirelessTstatPointDeviceExt;
import com.viconics.wirelessTstat.point.scale.BWirelessTstatSerialScale;
import com.viconics.wirelessTstat.utils.GenUtils;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import com.viconics.wirelessTstat.xml.XWirelessTstatFile;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BWirelessTstatLearnPointsJob
extends BSimpleJob
implements WirelessTstatConst {
    public static final Property learnedPoints = BWirelessTstatLearnPointsJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private BWirelessTstatPointDeviceExt ext;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$job$BWirelessTstatLearnPointsJob;

    public final BFolder getLearnedPoints() {
        return (BFolder)this.get(learnedPoints);
    }

    public final void setLearnedPoints(BFolder bFolder) {
        this.set(learnedPoints, (BValue)bFolder, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BDeviceNetwork getNetwork() {
        return this.ext.getNetwork();
    }

    public final BWirelessTstatNetwork getWirelessTstatNetwork() {
        return (BWirelessTstatNetwork)this.ext.getNetwork();
    }

    public final void dispose() {
        try {
            super.dispose();
        }
        catch (ActionInvokeException actionInvokeException) {
            actionInvokeException.printStackTrace();
        }
    }

    public final void run(Context context) throws Exception {
        this.log().message("Learn points job started");
        this.progress(0);
        try {
            int n = this.ext.getWirelessTstatDevice().getThermostatFirmwareNumber();
            this.getWirelessTstatNetwork().getTStatDatabase();
            XElem[] xElemArray = XWirelessTstatFile.getPointListFromModelNumber(n);
            int n2 = 0;
            while (n2 < xElemArray.length) {
                block8: {
                    if (!this.isAlive()) {
                        return;
                    }
                    try {
                        this.progress(100 * (n2 + 1) / (xElemArray.length + 1));
                        String string = xElemArray[n2].get("name");
                        String string2 = xElemArray[n2].get("type", "missing in XML");
                        if (!this.isStandardPoint(string2)) break block8;
                        String string3 = xElemArray[n2].get("scale", "na");
                        String string4 = xElemArray[n2].get("facets", null);
                        String string5 = xElemArray[n2].get("tuningPolicy", "defaultPolicy");
                        int n3 = Integer.parseInt(xElemArray[n2].get("address", "0"), 16);
                        BFacets bFacets = BFacets.NULL;
                        try {
                            bFacets = string4 == null ? BFacets.NULL : GenUtils.facetFtomString(string4);
                        }
                        catch (Exception exception) {
                            this.log().failed("Invalid facet " + string4 + " for " + string);
                        }
                        this.log().message("Found point " + string);
                        this.addPointEntry(string, string2, bFacets, string3, n3, string5);
                    }
                    catch (Exception exception) {
                        WirelessTstatToolkit.error("Exception in BWirelessTstatLearnPointsJob.run() while creating points for pointName", exception);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            WirelessTstatToolkit.error("Exception in BWirelessTstatLearnPointsJob.run() while creating points", exception);
        }
        this.progress(100);
        this.log().message("Learn points job done");
    }

    public final boolean isStandardPoint(String string) {
        return BBooleanPoint.TYPE.getDisplayName(null).equals(string) || BBooleanWritable.TYPE.getDisplayName(null).equals(string) || BNumericPoint.TYPE.getDisplayName(null).equals(string) || BNumericWritable.TYPE.getDisplayName(null).equals(string) || BEnumPoint.TYPE.getDisplayName(null).equals(string) || BEnumWritable.TYPE.getDisplayName(null).equals(string);
    }

    private final void addPointEntry(String string, String string2, BFacets bFacets, String string3, int n, String string4) throws Exception {
        BWirelessTstatLearnPointEntry bWirelessTstatLearnPointEntry = new BWirelessTstatLearnPointEntry();
        bWirelessTstatLearnPointEntry.setPointType(string2);
        bWirelessTstatLearnPointEntry.setPointAddress(n);
        bWirelessTstatLearnPointEntry.setPointName(string);
        bWirelessTstatLearnPointEntry.setPointFacets(bFacets);
        bWirelessTstatLearnPointEntry.setTuningPolicy(string4);
        if (string3.equals("na")) {
            if (string2.indexOf("Numeric") > -1) {
                bWirelessTstatLearnPointEntry.setPointScale(BWirelessTstatSerialScale.make("10;0"));
            } else if (string2.indexOf("Boolean") > -1) {
                bWirelessTstatLearnPointEntry.setPointScale(BWirelessTstatSerialScale.make("1;0"));
            } else if (string2.indexOf("Enum") > -1) {
                bWirelessTstatLearnPointEntry.setPointScale(BWirelessTstatSerialScale.make("1;1"));
            } else {
                bWirelessTstatLearnPointEntry.setPointScale(BWirelessTstatSerialScale.make("10;0"));
            }
        } else {
            bWirelessTstatLearnPointEntry.setPointScale(BWirelessTstatSerialScale.make(string3));
        }
        this.getLearnedPoints().add(SlotPath.escape((String)string), (BValue)bWirelessTstatLearnPointEntry);
    }

    public final BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BWirelessTstatLearnPointsJob() {
    }

    public BWirelessTstatLearnPointsJob(BWirelessTstatPointDeviceExt bWirelessTstatPointDeviceExt) {
        this.ext = bWirelessTstatPointDeviceExt;
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$job$BWirelessTstatLearnPointsJob;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$job$BWirelessTstatLearnPointsJob = BWirelessTstatLearnPointsJob.class("[Lcom.viconics.wirelessTstat.job.BWirelessTstatLearnPointsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"find.png");
    }
}

