/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.job;

import com.viconics.wirelessTstat.BWirelessTstatLearnDeviceEntry;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatDeviceDiscoveryConfig;
import com.viconics.wirelessTstat.messages.WirelessTstatPingRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatPingResponse;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessTstatLearnDevicesJob
extends BSimpleJob {
    public static final Property learnedDevices = BWirelessTstatLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final BIcon icon;
    private static final String LEARN_NAME_PREFIX = "WirelessDevice_";
    private final BWirelessTstatNetwork network;
    private final int firstAddress;
    private final int lastAddress;
    private final BRelTime waitResponseTime;
    private final int retries;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$job$BWirelessTstatLearnDevicesJob;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$BWirelessTstatNetwork;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    void addLearnedDevice(int n, WirelessTstatPingResponse wirelessTstatPingResponse) {
        String string = LEARN_NAME_PREFIX + n;
        if (this.getLearnedDevices().get(string) == null) {
            this.getLearnedDevices().add(string, (BValue)new BWirelessTstatLearnDeviceEntry(wirelessTstatPingResponse));
        }
    }

    public void dispose() {
        try {
            super.dispose();
        }
        catch (ActionInvokeException actionInvokeException) {
            actionInvokeException.printStackTrace();
        }
    }

    public void run(Context context) throws Exception {
        this.progress(0);
        this.logMessage("Starting");
        if (this.network == null) {
            throw new IllegalStateException(lex.getText("learnDeviceJob.networkNotFound"));
        }
        if (this.lastAddress < this.firstAddress) {
            return;
        }
        int n = this.firstAddress;
        while (n < this.lastAddress + 1) {
            if (!this.isAlive()) {
                return;
            }
            try {
                this.progress(100 * (n - this.firstAddress + 1) / (this.lastAddress - this.firstAddress + 1));
                this.logMessage(lex.getText("learnDeviceJob.sendingPingReq", new Object[]{BInteger.make((int)n)}));
                WirelessTstatPingRequest wirelessTstatPingRequest = new WirelessTstatPingRequest(n);
                WirelessTstatPingResponse wirelessTstatPingResponse = (WirelessTstatPingResponse)this.network.sendSync(wirelessTstatPingRequest, this.waitResponseTime, this.retries);
                if (wirelessTstatPingResponse != null && wirelessTstatPingResponse.getSuccessfulResponse()) {
                    this.logMessage(lex.getText("learnDeviceJob.deviceDiscovered", new Object[]{BInteger.make((int)n)}));
                    this.addLearnedDevice(n, wirelessTstatPingResponse);
                }
            }
            catch (Exception exception) {
                WirelessTstatToolkit.error(lex.getText("learnDeviceJob.errorWhileDiscoveringDevices"), exception);
            }
            ++n;
        }
        this.progress(100);
        this.logMessage("Done");
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.network != null) {
            int n = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Wireless Stat Learn Devices: " + string);
            this.network.getLog().setSeverity(n);
        }
    }

    public BWirelessTstatNetwork getNetwork() {
        return this.network;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BWirelessTstatLearnDevicesJob() {
        this.network = null;
        this.firstAddress = 0;
        this.lastAddress = 0;
        this.waitResponseTime = BRelTime.make((long)0L);
        this.retries = 0;
    }

    public BWirelessTstatLearnDevicesJob(BWirelessTstatNetwork bWirelessTstatNetwork, BWirelessTstatDeviceDiscoveryConfig bWirelessTstatDeviceDiscoveryConfig) {
        this.network = bWirelessTstatNetwork;
        this.firstAddress = bWirelessTstatDeviceDiscoveryConfig.getDeviceLowLimit();
        this.lastAddress = bWirelessTstatDeviceDiscoveryConfig.getDeviceHighLimit();
        this.waitResponseTime = bWirelessTstatDeviceDiscoveryConfig.getWaitResponseTime();
        this.retries = bWirelessTstatDeviceDiscoveryConfig.getRetries();
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$job$BWirelessTstatLearnDevicesJob;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$job$BWirelessTstatLearnDevicesJob = BWirelessTstatLearnDevicesJob.class("[Lcom.viconics.wirelessTstat.job.BWirelessTstatLearnDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
        if (clazz2 == null) {
            clazz2 = class$com$viconics$wirelessTstat$BWirelessTstatNetwork = BWirelessTstatLearnDevicesJob.class("[Lcom.viconics.wirelessTstat.BWirelessTstatNetwork;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        icon = BIcon.std((String)"find.png");
    }
}

