/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat.datatypes;

import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.datatypes.BIZigbeeHelperParent;
import com.viconics.wirelessTstat.messages.WirelessTstatReadNetworkConfigRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatReadNetworkConfigResponse;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessTstatZigbeeHelper
extends BComponent {
    public static final int ZIGBEE_CHANNEL_DEFAULT = 10;
    public static final int ZIGBEE_PANID_DEFAULT = 0;
    public static final Property status = BWirelessTstatZigbeeHelper.newProperty((int)3, (BValue)BStatus.down, null);
    public static final Property zigbeePanId = BWirelessTstatZigbeeHelper.newProperty((int)64, (int)0, (BFacets)BFacets.makeNumeric((BUnit)BUnit.NULL, (BNumber)BInteger.make((int)0), (BNumber)BInteger.make((int)500)));
    public static final Property zigbeeChannel = BWirelessTstatZigbeeHelper.newProperty((int)64, (int)10, (BFacets)BFacets.makeNumeric((BUnit)BUnit.NULL, (BNumber)BInteger.make((int)10), (BNumber)BInteger.make((int)26)));
    public static final Action refreshNetworkConfig = BWirelessTstatZigbeeHelper.newAction((int)16, null);
    public static final Type TYPE;
    public static final BWirelessTstatZigbeeHelper DEFAULT;
    private static final BIcon icon;
    private static final int MIN_CHANNEL = 10;
    private static final int MAX_CHANNEL = 26;
    private static final int MIN_PANID = 0;
    private static final int MAX_PANNID = 500;
    private BIZigbeeHelperParent host;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$datatypes$BWirelessTstatZigbeeHelper;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public int getZigbeePanId() {
        return this.getInt(zigbeePanId);
    }

    public void setZigbeePanId(int n) {
        this.setInt(zigbeePanId, n, null);
    }

    public int getZigbeeChannel() {
        return this.getInt(zigbeeChannel);
    }

    public void setZigbeeChannel(int n) {
        this.setInt(zigbeeChannel, n, null);
    }

    public void refreshNetworkConfig() {
        this.invoke(refreshNetworkConfig, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setWirelessHelperParent(BIZigbeeHelperParent bIZigbeeHelperParent) {
        this.host = bIZigbeeHelperParent;
    }

    public BIZigbeeHelperParent getWirelessHelperParent() {
        if (this.host != null) {
            return this.host;
        }
        return (BIZigbeeHelperParent)this.getParent();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIZigbeeHelperParent;
    }

    public void changed(Property property, Context context) {
        if (this.getWirelessHelperParent() != null) {
            this.getWirelessHelperParent().changed(property, context);
        }
        if (!this.isRunning()) {
            return;
        }
        if (!this.getWirelessHelperParent().getSerialPortConfigStatus().isOk()) {
            return;
        }
        if (status.equals((Object)property)) {
            return;
        }
        if (zigbeeChannel.equals((Object)property)) {
            this.computeStatus();
        } else if (zigbeePanId.equals((Object)property)) {
            this.computeStatus();
        } else {
            super.changed(property, context);
        }
        this.getWirelessHelperParent().reopenWirelessPort();
    }

    public void computeStatus() {
        if (this.getWirelessTstatNetwork().isDisabled()) {
            return;
        }
        if (this.getWirelessTstatNetwork().isFatalFault()) {
            return;
        }
        if (!this.getWirelessTstatNetwork().getSerialPortConfig().getStatus().isOk()) {
            this.setStatus(BStatus.down);
            return;
        }
        if (this.getZigbeeChannel() == 10) {
            this.setStatus(BStatus.down);
            this.getWirelessTstatNetwork().setStatus(BStatus.down);
            this.getWirelessTstatNetwork().setFaultCause(WirelessTstatToolkit.getText("BWirelessTstatZigbeeHelper.zigbeeChannelIsDefaultMessage", new Object[]{BInteger.make((int)this.getZigbeeChannel())}));
            return;
        }
        if (this.getZigbeePanId() == 0) {
            this.setStatus(BStatus.down);
            this.getWirelessTstatNetwork().setStatus(BStatus.down);
            this.getWirelessTstatNetwork().setFaultCause(WirelessTstatToolkit.getText("BWirelessTstatZigbeeHelper.zigbeePanidIsDefaultMessage", new Object[]{BInteger.make((int)this.getZigbeePanId())}));
            return;
        }
        if (!this.isChannelValid()) {
            this.setStatus(BStatus.fault);
            this.getWirelessTstatNetwork().setStatus(BStatus.fault);
            this.getWirelessTstatNetwork().setFaultCause(WirelessTstatToolkit.getText("BWirelessTstatZigbeeHelper.invalidChannel"));
            return;
        }
        if (!this.isPanIdValid()) {
            this.setStatus(BStatus.fault);
            this.getWirelessTstatNetwork().setStatus(BStatus.fault);
            this.getWirelessTstatNetwork().setFaultCause(WirelessTstatToolkit.getText("BWirelessTstatZigbeeHelper.invalidPanid"));
            return;
        }
        this.setStatus(BStatus.ok);
        this.getWirelessTstatNetwork().setStatus(BStatus.ok);
        this.getWirelessTstatNetwork().setFaultCause("");
    }

    public boolean isChannelValid() {
        boolean bl = false;
        if (this.getZigbeeChannel() >= 10 && this.getZigbeeChannel() <= 26) {
            bl = true;
        }
        return bl;
    }

    public boolean isPanIdValid() {
        boolean bl = false;
        if (this.getZigbeePanId() >= 0 && this.getZigbeePanId() <= 500) {
            bl = true;
        }
        return bl;
    }

    public String toString(Context context) {
        return "Zigbee partameters configuration";
    }

    public BWirelessTstatNetwork getWirelessTstatNetwork() {
        return (BWirelessTstatNetwork)this.getParent();
    }

    public void doRefreshNetworkConfig() {
        BWirelessTstatNetwork bWirelessTstatNetwork = this.getWirelessTstatNetwork();
        if (bWirelessTstatNetwork == null) {
            return;
        }
        if (!bWirelessTstatNetwork.isRunning()) {
            return;
        }
        WirelessTstatReadNetworkConfigRequest wirelessTstatReadNetworkConfigRequest = new WirelessTstatReadNetworkConfigRequest();
        WirelessTstatReadNetworkConfigResponse wirelessTstatReadNetworkConfigResponse = (WirelessTstatReadNetworkConfigResponse)this.getWirelessTstatNetwork().sendSync(wirelessTstatReadNetworkConfigRequest);
        if (wirelessTstatReadNetworkConfigResponse == null) {
            this.getWirelessTstatNetwork().pingFail(WirelessTstatToolkit.getText("commCard.error.timeout"));
            this.getWirelessTstatNetwork().setFaultCause(WirelessTstatToolkit.getText("commCard.error.timeout"));
            this.setStatus(BStatus.down);
            return;
        }
        if (!wirelessTstatReadNetworkConfigResponse.getSuccessfulResponse()) {
            this.getWirelessTstatNetwork().pingFail(wirelessTstatReadNetworkConfigResponse.getErrorString());
            this.getWirelessTstatNetwork().setFaultCause(wirelessTstatReadNetworkConfigResponse.getErrorString());
            this.setStatus(BStatus.down);
            return;
        }
        this.setZigbeeChannel(wirelessTstatReadNetworkConfigResponse.getChannel());
        this.setZigbeePanId(wirelessTstatReadNetworkConfigResponse.getPanId());
        this.setStatus(BStatus.ok);
        this.getWirelessTstatNetwork().setFaultCause("");
        this.getWirelessTstatNetwork().pingOk();
        this.getWirelessTstatNetwork().getWirelessParametersConfig().computeStatus();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$datatypes$BWirelessTstatZigbeeHelper;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$datatypes$BWirelessTstatZigbeeHelper = BWirelessTstatZigbeeHelper.class("[Lcom.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeHelper;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = new BWirelessTstatZigbeeHelper();
        icon = BIcon.std((String)"commConfig.png");
    }
}

