/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BBasicCoalescingWorker;
import com.tridium.basicdriver.util.BBasicWorker;
import com.tridium.sys.Nre;
import com.tridium.util.ComponentTreeCursor;
import com.viconics.wirelessTstat.BWirelessTstatDevice;
import com.viconics.wirelessTstat.BWirelessTstatDeviceFolder;
import com.viconics.wirelessTstat.comm.BWirelessTstatUnsolicitedReceive;
import com.viconics.wirelessTstat.comm.WirelessTstatComm;
import com.viconics.wirelessTstat.comm.WirelessTstatCommReceiver;
import com.viconics.wirelessTstat.comm.WirelessTstatCommTransmitter;
import com.viconics.wirelessTstat.datatypes.BIZigbeeHelperParent;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatCoordAddressInfo;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatCoordModuleInfo;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatDeviceDiscoveryConfig;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatIEEEAddress;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatPingMonitor;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatSerialHelper;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeAddress;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeHelper;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.job.BWirelessTstatAutoInstallAllPointsJob;
import com.viconics.wirelessTstat.job.BWirelessTstatLearnDevicesJob;
import com.viconics.wirelessTstat.messages.WirelessTstatConfigureNetworkRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatConfigureNetworkResponse;
import com.viconics.wirelessTstat.messages.WirelessTstatIdentifyRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatIdentifyResponse;
import com.viconics.wirelessTstat.messages.WirelessTstatReceivedMessage;
import com.viconics.wirelessTstat.messages.WirelessTstatStartNetworkRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatStartNetworkResponse;
import com.viconics.wirelessTstat.point.BWirelessTstatCovManager;
import com.viconics.wirelessTstat.point.BWirelessTstatPollScheduler;
import com.viconics.wirelessTstat.point.BWirelessTstatProxyExt;
import com.viconics.wirelessTstat.point.BWirelessTstatTuningPolicyMap;
import com.viconics.wirelessTstat.unsolicited.WirelessTstatDuplicateCommMsg;
import com.viconics.wirelessTstat.unsolicited.WirelessTstatIdentifyMsg;
import com.viconics.wirelessTstat.utils.BConfigStatus;
import com.viconics.wirelessTstat.utils.BWirelessTstatBasicCoalescingWorker;
import com.viconics.wirelessTstat.utils.BWirelessTstatBasicWorker;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import com.viconics.wirelessTstat.xml.XWirelessTstatFile;
import java.util.Hashtable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessTstatNetwork
extends BSerialNetwork
implements BIZigbeeHelperParent,
WirelessTstatConst {
    public static final Action upload = BWirelessTstatNetwork.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BWirelessTstatNetwork.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Property faultCause = BWirelessTstatNetwork.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property pollScheduler = BWirelessTstatNetwork.newProperty((int)0, (BValue)new BWirelessTstatPollScheduler(), null);
    public static final Property tuningPolicies = BWirelessTstatNetwork.newProperty((int)0, (BValue)new BWirelessTstatTuningPolicyMap(), null);
    public static final Property interMessageDelay = BWirelessTstatNetwork.newProperty((int)5, (BValue)BRelTime.make((long)35L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property monitor = BWirelessTstatNetwork.newProperty((int)0, (BValue)new BWirelessTstatPingMonitor(), null);
    public static final Property retryCount = BWirelessTstatNetwork.newProperty((int)0, (int)3, null);
    public static final Property responseTimeout = BWirelessTstatNetwork.newProperty((int)0, (BValue)BRelTime.make((long)8000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.make((long)10000L)));
    public static final Property serialPortConfig = BWirelessTstatNetwork.newProperty((int)0, (BValue)new BWirelessTstatSerialHelper(), null);
    public static final Property dispatcher = BWirelessTstatNetwork.newProperty((int)4, (BValue)new BWirelessTstatBasicWorker(), null);
    public static final Property worker = BWirelessTstatNetwork.newProperty((int)4, (BValue)new BWirelessTstatBasicCoalescingWorker(), null);
    public static final Property writeWorker = BWirelessTstatNetwork.newProperty((int)4, (BValue)new BWirelessTstatBasicCoalescingWorker(), null);
    public static final Property covManager = BWirelessTstatNetwork.newProperty((int)0, (BValue)new BWirelessTstatCovManager(), null);
    public static final Property wirelessParametersConfig = BWirelessTstatNetwork.newProperty((int)64, (BValue)BWirelessTstatZigbeeHelper.DEFAULT, null);
    public static final Property unsolicitedReceiveHandler = BWirelessTstatNetwork.newProperty((int)4, (BValue)new BWirelessTstatUnsolicitedReceive(), null);
    public static final Property communicationModuleInfo = BWirelessTstatNetwork.newProperty((int)320, (BValue)BWirelessTstatCoordModuleInfo.DEFAULT, null);
    public static final Property addressInfo = BWirelessTstatNetwork.newProperty((int)320, (BValue)BWirelessTstatCoordAddressInfo.DEFAULT, null);
    public static final Property deviceDiscoverConfig = BWirelessTstatNetwork.newProperty((int)68, (BValue)new BWirelessTstatDeviceDiscoveryConfig(), null);
    public static final Action lookupDeviceByAddress = BWirelessTstatNetwork.newAction((int)4, (BValue)BInteger.make((int)0), null);
    public static final Action lookupDeviceByIEEEAddress = BWirelessTstatNetwork.newAction((int)4, (BValue)BWirelessTstatIEEEAddress.DEFAULT, null);
    public static final Action lookupDeviceByZigbeeAddress = BWirelessTstatNetwork.newAction((int)4, (BValue)BWirelessTstatZigbeeAddress.DEFAULT, null);
    public static final Action submitDeviceDiscoveryJob = BWirelessTstatNetwork.newAction((int)4, (BValue)new BWirelessTstatDeviceDiscoveryConfig(), null);
    public static final Action submitInstallPointsJob = BWirelessTstatNetwork.newAction((int)4, null);
    public static final Type TYPE;
    private static XWirelessTstatFile xdatabase;
    private static BWirelessTstatNetwork wirelessTstatNetwork;
    private boolean debug;
    private boolean alwyasSubsctibed;
    private final Hashtable byAddress;
    private final Hashtable byZigbeeAddress;
    private final Hashtable byIeeeAddress;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$BWirelessTstatDevice;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public BBasicWorker getDispatcher() {
        return (BBasicWorker)this.get(dispatcher);
    }

    public void setDispatcher(BBasicWorker bBasicWorker) {
        this.set(dispatcher, (BValue)bBasicWorker, null);
    }

    public BBasicWorker getWorker() {
        return (BBasicWorker)this.get(worker);
    }

    public void setWorker(BBasicWorker bBasicWorker) {
        this.set(worker, (BValue)bBasicWorker, null);
    }

    public BBasicCoalescingWorker getWriteWorker() {
        return (BBasicCoalescingWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BBasicCoalescingWorker bBasicCoalescingWorker) {
        this.set(writeWorker, (BValue)bBasicCoalescingWorker, null);
    }

    public BWirelessTstatCovManager getCovManager() {
        return (BWirelessTstatCovManager)this.get(covManager);
    }

    public void setCovManager(BWirelessTstatCovManager bWirelessTstatCovManager) {
        this.set(covManager, (BValue)bWirelessTstatCovManager, null);
    }

    public BWirelessTstatZigbeeHelper getWirelessParametersConfig() {
        return (BWirelessTstatZigbeeHelper)this.get(wirelessParametersConfig);
    }

    public void setWirelessParametersConfig(BWirelessTstatZigbeeHelper bWirelessTstatZigbeeHelper) {
        this.set(wirelessParametersConfig, (BValue)bWirelessTstatZigbeeHelper, null);
    }

    public BWirelessTstatUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BWirelessTstatUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BWirelessTstatUnsolicitedReceive bWirelessTstatUnsolicitedReceive) {
        this.set(unsolicitedReceiveHandler, (BValue)bWirelessTstatUnsolicitedReceive, null);
    }

    public BWirelessTstatCoordModuleInfo getCommunicationModuleInfo() {
        return (BWirelessTstatCoordModuleInfo)this.get(communicationModuleInfo);
    }

    public void setCommunicationModuleInfo(BWirelessTstatCoordModuleInfo bWirelessTstatCoordModuleInfo) {
        this.set(communicationModuleInfo, (BValue)bWirelessTstatCoordModuleInfo, null);
    }

    public BWirelessTstatCoordAddressInfo getAddressInfo() {
        return (BWirelessTstatCoordAddressInfo)this.get(addressInfo);
    }

    public void setAddressInfo(BWirelessTstatCoordAddressInfo bWirelessTstatCoordAddressInfo) {
        this.set(addressInfo, (BValue)bWirelessTstatCoordAddressInfo, null);
    }

    public BWirelessTstatDeviceDiscoveryConfig getDeviceDiscoverConfig() {
        return (BWirelessTstatDeviceDiscoveryConfig)this.get(deviceDiscoverConfig);
    }

    public void setDeviceDiscoverConfig(BWirelessTstatDeviceDiscoveryConfig bWirelessTstatDeviceDiscoveryConfig) {
        this.set(deviceDiscoverConfig, (BValue)bWirelessTstatDeviceDiscoveryConfig, null);
    }

    public BWirelessTstatDevice lookupDeviceByAddress(BInteger bInteger) {
        return (BWirelessTstatDevice)this.invoke(lookupDeviceByAddress, (BValue)bInteger, null);
    }

    public BWirelessTstatDevice lookupDeviceByIEEEAddress(BWirelessTstatIEEEAddress bWirelessTstatIEEEAddress) {
        return (BWirelessTstatDevice)this.invoke(lookupDeviceByIEEEAddress, (BValue)bWirelessTstatIEEEAddress, null);
    }

    public BWirelessTstatDevice lookupDeviceByZigbeeAddress(BWirelessTstatZigbeeAddress bWirelessTstatZigbeeAddress) {
        return (BWirelessTstatDevice)this.invoke(lookupDeviceByZigbeeAddress, (BValue)bWirelessTstatZigbeeAddress, null);
    }

    public BOrd submitDeviceDiscoveryJob(BWirelessTstatDeviceDiscoveryConfig bWirelessTstatDeviceDiscoveryConfig) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)bWirelessTstatDeviceDiscoveryConfig, null);
    }

    public BOrd submitInstallPointsJob() {
        return (BOrd)this.invoke(submitInstallPointsJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BWirelessTstatNetwork get() {
        return wirelessTstatNetwork;
    }

    public Type getDeviceType() {
        return BWirelessTstatDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BWirelessTstatDeviceFolder.TYPE;
    }

    /*
     * Unable to fully structure code
     */
    public BWirelessTstatDevice[] getWirelessDevice() {
        v0 = BWirelessTstatNetwork.class$com$viconics$wirelessTstat$BWirelessTstatDevice;
        if (v0 == null) {
            v0 = BWirelessTstatNetwork.class$com$viconics$wirelessTstat$BWirelessTstatDevice = BWirelessTstatNetwork.class("[Lcom.viconics.wirelessTstat.BWirelessTstatDevice;", false);
        }
        var1_1 = new Array(v0);
        var2_2 = new ComponentTreeCursor((BComponent)this, null);
        if (true) ** GOTO lbl10
        do {
            var1_1.add((Object)var2_2.get());
lbl10:
            // 2 sources

            if ((v1 = BWirelessTstatNetwork.class$com$viconics$wirelessTstat$BWirelessTstatDevice) != null) continue;
            v1 = BWirelessTstatNetwork.class("[Lcom.viconics.wirelessTstat.BWirelessTstatDevice;", false);
        } while (var2_2.next(v1));
        return (BWirelessTstatDevice[])var1_1.trim();
    }

    public void started() throws Exception {
        this.setDebug();
        this.setSubscription();
        this.setSerialConfig();
        this.getWirelessParametersConfig().setWirelessHelperParent(this);
        super.started();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (Context.decoding.equals(context)) {
            return;
        }
        if ((property.getName().equals("portName") && this.getEnabled() || property.equals((Object)enabled) && !this.getEnabled()) && !this.getStatus().isOk() && !this.getStatus().isDisabled()) {
            try {
                this.stopComm();
                this.startComm();
            }
            catch (Exception exception) {
                System.out.println("Catching exception while trying to start network");
            }
        }
    }

    public void startComm() throws Exception {
        try {
            super.startComm();
            if (!this.isRunning()) {
                return;
            }
            this.getWirelessParametersConfig().refreshNetworkConfig();
        }
        catch (Exception exception) {
            this.configFail(exception.getMessage());
        }
    }

    protected Comm makeComm() {
        return new WirelessTstatComm(this, new WirelessTstatCommReceiver(), new WirelessTstatCommTransmitter());
    }

    public final void reopenWirelessPort() {
        WirelessTstatConfigureNetworkRequest wirelessTstatConfigureNetworkRequest = new WirelessTstatConfigureNetworkRequest(this.getZigbeeChannel(), this.getZigbeePanId());
        WirelessTstatConfigureNetworkResponse wirelessTstatConfigureNetworkResponse = (WirelessTstatConfigureNetworkResponse)this.sendSync(wirelessTstatConfigureNetworkRequest, BRelTime.make((long)300L), 3);
        if (wirelessTstatConfigureNetworkResponse != null) {
            if (wirelessTstatConfigureNetworkResponse.getSuccessfulResponse()) {
                WirelessTstatStartNetworkRequest wirelessTstatStartNetworkRequest = new WirelessTstatStartNetworkRequest();
                WirelessTstatStartNetworkResponse wirelessTstatStartNetworkResponse = (WirelessTstatStartNetworkResponse)this.sendSync(wirelessTstatStartNetworkRequest, BRelTime.make((long)300L), 3);
                if (wirelessTstatStartNetworkResponse != null) {
                    if (wirelessTstatStartNetworkResponse.getSuccessfulResponse()) {
                        this.getWirelessParametersConfig().computeStatus();
                    } else {
                        this.configFail(WirelessTstatToolkit.getText("networkConfigError.returnedError", new Object[]{wirelessTstatStartNetworkResponse.getErrorString()}));
                        this.getWirelessParametersConfig().setStatus(BStatus.fault);
                    }
                } else {
                    this.configFail(WirelessTstatToolkit.getText("networkConfigError.timeout"));
                    this.getWirelessParametersConfig().setStatus(BStatus.fault);
                }
            } else {
                this.configFail(WirelessTstatToolkit.getText("networkConfigError.returnedError", new Object[]{wirelessTstatConfigureNetworkResponse.getErrorString()}));
                this.getWirelessParametersConfig().setStatus(BStatus.fault);
            }
        } else {
            this.configFail(WirelessTstatToolkit.getText("networkConfigError.timeout"));
            this.getWirelessParametersConfig().setStatus(BStatus.fault);
        }
    }

    public BStatus getSerialPortConfigStatus() {
        return this.getSerialPortConfig().getStatus();
    }

    private final void setSerialConfig() {
        BSerialHelper bSerialHelper = this.getSerialPortConfig();
        bSerialHelper.setBaudRate((BBaudRate)BSerialBaudRate.baud57600);
        bSerialHelper.setDataBits(BSerialDataBits.dataBits8);
        bSerialHelper.setStopBits(BSerialStopBits.stopBit1);
        bSerialHelper.setParity(BSerialParity.none);
        bSerialHelper.setFlowControlMode(BSerialFlowControlMode.none);
        String string = Nre.getHostId();
        if (string.indexOf("Win-") > -1) {
            System.out.println("Win32 host type detected, disabling flow control");
        } else {
            bSerialHelper.setFlowControlMode(BSerialFlowControlMode.rtsCtsOnInput);
            bSerialHelper.setFlowControlMode(BSerialFlowControlMode.rtsCtsOnOutput);
        }
        this.setSerialPortConfig(bSerialHelper);
    }

    public void processUnsolicitedResponse(WirelessTstatReceivedMessage wirelessTstatReceivedMessage) {
        switch (wirelessTstatReceivedMessage.getMsgType()) {
            case 3842: {
                WirelessTstatDuplicateCommMsg wirelessTstatDuplicateCommMsg = new WirelessTstatDuplicateCommMsg(wirelessTstatReceivedMessage.getBytes(), wirelessTstatReceivedMessage.getLength());
                this.sendSync((Message)wirelessTstatDuplicateCommMsg);
                BWirelessTstatDevice bWirelessTstatDevice = this.lookupDevice(wirelessTstatDuplicateCommMsg.getDuplicatedCommAddress());
                if (bWirelessTstatDevice != null) {
                    bWirelessTstatDevice.setConfigStatus(BConfigStatus.make(bWirelessTstatDevice.getConfigStatus(), 2, true));
                }
                wirelessTstatDuplicateCommMsg = null;
                break;
            }
            case 0: {
                WirelessTstatIdentifyMsg wirelessTstatIdentifyMsg = new WirelessTstatIdentifyMsg(wirelessTstatReceivedMessage.getBytes(), wirelessTstatReceivedMessage.getLength());
                this.sendSync((Message)wirelessTstatIdentifyMsg);
                break;
            }
            default: {
                WirelessTstatToolkit.trace(WirelessTstatToolkit.getText("network.error.unexpectedMessage", new Object[]{BInteger.make((int)wirelessTstatReceivedMessage.getCommAddress()), wirelessTstatReceivedMessage.toString()}));
            }
        }
    }

    public void registerDevice(BWirelessTstatDevice bWirelessTstatDevice) {
        if (bWirelessTstatDevice.getAddress() != 0) {
            this.byAddress.put(BInteger.make((int)bWirelessTstatDevice.getAddress()), bWirelessTstatDevice);
            this.byIeeeAddress.put(bWirelessTstatDevice.getIEEEAddress(), bWirelessTstatDevice);
            this.byZigbeeAddress.put(bWirelessTstatDevice.getZigbeeAddress(), bWirelessTstatDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterDevice(BWirelessTstatDevice bWirelessTstatDevice) {
        BWirelessTstatNetwork bWirelessTstatNetwork = this;
        synchronized (bWirelessTstatNetwork) {
            this.byAddress.remove(BInteger.make((int)bWirelessTstatDevice.getAddress()));
            this.byIeeeAddress.remove((Object)bWirelessTstatDevice.getIEEEAddress());
            this.byZigbeeAddress.remove((Object)bWirelessTstatDevice.getZigbeeAddress());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDevice(BWirelessTstatDevice bWirelessTstatDevice) {
        BWirelessTstatNetwork bWirelessTstatNetwork = this;
        synchronized (bWirelessTstatNetwork) {
            this.byAddress.values().remove(bWirelessTstatDevice);
            this.byAddress.put(BInteger.make((int)bWirelessTstatDevice.getAddress()), bWirelessTstatDevice);
            this.byIeeeAddress.values().remove(bWirelessTstatDevice);
            this.byIeeeAddress.put(bWirelessTstatDevice.getIEEEAddress(), bWirelessTstatDevice);
            this.byZigbeeAddress.values().remove(bWirelessTstatDevice);
            this.byZigbeeAddress.put(bWirelessTstatDevice.getZigbeeAddress(), bWirelessTstatDevice);
            return;
        }
    }

    public BWirelessTstatDevice lookupDevice(int n) {
        return this.doLookupDeviceByAddress(BInteger.make((int)n));
    }

    public XWirelessTstatFile getTStatDatabase() {
        return xdatabase;
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        if (this.isDisabled()) {
            return;
        }
        this.getWirelessParametersConfig().refreshNetworkConfig();
        WirelessTstatIdentifyRequest wirelessTstatIdentifyRequest = new WirelessTstatIdentifyRequest();
        WirelessTstatIdentifyResponse wirelessTstatIdentifyResponse = (WirelessTstatIdentifyResponse)this.sendSync(wirelessTstatIdentifyRequest, BRelTime.make((long)300L), 3);
        if (wirelessTstatIdentifyResponse != null && wirelessTstatIdentifyResponse.getSuccessfulResponse()) {
            this.getCommunicationModuleInfo().setZigbeeModuleMinorVersion(wirelessTstatIdentifyResponse.getModuleMinFirmwareNumber());
            this.getCommunicationModuleInfo().setZigbeeModuleMajorVersion(wirelessTstatIdentifyResponse.getModuleMajFirmwareNumber());
            this.getCommunicationModuleInfo().setHardwareRevision(wirelessTstatIdentifyResponse.getChipRevision());
            this.getAddressInfo().setZigbeeAddress(wirelessTstatIdentifyResponse.getZigbeeAddress().toString());
            this.getAddressInfo().setIEEEAddress(wirelessTstatIdentifyResponse.getIEEEAddress().toString());
        }
    }

    public int getZigbeeChannel() {
        return this.getWirelessParametersConfig().getZigbeeChannel();
    }

    public void setZigbeeChannel(int n) {
        this.getWirelessParametersConfig().setZigbeeChannel(n);
    }

    public int getZigbeePanId() {
        return this.getWirelessParametersConfig().getZigbeePanId();
    }

    public void setZigbeePanId(int n) {
        this.getWirelessParametersConfig().setZigbeePanId(n);
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BWirelessTstatNetwork.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.getMonitor());
        array.add((Object)this.getPollScheduler());
        array.add((Object)this.getTuningPolicies());
        int n = 0;
        while (n < bINavNodeArray.length) {
            array.add((Object)bINavNodeArray[n]);
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    public BWirelessTstatDevice doLookupDeviceByAddress(BInteger bInteger) {
        if (bInteger.getInt() == 0) {
            return null;
        }
        BWirelessTstatDevice bWirelessTstatDevice = (BWirelessTstatDevice)this.byAddress.get(bInteger);
        return bWirelessTstatDevice;
    }

    public BWirelessTstatDevice doLookupDeviceByIEEEAddress(BWirelessTstatIEEEAddress bWirelessTstatIEEEAddress) {
        if (bWirelessTstatIEEEAddress.isZero()) {
            return null;
        }
        BWirelessTstatDevice bWirelessTstatDevice = (BWirelessTstatDevice)this.byIeeeAddress.get((Object)bWirelessTstatIEEEAddress);
        return bWirelessTstatDevice;
    }

    public BWirelessTstatDevice doLookupDeviceByZigbeeAddress(BWirelessTstatZigbeeAddress bWirelessTstatZigbeeAddress) {
        if (bWirelessTstatZigbeeAddress.isZero()) {
            return null;
        }
        BWirelessTstatDevice bWirelessTstatDevice = (BWirelessTstatDevice)this.byZigbeeAddress.get((Object)bWirelessTstatZigbeeAddress);
        return bWirelessTstatDevice;
    }

    public BOrd doSubmitDeviceDiscoveryJob(BWirelessTstatDeviceDiscoveryConfig bWirelessTstatDeviceDiscoveryConfig) {
        this.setDeviceDiscoverConfig(bWirelessTstatDeviceDiscoveryConfig);
        return new BWirelessTstatLearnDevicesJob(this, bWirelessTstatDeviceDiscoveryConfig).submit(null);
    }

    public BOrd doSubmitInstallPointsJob(Context context) {
        if (this.getNetwork().isFatalFault()) {
            return null;
        }
        return new BWirelessTstatAutoInstallAllPointsJob(this).submit(context);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        int n;
        Object object;
        Object object2;
        if (this.getDebug()) {
            Object e;
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Table byAddress (" + this.byAddress.size() + ')'), 4);
            spyWriter.w((Object)"<tr>").th((Object)"Key").th((Object)"Address").th((Object)"Zigbee").th((Object)"IEEE").w((Object)"</tr>\n");
            object2 = this.byAddress.keys();
            while (object2.hasMoreElements()) {
                e = object2.nextElement();
                object = (BWirelessTstatDevice)this.byAddress.get(e);
                spyWriter.tr(e, (Object)BInteger.make((int)((BWirelessTstatDevice)object).getAddress()), (Object)((BWirelessTstatDevice)object).getZigbeeAddress(), (Object)((BWirelessTstatDevice)object).getIEEEAddress());
            }
            spyWriter.endTable();
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Table byIeeeAddress (" + this.byIeeeAddress.size() + ')'), 4);
            spyWriter.w((Object)"<tr>").th((Object)"Key").th((Object)"Address").th((Object)"Zigbee").th((Object)"IEEE").w((Object)"</tr>\n");
            object2 = this.byIeeeAddress.keys();
            while (object2.hasMoreElements()) {
                e = object2.nextElement();
                object = (BWirelessTstatDevice)this.byIeeeAddress.get(e);
                spyWriter.tr(e, (Object)BInteger.make((int)((BWirelessTstatDevice)object).getAddress()), (Object)((BWirelessTstatDevice)object).getZigbeeAddress(), (Object)((BWirelessTstatDevice)object).getIEEEAddress());
            }
            spyWriter.endTable();
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Table byZigbeeAddress (" + this.byZigbeeAddress.size() + ')'), 4);
            spyWriter.w((Object)"<tr>").th((Object)"Key").th((Object)"Address").th((Object)"Zigbee").th((Object)"IEEE").w((Object)"</tr>\n");
            object2 = this.byZigbeeAddress.keys();
            while (object2.hasMoreElements()) {
                e = object2.nextElement();
                object = (BWirelessTstatDevice)this.byZigbeeAddress.get(e);
                spyWriter.tr(e, (Object)BInteger.make((int)((BWirelessTstatDevice)object).getAddress()), (Object)((BWirelessTstatDevice)object).getZigbeeAddress(), (Object)((BWirelessTstatDevice)object).getIEEEAddress());
            }
            spyWriter.endTable();
            object2 = this.getWirelessDevice();
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Table device list (" + ((Object)object2).length + ')'), 4);
            spyWriter.w((Object)"<tr>").th((Object)"Index").th((Object)"Address").th((Object)"Zigbee").th((Object)"IEEE").w((Object)"</tr>\n");
            n = 0;
            while (n < ((Object)object2).length) {
                object = object2[n];
                spyWriter.tr((Object)BInteger.make((int)n), (Object)BInteger.make((int)((BWirelessTstatDevice)object).getAddress()), (Object)((BWirelessTstatDevice)object).getZigbeeAddress(), (Object)((BWirelessTstatDevice)object).getIEEEAddress());
                ++n;
            }
            spyWriter.endTable();
        }
        spyWriter.startProps();
        object2 = this.getWirelessDevice();
        n = 0;
        while (n < ((BWirelessTstatDevice[])object2).length) {
            object = object2[n];
            spyWriter.trTitle((Object)object.getDisplayName(null), 2);
            BControlPoint[] bControlPointArray = ((BWirelessTstatDevice)object).getPoints().getPoints();
            int n2 = 0;
            while (n2 < bControlPointArray.length) {
                BControlPoint bControlPoint = bControlPointArray[n2];
                if (!bControlPoint.getStatus().isOk() && !bControlPoint.getStatus().isStale()) {
                    spyWriter.prop((Object)bControlPoint.getDisplayName(null), (Object)(bControlPoint.getStatus() + " : " + ((BWirelessTstatProxyExt)bControlPoint.getProxyExt()).getFaultCause()));
                }
                ++n2;
            }
            ++n;
        }
        try {
            spyWriter.trTitle((Object)"Communication Statistics", 2);
            spyWriter.prop((Object)"Success Count", (Object)BLong.make((long)((WirelessTstatComm)this.getComm()).getSuccessCount()));
            spyWriter.prop((Object)"Failed 1 Time", (Object)BLong.make((long)((WirelessTstatComm)this.getComm()).getFailedOnceCount()));
            spyWriter.prop((Object)"Failed 2 Times", (Object)BLong.make((long)((WirelessTstatComm)this.getComm()).getFailedTwiceCount()));
            spyWriter.prop((Object)"Failed 3 Times", (Object)BLong.make((long)((WirelessTstatComm)this.getComm()).getFailedThirdCount()));
            spyWriter.prop((Object)"Failed 4 Times", (Object)BLong.make((long)((WirelessTstatComm)this.getComm()).getFailedFourthCount()));
            spyWriter.prop((Object)"Failed Other", (Object)BLong.make((long)((WirelessTstatComm)this.getComm()).getFailedOthersCount()));
            spyWriter.endProps();
        }
        catch (Exception exception) {}
        this.getDispatcher().getWorker().spy(spyWriter);
        this.getWorker().getWorker().spy(spyWriter);
        this.getWriteWorker().getWorker().spy(spyWriter);
        super.spy(spyWriter);
    }

    public boolean getDebug() {
        return this.debug;
    }

    private final void setDebug() {
        BBoolean bBoolean = (BBoolean)this.get("debug");
        if (bBoolean != null) {
            this.debug = bBoolean.getBoolean();
        }
    }

    public boolean getSubscription() {
        return this.alwyasSubsctibed;
    }

    private final void setSubscription() {
        BBoolean bBoolean = (BBoolean)this.get("subscription");
        if (bBoolean != null) {
            this.alwyasSubsctibed = bBoolean.getBoolean();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.alwyasSubsctibed = false;
        this.byAddress = new Hashtable();
        this.byZigbeeAddress = new Hashtable();
        this.byIeeeAddress = new Hashtable();
    }

    public BWirelessTstatNetwork() {
        this.this();
        wirelessTstatNetwork = this;
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$BWirelessTstatNetwork = BWirelessTstatNetwork.class("[Lcom.viconics.wirelessTstat.BWirelessTstatNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        xdatabase = new XWirelessTstatFile();
    }
}

